/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.CheckBoxPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.PrimitiveInputComponents;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class CheckPanelPhase
extends PrimitiveInputComponents
implements PhaseInputPanelInterface {
    private CheckBoxPhase checkbox;
    public static String NO_SELECTION = ConstParameters.NO_SELECTION;
    private static Logger logger = Logger.getLogger((String)CheckPanelPhase.class.getName());
    private String[] fullName;
    private String title;
    private Vector dupli = null;
    private boolean defaultValue = false;

    public CheckPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.createGUI();
        this.addListeners(parent);
    }

    public CheckPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.createGUI();
    }

    public CheckPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, EventListener parent, boolean defaultValue) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.defaultValue = defaultValue;
        this.createGUI();
        this.addListeners(parent);
    }

    public CheckPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, boolean defaultValue) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.defaultValue = defaultValue;
        this.createGUI();
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, 0));
        this.createComboBox();
        super.add(this.checkbox);
    }

    private void createComboBox() {
        this.checkbox = new CheckBoxPhase(this.inputSpecifications, this.inputInterface, this.title);
        this.checkbox.setSelected(this.defaultValue);
        String value = this.entry.getValue().trim();
        if (value.length() != 0) {
            if (InputInterface.isTrue(value)) {
                this.checkbox.setSelected(true);
            } else {
                this.checkbox.setSelected(false);
            }
        }
    }

    @Override
    public void addListeners(EventListener listener) {
        if (listener instanceof ActionListener) {
            this.checkbox.addActionListener((ActionListener)listener);
        }
    }

    public void registerDisabableGUI(JComponent jcomponent) {
        this.checkbox.removeListeners();
        this.checkbox.setDisabableGUI(jcomponent);
        this.checkbox.disableRegisteredGUI();
        this.checkbox.restoreListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkbox.setEnabled(enabled);
    }

    @Override
    public String getValue() {
        String ret = "0";
        if (this.checkbox.isSelected()) {
            ret = "1";
        }
        return ret;
    }

    @Override
    public String getUnit() {
        return new String();
    }

    public JCheckBox getComboBox() {
        return this.checkbox;
    }
}

