/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs.prefseditor;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.common.ChoicePanel;
import ciss.phase_viewer.common.ElementDef;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.plugins.viewer.prefs.prefseditor.ACVEditors;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class ElementEditor
extends ACVEditors {
    private double[] dcovrad;
    private float[] frad;
    private float[][] fcolor;
    private boolean[] hbond;
    private double[] hbondRad;
    private ChoicePanel element_cp;
    private JButton btnelementcolor;
    private InputPanel covrad_ip;
    private InputPanel atsize_ip;
    private InputPanel hbondmax_ip;
    private ElementDef[] def;

    protected ElementEditor(MainPanel mp) {
        super(mp);
    }

    @Override
    protected void createGUI() {
        this.dcovrad = new double[this.NumEl];
        this.frad = new float[this.NumEl];
        this.fcolor = new float[this.NumEl][3];
        this.hbond = new boolean[this.NumEl];
        this.hbondRad = new double[this.NumEl];
        ElementInfo einfo = this.mACVD.getEInfo();
        this.def = einfo.getElementDef();
        int i = 0;
        while (i < this.def.length) {
            this.hbond[i] = this.def[i].hasHbond();
            this.hbondRad[i] = this.hbond[i] ? this.def[i].getMaxHbondDistance() : 0.0;
            ++i;
        }
        i = 0;
        while (i < this.NumEl) {
            this.dcovrad[i] = this.mACVD.getCovRad()[i];
            this.frad[i] = this.mACVD.getRad()[i];
            int j = 0;
            while (j < 3) {
                this.fcolor[i][j] = this.mACVD.getColor()[i][j];
                ++j;
            }
            ++i;
        }
        String space = new String();
        space = "                 ";
        String[] element_symbol = new String[this.NumEl];
        int i2 = 0;
        while (i2 < this.NumEl) {
            element_symbol[i2] = String.valueOf(this.mp.getJ3DDataManager().getElement()[i2]) + space;
            ++i2;
        }
        element_symbol = this.mp.getJ3DDataManager().getElement();
        ElementEditor pelement = this;
        pelement.setLayout(new BoxLayout(pelement, 1));
        JPanel psymbol = new JPanel();
        psymbol.setLayout(new GridLayout(1, 1, 1, 1));
        this.element_cp = new ChoicePanel("element", element_symbol);
        psymbol.add(this.element_cp);
        JPanel patomcolor = new JPanel();
        patomcolor.setBorder(new TitledBorder("atom color"));
        this.btnelementcolor = new JButton("choose ...");
        patomcolor.add(this.btnelementcolor);
        JPanel prad = new JPanel();
        prad.setLayout(new GridLayout(1, 4));
        this.covrad_ip = new InputPanel("covalent radius", 0, 7, true);
        this.atsize_ip = new InputPanel("atomic radius", 0, 7, true);
        this.hbondmax_ip = new InputPanel("H bond", 0, 7, true);
        prad.add(this.covrad_ip);
        prad.add(this.hbondmax_ip);
        prad.add(this.atsize_ip);
        prad.add(patomcolor);
        pelement.add(psymbol);
        pelement.add(prad);
        this.element_cp.m_choice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < ElementEditor.this.NumEl) {
                    if (ElementEditor.this.element_cp.getChoice().equals(ElementEditor.this.mACVD.getElement()[i])) {
                        ElementEditor.this.covrad_ip.setValue(Double.toString(ElementEditor.this.mACVD.getCovRad()[i]));
                        ElementEditor.this.atsize_ip.setValue(Float.toString(ElementEditor.this.mACVD.getRad()[i]));
                        ElementEditor.this.btnelementcolor.setBackground(new Color(ElementEditor.this.mACVD.getColor()[i][0], ElementEditor.this.mACVD.getColor()[i][1], ElementEditor.this.mACVD.getColor()[i][2]));
                        ElementEditor.this.hbondmax_ip.setValue(String.valueOf(ElementEditor.this.def[i].getMaxHbondDistance()));
                    }
                    ++i;
                }
            }
        });
        this.covrad_ip.m_value.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                double cov = 0.0;
                try {
                    cov = Double.parseDouble(ElementEditor.this.covrad_ip.getValue());
                    ElementEditor.this.mACVD.setCovRad(cov, ((ElementEditor)ElementEditor.this).element_cp.m_choice.getSelectedIndex());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.atsize_ip.m_value.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                float radiu = 0.0f;
                try {
                    radiu = Float.parseFloat(ElementEditor.this.atsize_ip.getValue());
                    ElementEditor.this.mACVD.setRad(radiu, ((ElementEditor)ElementEditor.this).element_cp.m_choice.getSelectedIndex());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.hbondmax_ip.m_value.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                String str = ElementEditor.this.hbondmax_ip.getValue();
                try {
                    double dv = Double.parseDouble(str);
                    ElementEditor.this.def[((ElementEditor)ElementEditor.this).element_cp.m_choice.getSelectedIndex()].setMaxHbondDistance(dv);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnelementcolor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color elementColor = Color.GRAY;
                JColorChooser colorchooser = new JColorChooser();
                Color color = JColorChooser.showDialog(ElementEditor.this.mp, "Choose", elementColor);
                if (color != null) {
                    elementColor = color;
                    ElementEditor.this.btnelementcolor.setBackground(elementColor);
                    float[] foo = new float[]{(float)elementColor.getRed() / 255.0f, (float)elementColor.getGreen() / 255.0f, (float)elementColor.getBlue() / 255.0f};
                    ElementEditor.this.mACVD.setColor(foo, ((ElementEditor)ElementEditor.this).element_cp.m_choice.getSelectedIndex());
                }
            }
        });
        this.element_cp.setChoice(this.mACVD.getElement()[0]);
    }

    @Override
    protected String getTitle() {
        return "element";
    }

    @Override
    protected void setDataToPanel() {
    }

    @Override
    protected void setDataToRepository() {
    }
}

