/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.measure;

import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.VectorOperations;
import javax.media.j3d.BranchGroup;
import org.apache.log4j.Logger;

public class AngleMeasure
extends Measure {
    private static Logger logger = Logger.getLogger((String)AngleMeasure.class.getName());
    private final int numAt = 3;
    private double result = 0.0;

    public AngleMeasure(Measurable measurable) {
        super(measurable);
    }

    @Override
    public int getNumberOfNecessaryAtoms() {
        return 3;
    }

    @Override
    public void draw() {
        if (!this.validData) {
            return;
        }
        MeasureObject elem = (MeasureObject)this.getElem();
        elem.setAtomVector(this.atomVectorNow);
        this.bg.addMeasureObject(elem);
    }

    private BranchGroup getElem() {
        SceneGraphElementCreator creator = this.measurable.getCreator();
        return creator.getSceneGraphElement(this.xyz[0], this.xyz[1], this.xyz[2], this.result, this.id);
    }

    @Override
    public void calculate() {
        double theta;
        double[][] vec = new double[2][3];
        int i = 0;
        while (i < 3) {
            vec[0][i] = this.pos_moto[2][i] - this.pos_moto[1][i];
            vec[1][i] = this.pos_moto[0][i] - this.pos_moto[1][i];
            ++i;
        }
        double naisek = 0.0;
        int i2 = 0;
        while (i2 < 3) {
            naisek += vec[0][i2] * vec[1][i2];
            ++i2;
        }
        double dist01 = VectorOperations.calDist(this.pos_moto[0], this.pos_moto[1]);
        double dist21 = VectorOperations.calDist(this.pos_moto[1], this.pos_moto[2]);
        double costheta = naisek / (dist01 * dist21);
        this.result = theta = Math.toDegrees(Math.acos(costheta));
        if (!this.updating) {
            logger.info((Object)("bond angle for atom " + this.id[2] + ", " + this.id[1] + " and " + this.id[0] + " : " + ConstParameters.formater.format(theta) + "\u00b0"));
        }
    }

    @Override
    public void redraw(int measureIndex, boolean valid) {
        if (!this.validData) {
            return;
        }
        MeasureObject mobj = (MeasureObject)this.bg.getChild(measureIndex);
        if (!valid) {
            mobj.detach();
            return;
        }
        mobj.setAtoms(new double[][]{this.xyz[0], this.xyz[1], this.xyz[2]});
        mobj.setResult(this.result);
        mobj.recreate();
    }

    @Override
    protected void initUpdate() {
        this.updating = true;
    }

    @Override
    protected void finalizeUpdate() {
        this.updating = false;
    }

    public String toString() {
        return "bond angle";
    }
}

