/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.CIFImporter;
import ciss.phase_viewer.atomcoord.pmodel.PmodelException;
import ciss.phase_viewer.plugins.viewer.edit.AtomicConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

class Interface
extends AtomicConfiguration
implements PropertyChangeListener {
    private Logger logger = Logger.getLogger((String)Interface.class.getName());
    private File crystal1File;
    private File crystal2File;
    private AtomicConfiguration crystal1;
    private AtomicConfiguration crystal2;
    private int[][] periodicTranslation = null;
    private boolean binv1;
    private boolean binv2;
    private double[] zoff1 = new double[]{0.0, 0.0, 0.0};
    private double[] zoff2 = new double[]{0.0, 0.0, 0.0};
    private double[] offset0 = new double[]{0.0, 0.0, 0.0};
    private double[] offset1 = new double[]{0.0, 0.0, 0.0};
    private double[] offset2 = new double[]{0.0, 0.0, 0.0};
    private double[] offset1_nonp = new double[]{0.0, 0.0, 0.0};
    private double[] offset2_nonp = new double[]{0.0, 0.0, 0.0};
    private INITIAL_AB initialAB;
    private INITIAL_COORD initialCoord;

    protected Interface(File pvmFile) throws IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(pvmFile);
        }
        catch (JDOMException e) {
            throw new IOException("Failed to parse " + pvmFile.getAbsolutePath());
        }
        Element rootElement = doc.getRootElement();
        List elements = rootElement.getChildren("AtomicConfiguration");
        for (Element element : elements) {
            Attribute nam = element.getAttribute("name");
            if (nam == null) continue;
            if (nam.getValue().equalsIgnoreCase("crystal1")) {
                this.crystal1 = new AtomicConfiguration();
                this.crystal1.initFromElement(element);
            }
            if (nam.getValue().equalsIgnoreCase("crystal2")) {
                this.crystal2 = new AtomicConfiguration();
                this.crystal2.initFromElement(element);
            }
            if (!nam.getValue().equalsIgnoreCase("interface")) continue;
            this.initFromElement(element);
        }
    }

    protected Interface(File crystal1File, File crystal2File, INITIAL_AB initialAB, INITIAL_COORD initialCoord) throws IOException, PmodelException {
        this.crystal1File = crystal1File;
        this.crystal2File = crystal2File;
        this.initialAB = initialAB;
        this.initialCoord = initialCoord;
        this.logger.info((Object)("initialCoord " + (Object)((Object)initialCoord)));
        if (!this.crystal1File.exists()) {
            throw new IOException("crystal1 file does not exist");
        }
        if (!this.crystal2File.exists()) {
            throw new IOException("crystal1 file does not exist");
        }
        this.init();
    }

    @Override
    Element getElement() {
        Element ret = super.getElement();
        Element interfaceElement = new Element("interface");
        ret.addContent((Content)interfaceElement);
        Element inv1 = new Element("inv1");
        inv1.setAttribute("val", String.valueOf(this.binv1));
        Element inv2 = new Element("inv2");
        inv2.setAttribute("val", String.valueOf(this.binv2));
        Element off0 = new Element("off0");
        off0.setAttribute("x", String.valueOf(this.offset0[0]));
        off0.setAttribute("y", String.valueOf(this.offset0[1]));
        off0.setAttribute("z", String.valueOf(this.offset0[2]));
        Element off1 = new Element("off1");
        off1.setAttribute("x", String.valueOf(this.offset1[0]));
        off1.setAttribute("y", String.valueOf(this.offset1[1]));
        off1.setAttribute("z", String.valueOf(this.offset1[2]));
        Element off2 = new Element("off2");
        off2.setAttribute("x", String.valueOf(this.offset2[0]));
        off2.setAttribute("y", String.valueOf(this.offset2[1]));
        off2.setAttribute("z", String.valueOf(this.offset2[2]));
        Element zoff1 = new Element("zoff1");
        zoff1.setAttribute("x", String.valueOf(this.zoff1[0]));
        zoff1.setAttribute("y", String.valueOf(this.zoff1[1]));
        zoff1.setAttribute("z", String.valueOf(this.zoff1[2]));
        Element zoff2 = new Element("zoff2");
        zoff2.setAttribute("x", String.valueOf(this.zoff2[0]));
        zoff2.setAttribute("y", String.valueOf(this.zoff2[1]));
        zoff2.setAttribute("z", String.valueOf(this.zoff2[2]));
        Element off_nonp1 = new Element("off_nonp1");
        off_nonp1.setAttribute("x", String.valueOf(this.offset1_nonp[0]));
        off_nonp1.setAttribute("y", String.valueOf(this.offset1_nonp[1]));
        off_nonp1.setAttribute("z", String.valueOf(this.offset1_nonp[2]));
        Element off_nonp2 = new Element("off_nonp2");
        off_nonp2.setAttribute("x", String.valueOf(this.offset2_nonp[0]));
        off_nonp2.setAttribute("y", String.valueOf(this.offset2_nonp[1]));
        off_nonp2.setAttribute("z", String.valueOf(this.offset2_nonp[2]));
        interfaceElement.addContent((Content)inv1);
        interfaceElement.addContent((Content)inv2);
        interfaceElement.addContent((Content)off0);
        interfaceElement.addContent((Content)off1);
        interfaceElement.addContent((Content)off2);
        interfaceElement.addContent((Content)zoff1);
        interfaceElement.addContent((Content)zoff2);
        interfaceElement.addContent((Content)off_nonp1);
        interfaceElement.addContent((Content)off_nonp2);
        return ret;
    }

    @Override
    void initFromElement(Element element) {
        super.initFromElement(element);
        Element inter = element.getChild("interface");
        Element inv1 = inter.getChild("inv1");
        Element inv2 = inter.getChild("inv2");
        Element off0 = inter.getChild("off0");
        Element off1 = inter.getChild("off1");
        Element off2 = inter.getChild("off2");
        Element zoff1 = inter.getChild("zoff1");
        Element zoff2 = inter.getChild("zoff2");
        Element off_nonp1 = inter.getChild("off_nonp1");
        Element off_nonp2 = inter.getChild("off_nonp2");
        try {
            this.binv1 = inv1.getAttribute("val").getBooleanValue();
            this.binv2 = inv2.getAttribute("val").getBooleanValue();
            this.offset0[0] = off0.getAttribute("x").getDoubleValue();
            this.offset0[1] = off0.getAttribute("y").getDoubleValue();
            this.offset0[2] = off0.getAttribute("z").getDoubleValue();
            this.offset1[0] = off1.getAttribute("x").getDoubleValue();
            this.offset1[1] = off1.getAttribute("y").getDoubleValue();
            this.offset1[2] = off1.getAttribute("z").getDoubleValue();
            this.offset2[0] = off2.getAttribute("x").getDoubleValue();
            this.offset2[1] = off2.getAttribute("y").getDoubleValue();
            this.offset2[2] = off2.getAttribute("z").getDoubleValue();
            this.zoff1[0] = zoff1.getAttribute("x").getDoubleValue();
            this.zoff1[1] = zoff1.getAttribute("y").getDoubleValue();
            this.zoff1[2] = zoff1.getAttribute("z").getDoubleValue();
            this.zoff2[0] = zoff2.getAttribute("x").getDoubleValue();
            this.zoff2[1] = zoff2.getAttribute("y").getDoubleValue();
            this.zoff2[2] = zoff2.getAttribute("z").getDoubleValue();
            this.offset1_nonp[0] = off_nonp1.getAttribute("x").getDoubleValue();
            this.offset1_nonp[1] = off_nonp1.getAttribute("y").getDoubleValue();
            this.offset1_nonp[2] = off_nonp1.getAttribute("z").getDoubleValue();
            this.offset2_nonp[0] = off_nonp2.getAttribute("x").getDoubleValue();
            this.offset2_nonp[1] = off_nonp2.getAttribute("y").getDoubleValue();
            this.offset2_nonp[2] = off_nonp2.getAttribute("z").getDoubleValue();
        }
        catch (DataConversionException dce) {
            this.logger.error((Object)"failed conversion");
        }
    }

    AtomicConfiguration getCrystal1() {
        return this.crystal1;
    }

    AtomicConfiguration getCrystal2() {
        return this.crystal2;
    }

    private void init() throws IOException, PmodelException {
        CIFImporter cifimp = new CIFImporter();
        cifimp.createOptionsPanel(false, this, this.crystal1File.getAbsolutePath());
        AtomCoords[] c1 = cifimp.getAtomCoordsFrom(this.crystal1File.getAbsolutePath());
        this.crystal1 = AtomicConfiguration.getAtomicConfiguration(c1[0]);
        this.crystal1.setName("crystal1");
        cifimp.createOptionsPanel(false, this, this.crystal2File.getAbsolutePath());
        AtomCoords[] c2 = cifimp.getAtomCoordsFrom(this.crystal2File.getAbsolutePath());
        this.crystal2 = AtomicConfiguration.getAtomicConfiguration(c2[0]);
        this.crystal2.setName("crystal2");
        this.binv1 = false;
        this.binv2 = false;
        this.setName("interface");
        this.genInterface();
    }

    private void genInterface() {
        int i;
        double[][] latvec1 = this.crystal1.getLatVec();
        double[][] latvec2 = this.crystal2.getLatVec();
        double[] avec = new double[3];
        double[] bvec = new double[3];
        double[] cvec = new double[3];
        int i2 = 0;
        while (i2 < 3) {
            avec[i2] = latvec1[0][i2] + latvec2[0][i2];
            bvec[i2] = latvec1[1][i2] + latvec2[1][i2];
            cvec[i2] = latvec1[2][i2] + latvec2[2][i2];
            ++i2;
        }
        double[][] lv = new double[3][3];
        if (this.initialAB == INITIAL_AB.AVERAGE) {
            i = 0;
            while (i < 3) {
                lv[0][i] = avec[i] * 0.5;
                lv[1][i] = bvec[i] * 0.5;
                lv[2][i] = cvec[i];
                ++i;
            }
        } else if (this.initialAB == INITIAL_AB.CRYSTAL1) {
            i = 0;
            while (i < 3) {
                lv[0][i] = latvec1[0][i];
                lv[1][i] = latvec1[1][i];
                lv[2][i] = cvec[i];
                this.crystal2.latvec[0] = this.crystal1.latvec[0];
                this.crystal2.latvec[1] = this.crystal1.latvec[1];
                this.crystal2.updateFract();
                ++i;
            }
        } else if (this.initialAB == INITIAL_AB.CRYSTAL2) {
            i = 0;
            while (i < 3) {
                lv[0][i] = latvec2[0][i];
                lv[1][i] = latvec2[1][i];
                lv[2][i] = cvec[i];
                this.crystal1.latvec[0] = this.crystal2.latvec[0];
                this.crystal1.latvec[1] = this.crystal2.latvec[1];
                this.crystal1.updateFract();
                ++i;
            }
        }
        this.crystal1.pack();
        this.crystal2.pack();
        double[] fractRatio1 = new double[3];
        double[] fractRatio2 = new double[3];
        int i3 = 0;
        while (i3 < 3) {
            if (lv[2][i3] > 1.0) {
                fractRatio1[i3] = latvec1[2][i3] / lv[2][i3];
                fractRatio2[i3] = latvec2[2][i3] / lv[2][i3];
            } else {
                fractRatio1[i3] = 0.0;
                fractRatio2[i3] = 0.0;
            }
            ++i3;
        }
        this.logger.debug((Object)("fractional ratio 1 " + fractRatio1[0] + " " + fractRatio1[1] + " " + fractRatio1[2]));
        this.logger.debug((Object)("fractional ratio 2 " + fractRatio2[0] + " " + fractRatio2[1] + " " + fractRatio2[2]));
        this.setLatticeVector(lv);
        this.updateLatticeConstant();
        this.setNumAt(this.crystal1.getNumAt() + this.crystal2.getNumAt());
        if (this.initialCoord == INITIAL_COORD.FRACTIONAL) {
            i3 = 0;
            while (i3 < this.crystal1.getNumAt()) {
                this.elemname[i3] = this.crystal1.getElementName()[i3];
                this.fractpos[i3][0] = this.crystal1.getFractPos()[i3][0];
                this.fractpos[i3][1] = this.crystal1.getFractPos()[i3][1];
                this.fractpos[i3][2] = this.crystal1.getFractPos()[i3][2] * fractRatio1[2];
                ++i3;
            }
            i3 = 0;
            while (i3 < this.crystal2.getNumAt()) {
                this.elemname[this.crystal1.getNumAt() + i3] = this.crystal2.getElementName()[i3];
                this.fractpos[this.crystal1.getNumAt() + i3][0] = this.crystal2.getFractPos()[i3][0] + fractRatio1[0];
                this.fractpos[this.crystal1.getNumAt() + i3][1] = this.crystal2.getFractPos()[i3][1] + fractRatio1[1];
                this.fractpos[this.crystal1.getNumAt() + i3][2] = this.crystal2.getFractPos()[i3][2] * fractRatio2[2] + fractRatio1[2];
                ++i3;
            }
            this.updateCart();
        }
        if (this.initialCoord == INITIAL_COORD.CARTESIAN) {
            i3 = 0;
            while (i3 < this.crystal1.getNumAt()) {
                this.elemname[i3] = this.crystal1.getElementName()[i3];
                this.cartpos[i3][0] = this.crystal1.getCartPos()[i3][0];
                this.cartpos[i3][1] = this.crystal1.getCartPos()[i3][1];
                this.cartpos[i3][2] = this.crystal1.getCartPos()[i3][2];
                ++i3;
            }
            i3 = 0;
            while (i3 < this.crystal2.getNumAt()) {
                this.elemname[this.crystal1.getNumAt() + i3] = this.crystal2.getElementName()[i3];
                this.cartpos[this.crystal1.getNumAt() + i3][0] = this.crystal2.getCartPos()[i3][0];
                this.cartpos[this.crystal1.getNumAt() + i3][1] = this.crystal2.getCartPos()[i3][1];
                this.cartpos[this.crystal1.getNumAt() + i3][2] = this.crystal2.getCartPos()[i3][2] + latvec1[0][2] + latvec1[1][2] + latvec1[2][2];
                ++i3;
            }
            this.updateFract();
        }
        this.logger.debug((Object)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.logger.info((Object)evt);
    }

    double[] getOffset(int cid) {
        if (cid == -1) {
            return this.offset0;
        }
        if (cid == 0) {
            return this.offset1;
        }
        if (cid == 1) {
            return this.offset2;
        }
        return null;
    }

    double[] getNonPeriodicOffset(int cid) {
        if (cid == 0) {
            return this.offset1_nonp;
        }
        if (cid == 1) {
            return this.offset2_nonp;
        }
        return null;
    }

    boolean isInverted(int cid) {
        if (cid == 0) {
            return this.binv1;
        }
        if (cid == 1) {
            return this.binv2;
        }
        return false;
    }

    boolean doPeriodicTranslationInterface(double vala, double valb, double valc) {
        if (this.periodicTranslation == null || this.periodicTranslation.length != this.nat) {
            this.periodicTranslation = new int[this.nat][3];
            int i = 0;
            while (i < this.nat) {
                int j = 0;
                while (j < 3) {
                    this.periodicTranslation[i][j] = 0;
                    ++j;
                }
                ++i;
            }
        }
        double[] offset = this.offset0;
        double sa = 0.0;
        double sb = 0.0;
        double sc = 0.0;
        boolean trans = false;
        if (Math.abs(vala - offset[0]) > 1.0E-5) {
            sa = vala - offset[0];
            trans = true;
        }
        if (Math.abs(valb - offset[1]) > 1.0E-5) {
            sb = valb - offset[1];
            trans = true;
        }
        if (Math.abs(valc - offset[2]) > 1.0E-5) {
            sc = valc - offset[2];
            trans = true;
        }
        offset[0] = vala;
        offset[1] = valb;
        offset[2] = valc;
        if (!trans) {
            return false;
        }
        double[][] cartpos = this.getCartPos();
        double[][] norm = this.getNormalizedLatticeVector();
        int i = 0;
        while (i < this.nat) {
            int j = 0;
            while (j < 3) {
                double[] dArray = cartpos[i];
                int n = j;
                dArray[n] = dArray[n] + (sa * norm[0][j] + sb * norm[1][j] + sc * norm[2][j]);
                ++j;
            }
            ++i;
        }
        this.updateFract();
        this.pack();
        return true;
    }

    boolean doPeriodicTranslation(int cid, double vala, double valb, double valc, boolean nonperiodic) {
        double[] offset = this.offset1;
        double[] offset_np = this.offset1_nonp;
        if (cid == 1) {
            offset = this.offset2;
            offset_np = this.offset2_nonp;
        }
        double sa = 0.0;
        double sb = 0.0;
        double sc = 0.0;
        boolean trans = false;
        boolean cchanged = false;
        if (Math.abs(vala - offset[0]) > 1.0E-5) {
            sa = vala - offset[0];
            trans = true;
        }
        if (Math.abs(valb - offset[1]) > 1.0E-5) {
            sb = valb - offset[1];
            trans = true;
        }
        if (!nonperiodic && Math.abs(valc - offset[2]) > 1.0E-5) {
            sc = valc - offset[2];
            trans = true;
            cchanged = true;
        }
        if (nonperiodic && Math.abs(valc - offset_np[2]) > 1.0E-5) {
            sc = valc - offset_np[2];
            trans = true;
            cchanged = true;
        }
        offset[0] = vala;
        offset[1] = valb;
        if (nonperiodic) {
            offset_np[2] = valc;
        } else {
            offset[2] = valc;
        }
        if (trans) {
            int i;
            int nat = this.getCrystal1().getNumAt();
            int noff = 0;
            double[][] lvec = this.getCrystal1().getLatVec();
            double[] zoff = new double[]{this.zoff1[0] + this.offset0[0], this.zoff1[1] + this.offset0[1], this.zoff1[2] + this.offset0[2]};
            double[][] norm = this.getNormalizedLatticeVector();
            double[][] cartpos = this.getCartPos();
            if (nonperiodic && cchanged && cid == 0) {
                int i2 = 0;
                while (i2 < 3) {
                    int n = i2;
                    this.zoff1[n] = this.zoff1[n] + (sa * norm[0][i2] + sb * norm[1][i2] + sc * norm[2][i2]);
                    ++i2;
                }
            }
            if (cid == 1) {
                nat = this.getCrystal2().getNumAt();
                noff = this.getCrystal1().getNumAt();
                lvec = this.getCrystal2().getLatVec();
                double[][] latvec = this.getCrystal1().getLatVec();
                i = 0;
                while (i < 3) {
                    zoff[i] = latvec[2][i] + this.zoff2[i] + this.offset0[i];
                    ++i;
                }
                if (nonperiodic && cchanged) {
                    i = 0;
                    while (i < 3) {
                        int n = i;
                        this.zoff2[n] = this.zoff2[n] + (sa * norm[0][i] + sb * norm[1][i] + sc * norm[2][i]);
                        ++i;
                    }
                }
            }
            int i3 = noff;
            while (i3 < nat + noff) {
                if (cartpos[i3][2] < this.offset0[2]) {
                    double[] dArray = cartpos[i3];
                    dArray[2] = dArray[2] + this.latvec[2][2];
                }
                int j = 0;
                while (j < 3) {
                    double[] dArray = cartpos[i3];
                    int n = j;
                    dArray[n] = dArray[n] + (sa * norm[0][j] + sb * norm[1][j] + sc * norm[2][j]);
                    ++j;
                }
                ++i3;
            }
            this.updateFract(0);
            this.updateFract(1);
            this.pack(0);
            this.pack(1);
            double[][] carttmp = new double[nat][3];
            i = noff;
            while (i < noff + nat) {
                int j = 0;
                while (j < 3) {
                    carttmp[i - noff][j] = cartpos[i][j] - zoff[j];
                    ++j;
                }
                ++i;
            }
            double[][] fract = AtomicConfiguration.getFract(nat, carttmp, lvec);
            if (!nonperiodic) {
                int i4 = 0;
                while (i4 < nat) {
                    Interface.pack(fract[i4]);
                    ++i4;
                }
            }
            double[][] cart = AtomicConfiguration.getCart(nat, fract, lvec);
            int i5 = 0;
            while (i5 < nat) {
                int j = 0;
                while (j < 3) {
                    cartpos[i5 + noff][j] = 0.0;
                    ++j;
                }
                if (cart[i5][2] >= this.latvec[2][2] - this.offset0[2] + sc * norm[2][2]) {
                    j = 0;
                    while (j < 3) {
                        cartpos[i5 + noff][2] = -this.getLatVec()[j][2];
                        ++j;
                    }
                }
                j = 0;
                while (j < 3) {
                    double[] dArray = cartpos[i5 + noff];
                    int n = j;
                    dArray[n] = dArray[n] + (cart[i5][j] + zoff[j]);
                    ++j;
                }
                ++i5;
            }
            this.updateFract(2);
            this.pack(2);
            this.updateCart();
        }
        return trans;
    }

    boolean invert(int cid, boolean currVal) {
        int i;
        boolean oldval = this.binv1;
        if (cid == 1) {
            oldval = this.binv2;
        }
        if (currVal == oldval) {
            return false;
        }
        int nat = this.getCrystal1().getNumAt();
        int noff = 0;
        double[][] lvec = this.getCrystal1().getLatVec();
        double[] zoff = new double[]{this.zoff1[0], this.zoff1[1], this.zoff1[2] + this.offset0[2]};
        if (cid == 1) {
            nat = this.getCrystal2().getNumAt();
            noff = this.getCrystal1().getNumAt();
            lvec = this.getCrystal2().getLatVec();
            double[][] latvec = this.getCrystal1().getLatVec();
            i = 0;
            while (i < 3) {
                zoff[i] = latvec[2][i] + this.zoff2[i];
                ++i;
            }
            zoff[2] = zoff[2] + this.offset0[2];
            this.logger.debug((Object)("zoff : " + zoff[0] + " " + zoff[1] + " " + zoff[2]));
        }
        double[][] fract = this.getFractWRT(cid, nat, noff, lvec, zoff);
        i = 0;
        while (i < nat) {
            fract[i][2] = 1.0 - fract[i][2];
            Interface.pack(fract[i]);
            ++i;
        }
        double[][] cart = AtomicConfiguration.getCart(nat, fract, lvec);
        int i2 = 0;
        while (i2 < nat) {
            int j = 0;
            while (j < 3) {
                this.cartpos[i2 + noff][j] = 0.0;
                ++j;
            }
            if (cart[i2][2] > this.latvec[2][2] - zoff[2]) {
                j = 0;
                while (j < 3) {
                    this.cartpos[i2 + noff][2] = -this.getLatVec()[j][2];
                    ++j;
                }
            }
            j = 0;
            while (j < 3) {
                double[] dArray = this.cartpos[i2 + noff];
                int n = j;
                dArray[n] = dArray[n] + (cart[i2][j] + zoff[j]);
                ++j;
            }
            ++i2;
        }
        if (cid == 0) {
            this.binv1 = currVal;
        } else {
            this.binv2 = currVal;
        }
        return true;
    }

    private double[][] getFractWRT(int cid, int nat, int noff, double[][] lvec, double[] zoff) {
        double[][] cartpos = this.getCartPos();
        double[][] carttmp = new double[nat][3];
        int i = noff;
        while (i < noff + nat) {
            carttmp[i - noff][2] = 0.0;
            if (cartpos[i][2] < zoff[2]) {
                carttmp[i - noff][2] = this.latvec[2][2];
            }
            ++i;
        }
        i = noff;
        while (i < noff + nat) {
            int j = 0;
            while (j < 3) {
                double[] dArray = carttmp[i - noff];
                int n = j;
                dArray[n] = dArray[n] + (cartpos[i][j] - zoff[j]);
                ++j;
            }
            ++i;
        }
        double[][] fr = AtomicConfiguration.getFract(nat, carttmp, lvec);
        int i2 = 0;
        while (i2 < nat) {
            Interface.pack(fr[i2]);
            ++i2;
        }
        return fr;
    }

    @Override
    void mergeAtomCoords(AtomCoords coor) {
        int j;
        AtomicConfiguration tconf = Interface.getAtomicConfiguration(coor);
        double[] mindiff1 = new double[]{1.0E10, 1.0E10, 1.0E10};
        double[] mindiff2 = new double[]{1.0E10, 1.0E10, 1.0E10};
        int natm = this.nat;
        if (tconf.nat < this.nat) {
            this.logger.error((Object)"the number of atoms has changed; merge is deemed to fail...");
            natm = tconf.nat;
        }
        int nat1 = this.getCrystal1().getNumAt();
        int i = 0;
        while (i < nat1) {
            j = 0;
            while (j < 3) {
                if (Math.abs(this.cartpos[i][j] - tconf.cartpos[i][j]) < Math.abs(mindiff1[j])) {
                    mindiff1[j] = this.cartpos[i][j] - tconf.cartpos[i][j];
                }
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < 3) {
            if (Math.abs(mindiff1[j2]) > 1.0E-10) {
                int n = j2;
                this.offset1[n] = this.offset1[n] - mindiff1[j2];
                this.logger.debug((Object)("mindiff1 for crystal1, direction " + j2 + " : " + mindiff1[j2]));
            }
            ++j2;
        }
        i = nat1;
        while (i < natm) {
            j = 0;
            while (j < 3) {
                if (Math.abs(this.cartpos[i][j] - tconf.cartpos[i][j]) < Math.abs(mindiff2[j])) {
                    mindiff2[j] = this.cartpos[i][j] - tconf.cartpos[i][j];
                }
                ++j;
            }
            ++i;
        }
        j2 = 0;
        while (j2 < 3) {
            if (Math.abs(mindiff2[j2]) > 1.0E-10) {
                int n = j2;
                this.offset2[n] = this.offset2[n] - mindiff2[j2];
                this.logger.debug((Object)("mindiff2 for crystal1, direction " + j2 + " : " + mindiff2[j2]));
            }
            ++j2;
        }
        super.mergeAtomCoords(coor);
    }

    static enum INITIAL_AB {
        AVERAGE,
        CRYSTAL1,
        CRYSTAL2;

    }

    static enum INITIAL_COORD {
        FRACTIONAL,
        CARTESIAN;

    }
}

