/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel;

import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class NLOPanel
extends ProjectManipulator
implements OutputParserListener {
    private Logger logger = Logger.getLogger((String)NLOPanel.class.getName());
    private OutputParser parser;

    public NLOPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public void recreate() {
        this.projectInfo.getOutputInterface().initCache();
        this.init();
        this.revalidate();
    }

    @Override
    public void parseFinished() {
        this.removeAll();
        JPanel button = new JPanel();
        JPanel dataPanel = this.projectInfo.getOutputInterface().getDataPanel("F_NLO");
        this.add(dataPanel);
        this.revalidate();
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void init() {
        this.removeAll();
        try {
            String fname = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_NLO").getFileName();
            if (!new File(fname).exists()) {
                this.add(new NoFilePanel("F_NLO"));
                return;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.add(new LoadingFilePanel("F_NLO"));
        if (this.parser == null) {
            this.parser = this.projectInfo.getOutputInterface().getParser("F_NLO", this);
        }
        this.parser.setParsed(false);
        this.parser.doParse();
    }
}

