/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.stdout;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StdoutUtils {
    private static Logger logger = Logger.getLogger((String)StdoutUtils.class.getName());

    private StdoutUtils() {
    }

    public static Vector getStdoutFiles(String dir) {
        Vector<String> vector = new Vector<String>();
        File[] list = new File(dir).listFiles();
        int i = 0;
        while (i < list.length) {
            if (StdoutUtils.isStdout(list[i].getName())) {
                vector.addElement(list[i].getName());
            }
            ++i;
        }
        return vector;
    }

    public static String getExtensionOfStdout(String output) {
        String ret = new String();
        char[] ch = output.toCharArray();
        if (ch.length == 9) {
            ret = String.copyValueOf(output.toCharArray(), 6, 3);
        }
        return ret;
    }

    public static String getTimeFrom(String output) {
        try {
            String ret = "";
            String readString = "";
            BufferedReader br = new BufferedReader(new FileReader(output));
            while ((readString = br.readLine()) != null) {
                String[] line;
                if (!readString.trim().startsWith("program start") || (line = readString.split("\\s+")).length < 4) continue;
                ret = String.valueOf(line[2]) + " " + line[3];
                return StdoutUtils.transformToDate(ret);
            }
            br.close();
        }
        catch (Exception exc) {
            logger.error((Object)("failed to read " + output));
        }
        return "(not available)";
    }

    private static String transformToDate(String rawDate) {
        Calendar calendar = Calendar.getInstance();
        String[] string0 = rawDate.split("\\s+");
        String[] string1 = string0[0].split(":");
        String[] string2 = string0[1].split("/");
        try {
            calendar.set(Integer.parseInt(string2[2]), Integer.parseInt(string2[1]) - 1, Integer.parseInt(string2[0]), Integer.parseInt(string1[0]), Integer.parseInt(string1[1]), Integer.parseInt(string1[2]));
        }
        catch (Exception exc) {
            return rawDate;
        }
        return calendar.getTime().toString();
    }

    private static boolean isStdout(String file) {
        String identOut = "output";
        String underScore = "_";
        int lenOutput = 6;
        int lenNumber = 3;
        int minimumLength = 9;
        int maximumLength = 10;
        char[] ch = file.toCharArray();
        if (ch.length < minimumLength || ch.length > maximumLength) {
            return false;
        }
        String ident = String.copyValueOf(ch, 0, lenOutput);
        if (!ident.equals(identOut)) {
            return false;
        }
        if (file.equals("output_000")) {
            return true;
        }
        return file.trim().matches("output\\d+");
    }
}

