/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BMParser
extends OutputParser {
    private Logger logger = Logger.getLogger((String)BMParser.class.getName());
    private final String START = "#";
    private String[] idents;
    private Vector dataVector = new Vector();

    public BMParser(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean parse() {
        String line = "";
        if (this.readers != null) {
            int i = 0;
            while (i < this.readers.length) {
                this.dataVector = new Vector();
                try {
                    this.logger.debug((Object)("at file:" + this.fileNames.get(i).toString()));
                    while ((line = this.readers[i].readLine()) != null) {
                        if (line.trim().length() == 0) continue;
                        this.logger.debug((Object)line);
                        this.parseLine(line.trim());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.readers[i].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.dataVector.size() != 0) {
                    this.idents = new String[((String[])this.dataVector.get(0)).length];
                    String[][] d2d = new String[this.dataVector.size()][((String[])this.dataVector.get(0)).length];
                    try {
                        this.dataVector.copyInto((Object[])d2d);
                    }
                    catch (ArrayIndexOutOfBoundsException aiob) {
                        this.logger.error((Object)("corrupted F_ENF file: " + this.fileNames.get(i).toString()));
                        return false;
                    }
                    String[] id = this.fileNames.get(i).toString().split("\\.");
                    String nam = id[id.length - 1];
                    if (new File(this.fileNames.get(i).toString()).getName().startsWith("potential_of_mean")) {
                        nam = "PMF";
                        if (this.idents.length >= 9) {
                            this.idents[0] = "value";
                            this.idents[1] = "Hartree";
                            this.idents[2] = "err";
                            this.idents[3] = "eV";
                            this.idents[4] = "err";
                            this.idents[5] = "kcal/mol";
                            this.idents[6] = "err";
                            this.idents[7] = "kJ/mol";
                            this.idents[8] = "err";
                        } else if (this.idents.length >= 5) {
                            this.idents[0] = "value";
                            this.idents[1] = "Hartree";
                            this.idents[2] = "eV";
                            this.idents[3] = "kcal/mol";
                            this.idents[4] = "kJ/mol";
                        }
                    } else if (new File(this.fileNames.get(i).toString()).getName().startsWith("mean_force")) {
                        if (this.idents.length >= 3) {
                            nam = "MF";
                            this.idents[0] = "value";
                            this.idents[1] = "force";
                            this.idents[2] = "err";
                        } else if (this.idents.length >= 2) {
                            nam = "MF(smoothed)";
                            this.idents[0] = "value";
                            this.idents[1] = "force";
                        }
                    } else {
                        int nreac = (this.idents.length - 1) / 2;
                        this.idents[0] = "md step";
                        int j = 0;
                        while (j < nreac) {
                            String val = "value" + String.valueOf(j + 1);
                            String lam = "lambda" + String.valueOf(j + 1);
                            this.idents[j + 1] = val;
                            this.idents[1 + nreac + j] = lam;
                            ++j;
                        }
                        this.idents[this.idents.length - 1] = "det. met.";
                    }
                    OutputData outputData = new OutputData(nam, "lambda at each step", this.idents, d2d, "");
                    outputData.setFileName(this.fileNames.get(i).toString());
                    this.addOutputData(outputData);
                    this.idents = null;
                }
                ++i;
            }
            if (this.readers.length != 0) {
                this.isDone = true;
            }
        }
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith("#")) {
            return;
        }
        String[] data = line.split("\\s+");
        this.dataVector.addElement(data);
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }
}

