/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cube2AtomCoords;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class WannierPanel
extends ProjectManipulator
implements ACVCaller,
MouseListener,
KeyListener {
    private Logger logger = Logger.getLogger((String)WannierPanel.class.getName());
    private String name;
    private ChaseFile cf;
    private String[] names;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JComboBox fileChooser;
    private JList fileList;
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();

    public WannierPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BorderLayout());
    }

    @Override
    public void init() {
        this.removeAll();
        this.cf = this.projectInfo.getChaseFileManager().getFile("F_WANNIER");
        this.name = this.cf.getDefaultName().getValue();
        this.logger.debug((Object)("F_WANNIER file: " + this.name));
        this.createNames();
        this.createPanel();
    }

    private void createNames() {
        File dir = new File(this.projectInfo.getProjectDirectory());
        String[] files = dir.list();
        if (files == null || files.length == 0) {
            return;
        }
        Vector<String> chrVec = new Vector<String>();
        int i = 0;
        while (i < files.length) {
            if (files[i].matches(this.name)) {
                chrVec.addElement(files[i]);
            }
            ++i;
        }
        if (chrVec.size() == 0) {
            return;
        }
        this.names = new String[chrVec.size()];
        chrVec.copyInto(this.names);
    }

    private void createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(this.gridbag);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.setBorder(new TitledBorder("select wannier function file"));
        if (this.names == null || this.names.length == 0) {
            this.add(new NoFilePanel("F_WANNIER"));
            return;
        }
        this.fileChooser = new JComboBox<String>(this.names);
        this.fileList = new JList<String>(this.names);
        this.fileList.addMouseListener(this);
        this.fileList.addKeyListener(this);
        JScrollPane sp = new JScrollPane(this.fileList);
        sp.setPreferredSize(new Dimension(200, 100));
        panel1.add(sp);
        this.readHeaders(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.names[this.names.length - 1]);
        JButton bootBSV = new JButton("boot BioStationViewer");
        JButton bootViewer = new JButton("boot internal viewer");
        JButton bootEditor = new JButton("boot editor");
        panel1.add(bootBSV);
        panel1.add(bootViewer);
        panel1.add(bootEditor);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.anchor = 11;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 1;
        panel.add((Component)panel1, this.constraints);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new TitledBorder("info"));
        panel2.setLayout(new BoxLayout(panel2, 0));
        JPanel plabel1 = new JPanel();
        plabel1.setBorder(new TitledBorder("title"));
        JPanel plabel2 = new JPanel();
        plabel2.setBorder(new TitledBorder("comment"));
        plabel1.add(this.label1);
        plabel2.add(this.label2);
        panel2.add(plabel1);
        panel2.add(plabel2);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        panel.add((Component)panel2, this.constraints);
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String chfileNow = String.valueOf(WannierPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + (String)WannierPanel.this.fileList.getSelectedValue();
                WannierPanel.this.readHeaders(chfileNow);
            }
        });
        bootEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String chfileNow = String.valueOf(WannierPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + (String)WannierPanel.this.fileList.getSelectedValue();
                ProjectBrowserUtils.bootTextViewer(chfileNow);
            }
        });
        bootBSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String chfileNow = String.valueOf(WannierPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + (String)WannierPanel.this.fileList.getSelectedValue();
                ProjectBrowserUtils.bootBioStationViewer(chfileNow);
            }
        });
        bootViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String chfileNow = String.valueOf(WannierPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + (String)WannierPanel.this.fileList.getSelectedValue();
                WannierPanel.this.bootViewer();
            }
        });
        this.add((Component)panel, "North");
        this.fileList.setSelectedIndex(0);
    }

    private void bootViewer() {
        Object[] objs = this.fileList.getSelectedValues();
        if (objs == null || objs.length == 0) {
            this.logger.info((Object)"select file");
            return;
        }
        String dir = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator");
        Cube2AtomCoords c2a = new Cube2AtomCoords(String.valueOf(dir) + objs[0].toString());
        AtomCoords coords = c2a.getAtomCoords();
        Vector<AtomCoords> vec = new Vector<AtomCoords>();
        vec.addElement(coords);
        int i = 1;
        while (i < objs.length) {
            String file = String.valueOf(dir) + objs[i].toString();
            Cube2AtomCoords cu = new Cube2AtomCoords(file);
            cu.getAtomCoords();
            coords.addChargeDensity(cu.getChargeDensity());
            ++i;
        }
        double[][] dcell = coords.getCell()[0].getDouble();
        BravaisLattice blat = BravaisLattice.getBravaisLattice(dcell[0], dcell[1], dcell[2]);
        if (blat != null) {
            blat.isBravais(false);
        }
        DataManager manager = new DataManager("foo", PhaseConstants.TABLESPEC, false);
        manager.parse();
        ACVData acvdata = new ACVData((ACVCaller)this, vec, this.projectInfo.getProjectDirectory(), manager.getInputInterface(), StringConstants.phase_atom_tag);
        acvdata.setFileName(objs[0].toString());
        acvdata.setBravaisLattice(blat);
        CoordsViewerBooter cvb = new CoordsViewerBooter(acvdata, 0);
        cvb.boot();
    }

    private void readHeaders(String file) {
        String line1 = "";
        String line2 = "";
        BufferedReader reader = null;
        try {
            try {
                FileReader freader = new FileReader(file);
                reader = new BufferedReader(freader);
                line1 = reader.readLine();
                line2 = reader.readLine();
            }
            catch (IOException ioe) {
                this.logger.error((Object)("failed to open file: " + file));
                try {
                    reader.close();
                }
                catch (IOException ioe2) {
                    this.logger.error((Object)("failed to close file: " + file));
                }
                return;
            }
            catch (NullPointerException npe) {
                this.logger.error((Object)"corrupted chr file...");
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    this.logger.error((Object)("failed to close file: " + file));
                }
                return;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                this.logger.error((Object)("failed to close file: " + file));
            }
        }
        this.label1.setText(line1);
        this.label2.setText(line2);
    }

    private void chosenFile(String fileName) {
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void save(AtomCoords coords) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.logger.debug((Object)("keycode: " + e.getKeyCode()));
        this.logger.debug((Object)("keychar: " + e.getKeyChar()));
        if (e.getKeyCode() == 10) {
            this.bootViewer();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.bootViewer();
        }
    }
}

