/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.MyThreadListener;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BlueMoonPanel
extends ProjectManipulator
implements OutputParserListener,
MyThreadListener {
    private Logger logger = Logger.getLogger((String)BlueMoonPanel.class.getName());
    private OutputData[] outputs;
    private OutputParser parser;
    private ChaseFile cf;
    private String[] reacfiles = null;
    private int nreac = 0;
    private JButton run;

    public BlueMoonPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void parseFinished() {
        this.removeAll();
        this.outputs = this.projectInfo.getOutputInterface().getParser("F_BLUEM", this).getOutputData();
        if (this.outputs == null) {
            return;
        }
        this.add(this.firstRow());
        this.add(this.projectInfo.getOutputInterface().getDataPanel("F_BLUEM"));
        this.revalidate();
    }

    @Override
    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.parse();
    }

    private void parse() {
        String fsfile;
        String ffile;
        this.cf = this.projectInfo.getChaseFileManager().getFile("F_BLUEM");
        String potfile = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "potential_of_mean_force.data";
        Vector<String> potfiles = new Vector<String>();
        if (new File(potfile).exists()) {
            potfiles.add(new File(potfile).getName());
        }
        if (new File(ffile = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "mean_force_raw.data").exists()) {
            potfiles.add(new File(ffile).getName());
        }
        if (new File(fsfile = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "mean_force_smoothed.data").exists()) {
            potfiles.add(new File(fsfile).getName());
        }
        String[] tmpreacfiles = new File(this.projectInfo.getProjectDirectory()).list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.matches(String.valueOf(BlueMoonPanel.this.cf.getFileName()) + ".reac\\d+");
            }
        });
        if (potfiles.size() != 0 || tmpreacfiles != null && tmpreacfiles.length != 0) {
            int nsize = potfiles.size();
            if (tmpreacfiles != null) {
                nsize += tmpreacfiles.length;
            }
            this.reacfiles = new String[nsize];
            int i = 0;
            while (i < potfiles.size()) {
                this.reacfiles[i] = potfiles.get(i).toString();
                ++i;
            }
            i = potfiles.size();
            while (i < nsize) {
                this.reacfiles[i] = tmpreacfiles[i - potfiles.size()];
                ++i;
            }
        }
        if (this.reacfiles == null || this.reacfiles.length == 0) {
            this.add(new NoFilePanel("F_BLUEM"));
            return;
        }
        this.nreac = tmpreacfiles.length;
        this.add(new LoadingFilePanel("F_BLUEM"));
        if (this.parser == null) {
            this.parser = this.projectInfo.getOutputInterface().getParser("F_BLUEM", this);
        }
        this.parser.resetFiles();
        int i = 0;
        while (i < this.reacfiles.length) {
            this.logger.debug((Object)("F_BLUEM file: " + this.reacfiles[i]));
            this.parser.addFile(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.reacfiles[i]);
            ++i;
        }
        this.parser.setParsed(false);
        this.parser.doParse();
    }

    @Override
    public void initializeProject() {
    }

    private JPanel firstRow() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel pnumreac = new JPanel();
        pnumreac.setBorder(new TitledBorder("number of reac coords"));
        JLabel lnumreac = new JLabel(String.valueOf(this.nreac));
        pnumreac.add(lnumreac);
        panel.add(pnumreac);
        JButton btnrunbm = new JButton("run 'bluemoon'");
        JPanel pbtn = new JPanel();
        pbtn.add(btnrunbm);
        panel.add(pbtn);
        btnrunbm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new RunBM(BlueMoonPanel.this.projectInfo);
            }
        });
        return panel;
    }

    private void runBM() {
        this.logger.info((Object)"running the 'bluemoon' utility program.");
        String bmPath = String.valueOf(System.getProperty("pviewer.home")) + FS + "bin" + FS + "bluemoon";
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            bmPath = String.valueOf(bmPath) + ".exe";
        }
        if (!new File(bmPath).exists()) {
            this.logger.error((Object)"'bluemoon' program not found.");
            this.logger.error((Object)"put it under PHASE_VIEWER_HOME/bin");
            return;
        }
        this.projectInfo.getInputInterface().save();
        String nfinp = "\"" + this.projectInfo.getInputInterface().getFileName() + "\"";
        bmPath = String.valueOf(bmPath) + " " + nfinp;
        new MyThread(bmPath, this, new File(this.projectInfo.getProjectDirectory()), null);
    }

    @Override
    public void done() {
        this.logger.info((Object)"... done.");
        this.parse();
    }

    class RunBM
    extends InternalFrameChase {
        RunBM(ProjectInfo pinfo) {
            super("run the 'bluemoon' utility", true, true, true, true, new Dimension(350, 350));
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            RunBMsub rbs = new RunBMsub(pinfo);
            rbs.init();
            this.getContentPane().add(rbs);
            this.getContentPane().add(this.getBtnPanel());
        }

        JPanel getBtnPanel() {
            JPanel panel = new JPanel();
            BlueMoonPanel.this.run = new JButton("run");
            JButton dismiss = new JButton("dismiss");
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(BlueMoonPanel.this.run);
            panel.add(dismiss);
            dismiss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RunBM.this.dispose();
                }
            });
            BlueMoonPanel.this.run.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    BlueMoonPanel.this.runBM();
                    RunBM.this.dispose();
                }
            });
            return panel;
        }
    }

    class RunBMsub
    extends ProjectManipulator {
        RunBMsub(ProjectInfo projectInfo) {
            super(projectInfo);
        }

        @Override
        public void init() {
            this.add(new RunBMsubsub(this.projectInfo.getInputInterface()));
        }

        @Override
        public void initializeProject() {
        }
    }

    class RunBMsubsub
    extends PhaseInputItems {
        public RunBMsubsub(InputInterface inputInterface) {
            super(inputInterface);
        }

        @Override
        public void createGUI() {
            ActionL al = new ActionL();
            this.setLayout(new BoxLayout(this, 1));
            String therm = "thermodynamic_integration.";
            JPanel preac = new JPanel();
            preac.setLayout(new BoxLayout(preac, 0));
            preac.setBorder(new TitledBorder("reaction coordinates taken into account"));
            InputPanelPhase ippnreac = new InputPanelPhase(new String[]{String.valueOf(therm) + "nreac_coords"}, this.inputInterface, "to", 0, 6, this);
            ippnreac.getTextField().addActionListener(al);
            InputPanelPhase ippsreac = new InputPanelPhase(new String[]{String.valueOf(therm) + "istart_reac_coords"}, this.inputInterface, "from", 0, 6, this);
            ippsreac.getTextField().addActionListener(al);
            JPanel pn0 = new JPanel();
            pn0.add(ippnreac);
            JPanel pn1 = new JPanel();
            pn1.add(ippsreac);
            preac.add(pn1);
            preac.add(pn0);
            InputPanelPhase ippnequib = new InputPanelPhase(new String[]{String.valueOf(therm) + "nequib"}, this.inputInterface, "from", 0, 6, this);
            ippnequib.getTextField().addActionListener(al);
            InputPanelPhase ippnsteps = new InputPanelPhase(new String[]{String.valueOf(therm) + "nsteps"}, this.inputInterface, "to", 0, 6, this);
            ippnsteps.getTextField().addActionListener(al);
            InputPanelPhase ippnsamp = new InputPanelPhase(new String[]{String.valueOf(therm) + "nsample"}, this.inputInterface, "sample", 0, 6, this);
            ippnsamp.getTextField().addActionListener(al);
            JPanel psteps = new JPanel();
            psteps.setLayout(new BoxLayout(psteps, 0));
            psteps.setBorder(new TitledBorder("MD steps taken into account"));
            psteps.add(ippnequib);
            psteps.add(ippnsteps);
            psteps.add(ippnsamp);
            JPanel pauxil = new JPanel();
            pauxil.setBorder(new TitledBorder("smoothing"));
            pauxil.setLayout(new BoxLayout(pauxil, 0));
            CheckPanelPhase cbsmooth = new CheckPanelPhase(new String[]{String.valueOf(therm) + "smooth"}, this.inputInterface, "smooth", this);
            InputPanelPhase ippnxsi = new InputPanelPhase(new String[]{String.valueOf(therm) + "n_xsi"}, this.inputInterface, "num. points", 0, 6, this);
            ippnxsi.getTextField().addActionListener(al);
            pauxil.add(cbsmooth);
            JPanel pnn = new JPanel();
            pnn.add(ippnxsi);
            pauxil.add(pnn);
            cbsmooth.registerDisabableGUI(ippnxsi);
            this.add(preac);
            this.add(psteps);
            this.add(pauxil);
        }

        class ActionL
        implements ActionListener {
            ActionL() {
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BlueMoonPanel.this.run.doClick();
            }
        }
    }
}

