/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class PseudoPotentialPanel
extends JPanel {
    private Logger logger = Logger.getLogger((String)PseudoPotentialPanel.class.getName());
    private ProjectInfo projectInfo;
    private Vector ppselectors = new Vector();
    private boolean setTitle = true;
    private int numPP = 1;
    private boolean updating = false;

    public PseudoPotentialPanel(ProjectInfo projectInfo, int numPP) {
        this.projectInfo = projectInfo;
        this.numPP = numPP;
        this.setBorder(new TitledBorder("specify pseudo potential file (s)"));
        this.setLayout(new GridLayout());
        this.init();
    }

    protected void updatePPPanel(Vector elems) throws NullPointerException {
        int i = 0;
        while (i < elems.size()) {
            String elename = (String)elems.elementAt(i);
            PseudoPotentialSelector pps = (PseudoPotentialSelector)this.ppselectors.elementAt(i);
            if (pps.getElementName() == null || !pps.getElementName().equals(elename)) {
                pps.clear();
                pps.setElementName(elename);
            }
            ++i;
        }
    }

    protected void updatePPPanel(String elem, int index) {
        PseudoPotentialSelector pps = (PseudoPotentialSelector)this.ppselectors.elementAt(index);
        if (pps.getElementName() == null || !pps.getElementName().equals(elem)) {
            pps.setElementName(elem);
        }
    }

    protected boolean updating() {
        return this.updating;
    }

    protected void updating(boolean updating) {
        this.updating = updating;
    }

    private void init() {
        JScrollPane scrollPane = new JScrollPane();
        File ppDir = new File(String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + "pp");
        boolean ppDirExists = ppDir.exists();
        this.logger.debug((Object)("ppdir: " + ppDir + " exsists? " + ppDirExists));
        JPanel panel0 = new JPanel();
        panel0.setLayout(new BoxLayout(panel0, 1));
        JLabel lno = new JLabel("no");
        JLabel lelem = new JLabel("element");
        JLabel pp = new JLabel("pp file name");
        JLabel bfc = new JLabel("select by filechooser");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 0.2;
        gc.ipadx = 40;
        panel.add((Component)lno, gc);
        gc.weightx = 0.1;
        gc.ipadx = 0;
        lelem.setPreferredSize(new Dimension(50, 25));
        panel.add((Component)lelem, gc);
        gc.ipadx = 40;
        gc.weightx = 0.5;
        panel.add((Component)pp, gc);
        gc.ipadx = 0;
        gc.weightx = 0.2;
        panel.add((Component)bfc, gc);
        panel0.add(panel);
        int i = 0;
        while (i < this.numPP) {
            PseudoPotentialSelector pps = new PseudoPotentialSelector(new Integer(i + 1).toString());
            panel0.add(pps);
            this.ppselectors.addElement(pps);
            ++i;
        }
        scrollPane.getViewport().setView(panel0);
        this.add(scrollPane);
    }

    class PseudoPotentialSelector
    extends JPanel {
        private InputInterface inputInterface;
        private String ID;
        private String element;
        private JLabel labelElement;
        private JComboBox ppCandidate;
        private JButton fileChooser;
        private File ppDir;
        private String NO_CANDIDATE = Utils.NO_CANDIDATE;
        private ChaseFileManager cfManager;
        private boolean isLDA = false;
        private boolean isPAW = false;

        protected PseudoPotentialSelector(String ID) {
            this.ID = ID;
            this.inputInterface = PseudoPotentialPanel.this.projectInfo.getInputInterface();
            GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
            this.cfManager = PseudoPotentialPanel.this.projectInfo.getChaseFileManager();
            PseudoPotentialPanel.this.logger.debug((Object)("proj. info associated to ChaseFileManager: " + this.cfManager.getProjectInfo()));
            String strpp = Utils.getDefaultPPDir();
            this.ppDir = new File(strpp);
            this.setLayout(new GridBagLayout());
            this.init();
            if (this.cfManager == null) {
                this.setElementName(null);
                PseudoPotentialPanel.this.logger.error((Object)"invalid chasefilemanager");
            } else {
                ChaseFile[] pots = this.cfManager.getFiles("F_POT(.+)");
                if (pots != null && pots.length >= Integer.parseInt(ID)) {
                    PseudoPotentialPanel.this.logger.debug((Object)("ppname at this point " + pots[Integer.parseInt(ID) - 1].getFileName()));
                    String ppName = pots[Integer.parseInt(ID) - 1].getFileName();
                    if (ppName != null && ppName.length() != 0) {
                        String pdir = pots[Integer.parseInt(ID) - 1].getRelativePath();
                        if (pdir != null && new File(pdir).exists() && new File(pdir).isDirectory()) {
                            this.ppDir = new File(String.valueOf(PseudoPotentialPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + pdir);
                            PseudoPotentialPanel.this.logger.debug((Object)("ppDir : " + this.ppDir.getAbsolutePath()));
                        }
                        String elname = ppName.split("_")[0];
                        this.setElementName(elname, ppName);
                    }
                }
                this.ppCandidate.setToolTipText("Directory : " + this.ppDir.getAbsolutePath());
            }
        }

        private void init() {
            InputInterfacePrimitiveEntry paw;
            this.inputInterface.selectRoot();
            this.inputInterface.selectBlock("accuracy");
            InputInterfacePrimitiveEntry xc = this.inputInterface.getPrimitiveEntry("xctype");
            if (xc != null) {
                this.isLDA = xc.getValue().toLowerCase().startsWith("lda");
            }
            if ((paw = this.inputInterface.getPrimitiveEntry("paw")) == null || paw.getValue().length() == 0) {
                paw = this.inputInterface.getPrimitiveEntry("paw_switch");
            }
            if (paw != null) {
                this.isPAW = Utils.getBool(paw.getValue());
            }
            GridBagConstraints gc = new GridBagConstraints();
            JLabel labelID = new JLabel(this.ID);
            this.labelElement = new JLabel(this.element);
            this.ppCandidate = new JComboBox();
            this.ppCandidate.setEnabled(false);
            this.ppCandidate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PseudoPotentialSelector.this.ppCandidate.getSelectedItem() != null && !PseudoPotentialSelector.this.ppCandidate.getSelectedItem().toString().equals(PseudoPotentialSelector.this.NO_CANDIDATE)) {
                        PseudoPotentialSelector.this.updateFileInfo();
                    }
                }
            });
            this.fileChooser = new JButton("choose");
            this.fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PseudoPotentialSelector.this.selectPPFromChooser();
                }
            });
            JPanel panel1 = new JPanel();
            panel1.setLayout(new GridLayout());
            panel1.add(labelID);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new GridLayout());
            panel2.add(this.labelElement);
            this.labelElement.setPreferredSize(new Dimension(20, 25));
            JPanel panel3 = new JPanel();
            panel3.setLayout(new GridLayout());
            panel3.add(this.ppCandidate);
            JPanel panel4 = new JPanel();
            panel4.setLayout(new GridLayout());
            panel4.add(this.fileChooser);
            gc.weightx = 0.2;
            gc.ipadx = 40;
            gc.insets = new Insets(0, 20, 0, 30);
            this.add((Component)panel1, gc);
            gc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)panel2, gc);
            gc.weightx = 0.5;
            this.ppCandidate.setPreferredSize(new Dimension(130, 25));
            this.add((Component)this.ppCandidate, gc);
            gc.weightx = 0.2;
            this.add((Component)panel4, gc);
        }

        protected void clear() {
            this.setElementName("");
            ChaseFile[] pots = this.cfManager.getFiles("F_POT(.+)");
            if (pots != null && pots.length >= Integer.parseInt(this.ID)) {
                this.cfManager.removeFile(pots[Integer.parseInt(this.ID) - 1]);
            }
        }

        protected String getElementName() {
            return this.element;
        }

        private void setElementName(String elementName, String ppName) {
            this.element = elementName;
            this.labelElement.setText(elementName);
            String[] ppcands = this.getPPChoices(elementName);
            this.ppCandidate.removeAllItems();
            int i = 0;
            while (i < ppcands.length) {
                this.ppCandidate.addItem(ppcands[i]);
                ++i;
            }
            String pptype = "gga";
            if (this.isLDA) {
                pptype = "lda";
            }
            String[] pptype2 = new String[]{"us", "nc"};
            if (this.isPAW) {
                pptype2 = new String[]{"paw"};
            }
            if (ppName != null) {
                String[] stringArray = ppcands;
                int n = ppcands.length;
                int n2 = 0;
                while (n2 < n) {
                    String pp = stringArray[n2];
                    if (pp.equals(ppName)) {
                        this.ppCandidate.setSelectedItem(pp);
                        return;
                    }
                    ++n2;
                }
            }
            int i2 = 0;
            while (i2 < ppcands.length) {
                if (ppcands[i2].indexOf(pptype) != -1) {
                    int j = 0;
                    while (j < pptype2.length) {
                        if (ppcands[i2].indexOf(pptype2[j]) != -1) {
                            this.ppCandidate.setSelectedIndex(i2);
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }

        protected void setElementName(String elementName) {
            this.setElementName(elementName, null);
        }

        private void selectPPFromChooser() {
            ChaseFileChooser chooser = new ChaseFileChooser("pp");
            chooser.setDialogType(2);
            chooser.setDialogTitle("select pseudopotential file");
            chooser.setFileSelectionMode(0);
            if (chooser.showOpenDialog(this) != 0) {
                return;
            }
            File pppath = chooser.getSelectedFile().getAbsoluteFile();
            this.ppCandidate.removeAllItems();
            this.ppDir = pppath.getParentFile();
            this.ppCandidate.setToolTipText("Directory : " + this.ppDir.getAbsolutePath());
            this.ppCandidate.addItem(pppath.getName());
            this.revalidate();
        }

        private void updateFileInfo() {
            PseudoPotentialPanel.this.logger.debug((Object)("pp-filename: " + this.ppCandidate.getSelectedItem()));
            String pp_dire = this.ppDir.getAbsolutePath();
            String projdir = PseudoPotentialPanel.this.projectInfo.getProjectDirectory();
            String dir = Utils.getRelativePath(projdir, pp_dire);
            ChaseFile[] pots = this.cfManager.getFiles("F_POT(.+)");
            if (pots == null || pots.length < Integer.parseInt(this.ID)) {
                PseudoPotentialPanel.this.logger.debug((Object)"no existing pp...");
                PseudoPotentialPanel.this.logger.debug((Object)("adding: " + dir + "/" + (String)this.ppCandidate.getSelectedItem()));
                this.cfManager.addFile(dir, "F_POT(" + Integer.parseInt(this.ID) + ")", (String)this.ppCandidate.getSelectedItem());
            } else {
                pots[Integer.parseInt(this.ID) - 1].update("filename", (String)this.ppCandidate.getSelectedItem());
                pots[Integer.parseInt(this.ID) - 1].update("relative_path", dir);
            }
            this.cfManager.save();
        }

        private String[] getPPChoices(String element) {
            String[] cands = Utils.getPPCandidates(element, this.ppDir.getAbsolutePath());
            this.ppCandidate.setEnabled(true);
            if (cands[0].equals(this.NO_CANDIDATE)) {
                this.ppCandidate.setEnabled(false);
            }
            return cands;
        }
    }
}

