/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.jobcontrolpanel;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.file.FileTransferPanel;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.jobcontrol.MonitorPanelPanel;
import ciss.phase_viewer.plugins.projectmanipulator.BasicReportGenerator;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectInfoChangeEvent;
import ciss.phase_viewer.projectbrowser.ProjectInfoListener;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.scripting.scriptmanipulator.ScriptManipulator;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostSelectorCombo;
import ciss.phase_viewer.ssh.sftp.Sftp;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.ChannelSftp;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class JobControlPanel
extends ProjectManipulator
implements ProjectInfoListener {
    private Logger logger = Logger.getLogger((String)JobControlPanel.class.getName());
    private JobControlSubPanel subPanel;
    private FileTransferPanel fileTransferPanel;
    private String reportGeneratorPath;
    private MonitorPanelPanel monpanel;
    private ScriptManipulator browser;
    private String REPORT_GEN_PATH = "__REPORT_GEN_PATH__";
    private String reportFileName = "report.bsh";
    private String reportbsh = "import ciss.phase_viewer.main.*;\nimport ciss.phase_viewer.jobcontrol.*;\nreportGenPath=\"" + this.REPORT_GEN_PATH + "\";\n" + "generator=PluginLoader.instantiate(reportGenPath,null);\n" + "reportByMail(generator);";
    private String[] emailTags = new String[]{"mail_smtphost", "mail_from_address", "mail_from_user", "mail_to_address"};
    private JCheckBox email;
    private JPanel pp;
    private String MPI_PARAMS = "MPI_Params";

    @Override
    public void projectInfoChanged(ProjectInfoChangeEvent ev) {
        if (this.fileTransferPanel != null) {
            this.fileTransferPanel.setSelectedHost(ev.getProjectInfo().getHostInfo());
        }
        this.setDefaultEmailSelected();
    }

    public JobControlPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void init() {
        this.projectInfo.addProjectInfoListener(this);
        this.reportGeneratorPath = BasicReportGenerator.getReportGeneratorPath(this.projectInfo);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.subPanel = new JobControlSubPanel();
        this.browser = new ScriptManipulator(this.projectInfo);
        this.fileTransferPanel.addActionListenerToHostSelector(this.browser);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(null, "Job control panel", 0, 0, new Font("MS Sans Serif", 0, 11), new Color(0, 51, 153)));
        this.add(this.subPanel);
        this.monpanel = new MonitorPanelPanel(this.projectInfo, this.fileTransferPanel.getSelectedHost());
        this.fileTransferPanel.addActionListenerToHostSelector(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (JobControlPanel.this.monpanel != null) {
                    JobControlPanel.this.monpanel.setTargetHost(JobControlPanel.this.fileTransferPanel.getSelectedHost());
                }
            }
        });
        this.subPanel.add(this.monpanel);
        this.revalidate();
        this.setDefaultEmailSelected();
    }

    @Override
    public void postInit() {
        this.browser.adjust();
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public boolean postProcess() {
        this.subPanel.save();
        return true;
    }

    private void toggleReport() {
        File reportFile = new File(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.reportFileName);
        File mailxml = new File(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "mail.xml");
        if (this.email.isSelected()) {
            String str = this.reportbsh.replaceAll(this.REPORT_GEN_PATH, this.reportGeneratorPath);
            PrintWriter writer = Utils.getPrintWriter(reportFile.getAbsolutePath());
            if (writer != null) {
                writer.print(str);
                writer.flush();
                writer.close();
            }
            Document document = new Document();
            Element rootElement = new Element("root");
            HostInfo hostInfo = this.projectInfo.getHostInfo();
            int i = 0;
            while (i < this.emailTags.length) {
                rootElement.addContent((Content)new Element(this.emailTags[i]).setText(MyElement.encode(hostInfo.getProperty(this.emailTags[i]))));
                ++i;
            }
            document.setRootElement(rootElement);
            XMLUtils.saveDocumentTo(document, mailxml);
        } else {
            reportFile.delete();
            mailxml.delete();
        }
    }

    private void setDefaultEmailSelected() {
        if (this.email == null) {
            return;
        }
        boolean valid = true;
        int i = 0;
        while (i < this.emailTags.length) {
            if (this.projectInfo.getHostInfo().getProperty(this.emailTags[i]) == null || this.projectInfo.getHostInfo().getProperty(this.emailTags[i]).trim().length() == 0) {
                valid = false;
            }
            ++i;
        }
        if (!valid) {
            this.email.setSelected(false);
            this.email.setEnabled(false);
            return;
        }
        this.email.setEnabled(true);
        if (new Boolean(this.projectInfo.getHostInfo().getProperty("mail_default")).booleanValue()) {
            this.email.setSelected(true);
            this.toggleReport();
        } else {
            this.email.setSelected(false);
            this.toggleReport();
        }
    }

    class JobControlSubPanel
    extends JPanel {
        private Logger logger = Logger.getLogger((String)JobControlSubPanel.class.getName());
        private HostSelectorCombo hosts;
        private String baseDir;
        private ChaseFileManager cfManager;
        private JTextField ne;
        private JTextField nk;
        private JTextField np;
        private JButton bexe;
        private JButton bedit;
        private JButton bstop;
        private JButton bmon;

        protected JobControlSubPanel() {
            this.setLayout(new GridLayout(2, 0));
            this.baseDir = String.valueOf(JobControlPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator");
            this.cfManager = JobControlPanel.this.projectInfo.getChaseFileManager();
            JobControlPanel.this.fileTransferPanel = new FileTransferPanel(JobControlPanel.this.projectInfo);
            JobControlPanel.this.pp = new JPanel();
            JobControlPanel.this.pp.setLayout(new BoxLayout(JobControlPanel.this.pp, 1));
            JobControlPanel.this.pp.add(JobControlPanel.this.fileTransferPanel);
            JobControlPanel.this.pp.add(this.createMPIPanel());
            JobControlPanel.this.pp.add(this.createExePanel());
            JScrollPane pane = new JScrollPane(JobControlPanel.this.pp);
            this.add(pane);
        }

        private JPanel createMPIPanel() {
            String snp = "1";
            String sne = "1";
            String snk = "1";
            Element root = JobControlPanel.this.projectInfo.getProjectPropertyDocument().getRootElement();
            Element mpiparams = root.getChild(JobControlPanel.this.MPI_PARAMS);
            if (mpiparams != null) {
                snp = mpiparams.getChildTextTrim("np");
                sne = mpiparams.getChildTextTrim("ne");
                snk = mpiparams.getChildTextTrim("nk");
                try {
                    Integer.parseInt(snp);
                    Integer.parseInt(sne);
                    Integer.parseInt(snk);
                }
                catch (NumberFormatException nfe) {
                    snp = "1";
                    sne = "1";
                    snk = "1";
                }
            }
            boolean enableMPI = new Boolean(PropertiesManager.getGlobalProperties(0).getProperty("mpienable"));
            JPanel ret = new JPanel();
            ret.setLayout(new BoxLayout(ret, 0));
            ret.setBorder(new TitledBorder("MPI parameters (note: np = ne x nk)"));
            JPanel pnp = new JPanel();
            pnp.setBorder(new TitledBorder("np"));
            this.np = new JTextField(snp, 10);
            pnp.add(this.np);
            JPanel pnk = new JPanel();
            pnk.setBorder(new TitledBorder("nk"));
            this.nk = new JTextField(snk, 10);
            pnk.add(this.nk);
            JPanel pne = new JPanel();
            pne.setBorder(new TitledBorder("ne"));
            this.ne = new JTextField(sne, 10);
            pne.add(this.ne);
            this.np.setEnabled(enableMPI);
            this.nk.setEnabled(enableMPI);
            this.ne.setEditable(enableMPI);
            this.np.setBackground(Color.WHITE);
            this.nk.setBackground(Color.WHITE);
            this.ne.setBackground(Color.WHITE);
            ret.add(pnp);
            ret.add(pnk);
            ret.add(pne);
            this.np.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent ce) {
                    JobControlSubPanel.this.save();
                }
            });
            this.nk.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent ce) {
                    JobControlSubPanel.this.save();
                    try {
                        int ink = Integer.parseInt(JobControlSubPanel.this.nk.getText().trim());
                        int ine = Integer.parseInt(JobControlSubPanel.this.ne.getText().trim());
                        int inp = Integer.parseInt(JobControlSubPanel.this.np.getText().trim());
                        if (ink * ine != inp) {
                            JobControlSubPanel.this.np.setText(String.valueOf(ink * ine));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.ne.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent ce) {
                    JobControlSubPanel.this.save();
                    try {
                        int ink = Integer.parseInt(JobControlSubPanel.this.nk.getText().trim());
                        int ine = Integer.parseInt(JobControlSubPanel.this.ne.getText().trim());
                        int inp = Integer.parseInt(JobControlSubPanel.this.np.getText().trim());
                        if (ink * ine != inp) {
                            JobControlSubPanel.this.np.setText(String.valueOf(ink * ine));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return ret;
        }

        private JPanel createExePanel() {
            JPanel ret = new JPanel();
            ret.setBorder(new TitledBorder("execution control"));
            this.bexe = new JButton("execute");
            ret.add(this.bexe);
            this.bmon = new JButton("monitor");
            String cluster = System.getProperty("cluster_support");
            if (cluster != null && cluster.equals("true")) {
                this.bedit = new JButton("edit job script");
                ret.add(this.bedit);
            }
            this.bstop = new JButton("terminate");
            ret.add(this.bstop);
            JobControlPanel.this.email = new JCheckBox("notify end of job by email");
            JobControlPanel.this.fileTransferPanel.addActionListenerToHostSelector(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            this.bexe.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!JobController.execute(JobControlPanel.this.projectInfo, JobControlPanel.this.fileTransferPanel.getSelectedHost())) {
                        JobControlSubPanel.this.logger.error((Object)"failed execution");
                    } else {
                        JobControlPanel.this.monpanel.reset();
                        JobControlPanel.this.monpanel.run();
                    }
                }
            });
            if (cluster != null && cluster.equals("true")) {
                this.bedit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        String pdir = String.valueOf(JobControlPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator");
                        String submit = "submit.sh";
                        if (JobControlPanel.this.projectInfo.getHostInfo().getName().equals("localhost") && Utils.isWindows()) {
                            submit = "submit.bat";
                        }
                        ProjectBrowserUtils.bootTextViewer(String.valueOf(pdir) + submit);
                    }
                });
            }
            this.bstop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JobControlSubPanel.this.terminate();
                }
            });
            JobControlPanel.this.email.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JobControlPanel.this.toggleReport();
                }
            });
            return ret;
        }

        private void terminate() {
            new Thread(new NFSTOP()).start();
        }

        private void checkMPIParams(String mode) {
            int ine;
            int ink;
            int inp;
            String snp = this.np.getText();
            String snk = this.nk.getText();
            String sne = this.ne.getText();
            boolean pvalid = true;
            boolean kvalid = true;
            boolean evalid = true;
            try {
                inp = Integer.parseInt(snp);
            }
            catch (NumberFormatException nfe) {
                inp = 1;
                pvalid = false;
            }
            try {
                ink = Integer.parseInt(snk);
            }
            catch (NumberFormatException nfe) {
                ink = 1;
                kvalid = false;
            }
            try {
                ine = Integer.parseInt(sne);
            }
            catch (NumberFormatException nfe) {
                ine = 1;
                evalid = false;
            }
            if (inp != ink * ine) {
                mode.equals("np");
            }
        }

        protected void save() {
            String snp = this.np.getText();
            String snk = this.nk.getText();
            String sne = this.ne.getText();
            try {
                Integer.parseInt(snp);
                Integer.parseInt(snk);
                Integer.parseInt(sne);
            }
            catch (NumberFormatException nfe) {
                snp = "1";
                snk = "1";
                sne = "1";
            }
            Element root = JobControlPanel.this.projectInfo.getProjectPropertyDocument().getRootElement();
            Element mpiparams = root.getChild(JobControlPanel.this.MPI_PARAMS);
            if (mpiparams != null) {
                mpiparams.getChild("np").setText(snp);
                mpiparams.getChild("nk").setText(snk);
                mpiparams.getChild("ne").setText(sne);
            } else {
                Element mpi_params = new Element(JobControlPanel.this.MPI_PARAMS);
                root.addContent((Content)mpi_params);
                mpi_params.addContent((Content)new Element("np").setText(snp));
                mpi_params.addContent((Content)new Element("nk").setText(snk));
                mpi_params.addContent((Content)new Element("ne").setText(sne));
            }
            JobControlPanel.this.projectInfo.saveProjectPropertyDocument();
        }

        class HTMLPanel
        extends JPanel {
            HTMLPanel() {
                this.setLayout(new GridLayout());
                this.initComponents();
            }

            private void initComponents() {
            }
        }

        class NFSTOP
        implements Runnable,
        SftpListener {
            NFSTOP() {
            }

            @Override
            public void run() {
                String nfstop;
                String dir;
                block22: {
                    Element root = JobControlPanel.this.projectInfo.getProjectPropertyDocument().getRootElement();
                    Element jobcontrol = root.getChild("jobcontrol");
                    Element script = null;
                    if (jobcontrol != null) {
                        try {
                            script = jobcontrol.getChild("script").getChild("script_type");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String nfstopname = "nfstop.data";
                    boolean bshscr = false;
                    if (script != null && script.getTextTrim().equalsIgnoreCase("bsh")) {
                        bshscr = true;
                        nfstopname = "bshstop.data";
                    }
                    dir = JobControlPanel.this.projectInfo.getProjectDirectory();
                    if (bshscr) {
                        JobControlSubPanel.this.logger.debug((Object)"stopping bsh script");
                        File filestop = new File(String.valueOf(dir) + System.getProperty("file.separator") + nfstopname);
                        try {
                            filestop.createNewFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!JobControlPanel.this.projectInfo.getHostInfo().isLocalHost()) {
                            Sftp sftp = new Sftp(JobControlPanel.this.projectInfo.getHostInfo());
                            sftp.addSftpListener(this);
                            sftp.connect();
                            ChannelSftp c = sftp.getChannelSftp();
                            RemoteFile[] rfs = new RemoteFile[]{new RemoteFile(filestop.getAbsolutePath())};
                            String targetdir = JobControlPanel.this.projectInfo.getTargetDirectory();
                            sftp.upload(rfs, new RemoteFile(targetdir, c), dir);
                        } else {
                            JobControlSubPanel.this.logger.info((Object)"submitted bshstop.data");
                        }
                        return;
                    }
                    nfstop = String.valueOf(dir) + System.getProperty("file.separator") + nfstopname;
                    PrintWriter writer = null;
                    try {
                        try {
                            writer = new PrintWriter(new BufferedWriter(new FileWriter(nfstop)));
                            writer.println("1");
                            writer.flush();
                        }
                        catch (Exception c) {
                            try {
                                writer.close();
                            }
                            catch (Exception targetdir) {}
                            break block22;
                        }
                    }
                    catch (Throwable rfs) {
                        try {
                            writer.close();
                        }
                        catch (Exception targetdir) {
                            // empty catch block
                        }
                        throw rfs;
                    }
                    try {
                        writer.close();
                    }
                    catch (Exception targetdir) {
                        // empty catch block
                    }
                }
                HostInfo hinfo = JobControlPanel.this.projectInfo.getHostInfo();
                if (hinfo.isLocalHost()) {
                    JobControlSubPanel.this.logger.info((Object)"submitted nfstop.data");
                } else {
                    Sftp sftp = new Sftp(hinfo);
                    sftp.addSftpListener(this);
                    sftp.connect();
                    ChannelSftp c = sftp.getChannelSftp();
                    RemoteFile[] rfs = new RemoteFile[]{new RemoteFile(nfstop)};
                    String targetdir = JobControlPanel.this.projectInfo.getTargetDirectory();
                    sftp.upload(rfs, new RemoteFile(targetdir, c), dir);
                }
            }

            @Override
            public void uploadFinished(SftpEvent e) {
                JobControlSubPanel.this.logger.info((Object)("submitted nfstop.data to " + JobControlPanel.this.projectInfo.getHostInfo().getName() + ":" + JobControlPanel.this.projectInfo.getTargetDirectory()));
                String dir = JobControlPanel.this.projectInfo.getProjectDirectory();
                String nfstop = String.valueOf(dir) + System.getProperty("file.separator") + "nfstop.data";
                new File(nfstop).delete();
            }

            @Override
            public void downloadFinished(SftpEvent e) {
            }
        }
    }
}

