/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Importable;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.input.InputWizardEvent;
import ciss.phase_viewer.input.InputWizardListener;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.ImportButton;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class CoordsWiz
implements InputWizard,
Importable,
ActionListener,
TableModelListener,
ACVCaller,
InputWizardListener {
    private Logger logger = Logger.getLogger((String)CoordsWiz.class.getName());
    private JPanel panel;
    private InputInterface input;
    private ImportButton importButton;
    private JTextField selectedFile;
    private boolean hasNext = false;
    private boolean hasFinished = false;
    private JCheckBox metallic;
    private JCheckBox spin;
    private JCheckBox symmetry;
    private HashMap properties;
    private InputWizardController parent;
    private AtomCoords coords;
    private JPanel atcoordsPanel;
    private String atomtag = StringConstants.phase_atom_tag;
    private TableModel modCell;
    private JComboBox unitCellType;
    private JTable tfatom;

    @Override
    public String process() {
        if (this.symmetry.isSelected()) {
            this.input.getInputInterfacePrimitiveEntry("structure.symmetry.method").setValue("automatic");
        }
        return "created atomic coordinates";
    }

    @Override
    public void setInput(Input input) {
        this.input = (InputInterface)input;
    }

    @Override
    public boolean hasPrevious() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean hasFinished() {
        return this.hasFinished;
    }

    @Override
    public String getName() {
        return "atomic coordinates";
    }

    @Override
    public JPanel getGUI() {
        if (this.panel == null) {
            this.createGUI();
        }
        return this.panel;
    }

    private void update() {
        File file = new File(this.selectedFile.getText());
        this.hasFinished = this.hasNext = file.exists() && file.length() != 0L;
        this.metallic.setEnabled(this.hasNext);
        this.spin.setEnabled(this.hasNext);
        this.symmetry.setEnabled(this.hasNext);
        this.parent.update(this);
    }

    private void createGUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        this.selectedFile = new JTextField(15);
        this.selectedFile.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                CoordsWiz.this.update();
            }
        });
        this.importButton = new ImportButton("select coords file", this, this);
        filePanel.add(this.selectedFile);
        filePanel.add(this.importButton);
        this.metallic = new JCheckBox("metallic");
        this.spin = new JCheckBox("spin");
        this.symmetry = new JCheckBox("symmetry");
        this.metallic.setEnabled(false);
        this.spin.setEnabled(false);
        this.symmetry.setEnabled(false);
        this.panel.add(filePanel);
        filePanel.add(this.metallic);
        filePanel.add(this.spin);
        filePanel.add(this.symmetry);
    }

    @Override
    public String getDescription() {
        return "specify/edit atomic coordinates";
    }

    @Override
    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    @Override
    public void setParent(InputWizardController parent) {
        this.parent = parent;
        this.parent.addInputWizardListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ((Command)e.getSource()).execute(e);
    }

    private void createAtomCoordsPanel() {
        if (this.atcoordsPanel == null) {
            this.atcoordsPanel = new JPanel();
        }
        this.atcoordsPanel.removeAll();
        this.atcoordsPanel.add(this.getAtomCoordsPanel());
        this.atcoordsPanel.revalidate();
    }

    @Override
    public void coordsImported(AtomCoords[] crds, String type, String fileName) {
        this.selectedFile.setText(fileName);
        if (crds != null && crds.length != 0) {
            this.coords = crds[0];
        }
        this.logger.debug((Object)("removing ignore-on-save atoms; curr numat: " + this.coords.getNumAt()));
        this.coords.removeIgnoreOnSaveAtoms();
        this.coords.convert(7, 9);
        this.logger.debug((Object)("removed ignore-on-save atoms; currnumat: " + this.coords.getNumAt()));
        this.coords.atomCoords2InputInterface(this.input, this.atomtag);
        ElementInfo.updateElement(this.input);
        this.createAtomCoordsPanel();
        this.panel.add(this.atcoordsPanel);
    }

    private void createCoords() {
        this.coords = new AtomCoords();
        this.coords.createCellFromTableModel(this.modCell);
        this.coords.inputInterface2AtomCoords(this.input, this.atomtag);
        this.coords.setUnit(1);
        this.coords.isCart(false);
    }

    private void bootViewer() {
        this.createCoords();
        String baseDir = new File(this.input.getFileName()).getParent();
        this.coords.convert(6, 8);
        this.coords.createBravaisLattice(this.input, !BravaisLattice.isBravais(this.input));
        BravaisLattice bl = this.coords.getBravaisLattice();
        Vector<AtomCoords> vec = new Vector<AtomCoords>();
        vec.addElement(this.coords);
        ACVData acvdata = new ACVData((ACVCaller)this, vec, baseDir, this.input, this.atomtag);
        acvdata.setBravaisLattice(bl);
        CoordsViewerBooter cvb = new CoordsViewerBooter(acvdata);
        cvb.boot();
    }

    private JPanel getAtomCoordsPanel() {
        this.unitCellType = new JComboBox<String>(new String[]{"Bravais", "primitive"});
        JPanel ptype = new JPanel();
        ptype.setBorder(new TitledBorder("unitcell type"));
        ptype.add(this.unitCellType);
        JButton bootbtn = new JButton("boot viewer");
        JPanel btnpanel = new JPanel();
        btnpanel.add(ptype);
        btnpanel.add(bootbtn);
        this.unitCellType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordsWiz.this.input.getInputInterfacePrimitiveEntry("structure.unit_cell_type").setValue(CoordsWiz.this.unitCellType.getSelectedItem().toString());
            }
        });
        this.unitCellType.setSelectedIndex(0);
        bootbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordsWiz.this.bootViewer();
            }
        });
        JPanel p_atom_all = new JPanel();
        p_atom_all.setLayout(new BoxLayout(p_atom_all, 1));
        Cell cell = this.coords.getCell(0);
        String[][] strcell = cell.getCell();
        String[] tmp = new String[]{"structure.unit_cell"};
        TableForInputInterface tfcell = new TableForInputInterface(tmp, this.input, null, this, 0);
        this.modCell = tfcell.getModel();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                tfcell.setValueAt(strcell[i][j], i, j + 1);
                ++j;
            }
            ++i;
        }
        JPanel pcell = new JPanel();
        pcell.setLayout(new BorderLayout());
        pcell.add((Component)tfcell.getPanel(), "West");
        pcell.add((Component)btnpanel, "East");
        p_atom_all.add(pcell);
        String[] atmtable = new String[]{this.atomtag};
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        int[] map = nArray;
        this.tfatom = new TableForInputInterface(atmtable, this.input, map, this);
        p_atom_all.add(this.tfatom);
        JPanel panelAtom = new JPanel();
        panelAtom.setLayout(new BoxLayout(panelAtom, 1));
        panelAtom.add(((TableForInputInterface)this.tfatom).getPanel());
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(((TableForInputInterface)this.tfatom).getPanel());
        scrPane.setPreferredSize(new Dimension(500, 150));
        p_atom_all.add(scrPane);
        p_atom_all.setBorder(new TitledBorder("atomic coordinates"));
        this.coords.setModels(this.tfatom.getModel(), null);
        return p_atom_all;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        ((Command)e.getSource()).execute(e);
    }

    @Override
    public void save(AtomCoords crds) {
        this.coords = crds;
        this.coords.removeIgnoreOnSaveAtoms();
        this.coords.convert(7, 9);
        this.coords.atomCoords2InputInterface(this.input, this.atomtag);
        ElementInfo.updateElement(this.input);
        this.createAtomCoordsPanel();
        if (this.coords.getBravaisLattice() != null) {
            this.logger.debug((Object)"setting unitCellType");
            BravaisLattice blat = this.coords.getBravaisLattice();
            if (blat.isBravais()) {
                this.unitCellType.setSelectedIndex(0);
            } else {
                this.unitCellType.setSelectedIndex(1);
            }
        } else {
            this.logger.debug((Object)"bravais lattice is null!");
        }
    }

    @Override
    public void stateChanged(InputWizardEvent ev) {
        if (ev.getState() == InputWizardEvent.TO_NEXT || ev.getState() == InputWizardEvent.TO_PREVIOUS || ev.getState() == InputWizardEvent.FINISHING) {
            this.createCoords();
            this.properties.put("atomcoords", this.coords);
            this.properties.put("metallic", String.valueOf(this.metallic.isSelected()));
            this.properties.put("spin", String.valueOf(this.spin.isSelected()));
            ElementInfo.updateElement(this.input);
        }
    }
}

