/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputcheck;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.input.PhaseInputChecker;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PseudoPotChecker
extends PhaseInputChecker {
    private Logger logger = Logger.getLogger((String)PseudoPotChecker.class.getName());

    @Override
    public boolean isFixable() {
        return true;
    }

    @Override
    public String getName() {
        return "pseudopotential specification";
    }

    @Override
    public String getDescription() {
        return "check whether the specification of the PPs is valid.";
    }

    @Override
    public String getCandidate() {
        if (this.state != 0) {
            return "will correct pp file specification";
        }
        return "";
    }

    private boolean isLDA() {
        boolean isLDA = false;
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock("accuracy");
        InputInterfacePrimitiveEntry prim = this.inputInterface.getPrimitiveEntry("xctype");
        if (prim.getValue().toLowerCase().startsWith("lda")) {
            isLDA = true;
        }
        this.inputInterface.selectRoot();
        return isLDA;
    }

    private String getXCType() {
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock("accuracy");
        InputInterfacePrimitiveEntry prim = this.inputInterface.getPrimitiveEntry("xctype");
        String ret = prim.getValue();
        this.inputInterface.selectRoot();
        return ret;
    }

    @Override
    public boolean fixInput() {
        InputInterfaceTable elemtable = this.inputInterface.getInputInterfaceTable("structure.element_list");
        int elemind = elemtable.getIndexFor("element");
        Vector data = elemtable.getTableData();
        String ppdir = Utils.getDefaultPPDir();
        String relpath = Utils.getRelativePath(this.projDir, ppdir).replaceAll("\\\\", "/");
        Vector<String> vec = new Vector<String>();
        boolean isLDA = this.isLDA();
        int i = 0;
        while (i < data.size()) {
            String elemName = Utils.stripNumber(((String[])data.get(i))[elemind]);
            String[] pps = Utils.getPPCandidates(elemName);
            if (pps == null || pps[0].equals(Utils.NO_CANDIDATE)) {
                this.logger.error((Object)("could not find pp file for element " + elemName));
                return false;
            }
            String newestPP = pps[pps.length - 1];
            if (isLDA) {
                int j = pps.length - 1;
                while (j >= 0) {
                    if (pps[j].toLowerCase().indexOf("lda") > 0) {
                        newestPP = pps[j];
                        break;
                    }
                    --j;
                }
            }
            vec.addElement(String.valueOf(relpath) + "/" + newestPP);
            ++i;
        }
        String fdata = "";
        try {
            BufferedReader rd = new BufferedReader(new FileReader(this.fileNamesData));
            String line = "";
            while ((line = rd.readLine()) != null) {
                if ((line = line.trim()).startsWith("F_POT") || line.startsWith("/") || line.startsWith("&end")) continue;
                fdata = String.valueOf(fdata) + line + System.getProperty("line.separator");
            }
            rd.close();
            int i2 = 0;
            while (i2 < vec.size()) {
                fdata = String.valueOf(fdata) + "F_POT(" + String.valueOf(i2 + 1) + ") = '" + vec.get(i2).toString() + "'" + System.getProperty("line.separator");
                ++i2;
            }
            fdata = String.valueOf(fdata) + "/";
            PrintWriter wr = new PrintWriter(new FileWriter(this.fileNamesData));
            wr.print(fdata);
            wr.flush();
            wr.close();
        }
        catch (IOException ioe) {
            this.logger.error((Object)"failed to manipulate file_names.data");
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public int doCheck() {
        String[] pots = this.getAllFilePath("F_POT(");
        if (pots == null) {
            this.message = "no ppfiles specified in file_names.data";
            return -2;
        }
        InputInterfaceTable elemtable = this.inputInterface.getInputInterfaceTable("structure.element_list");
        int elemind = elemtable.getIndexFor("element");
        Vector data = elemtable.getTableData();
        if (pots.length != data.size()) {
            this.message = "number of elements and pp files are inconsistent";
            return -2;
        }
        String xctype = this.getXCType();
        int i = 0;
        while (i < data.size()) {
            String potelemname;
            String elemName = Utils.stripNumber(((String[])data.get(i))[elemind]);
            if (!elemName.equalsIgnoreCase(potelemname = new File(pots[i]).getName().split("_")[0])) {
                this.message = "element block and pp specifications are inconsistent";
                return -2;
            }
            if (xctype.toLowerCase().trim().startsWith("lda") && pots[i].toLowerCase().indexOf("lda") < 0) {
                this.message = "accuracy.xctype is LDA, but " + pots[i] + " is not an LDA pp file";
                return -2;
            }
            if (xctype.toLowerCase().trim().startsWith("gga") && pots[i].toLowerCase().indexOf("gga") < 0) {
                this.message = "accuracy.xctype is GGA, but " + pots[i] + " is not a GGA pp file";
                return -2;
            }
            ++i;
        }
        return 0;
    }
}

