/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.file;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.SimpleMonitor;
import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.graph.SimpleChart;
import ciss.phase_viewer.graph.XYData;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Dimension;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jfree.chart.axis.AxisLocation;

public class StdOutMonitor
extends SimpleMonitor {
    private Logger logger = Logger.getLogger((String)StdOutMonitor.class.getName());
    private String TOTAL_ENERGY = "TOTAL ENERGY";

    public StdOutMonitor(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public String getFileToMonitor() {
        return this.projectInfo.getChaseFileManager().getFile("F_OUT").getDefaultName().getValue();
    }

    @Override
    public ChaseFile getChaseFile() {
        ChaseFile cf = this.projectInfo.getChaseFileManager().getFile("F_OUT");
        return cf;
    }

    @Override
    protected void doGraph(String[] lines) {
        this.logger.debug((Object)"at doGraph");
        if (lines == null || lines.length == 0) {
            return;
        }
        Vector<double[]> dataVector = new Vector<double[]>();
        int i = 0;
        while (i < lines.length) {
            String[] ar;
            String line = lines[i].trim();
            this.logger.debug((Object)line);
            if (line.startsWith(this.TOTAL_ENERGY) && (ar = line.split("\\s+")).length >= 10) {
                try {
                    double[] tmp = new double[]{Double.parseDouble(ar[3]), Double.parseDouble(ar[6].replaceAll("D", "E")), Math.abs(Double.parseDouble(ar[9].replaceAll("D", "E")))};
                    dataVector.add(tmp);
                }
                catch (NumberFormatException nfe) {
                    this.logger.error((Object)("invalid line...: " + line));
                    this.logger.error((Object)("3,6,9: " + ar[3] + ", " + ar[6] + ", " + ar[9]));
                }
            }
            ++i;
        }
        if (dataVector.size() == 0 && !this.isGraphCreatable(this.textArea)) {
            return;
        }
        if (this.xyData == null) {
            this.xyData = new XYData[2];
            this.xyData[0] = new XYData("total energy");
            this.xyData[0].xValType = XYData.INTEGER;
            this.xyData[0].xAxisName = "iteration";
            this.xyData[0].yAxisName = "total energy(hartree)";
            this.xyData[0].collectionIndex = 0;
            this.xyData[1] = new XYData("edelta");
            this.xyData[1].xValType = XYData.INTEGER;
            this.xyData[1].yAxisLocation = AxisLocation.BOTTOM_OR_RIGHT;
            this.xyData[1].yisLog = true;
            this.xyData[1].yAxisName = "edelta (hartree)";
            this.xyData[1].collectionIndex = 1;
        }
        double[][] data = new double[dataVector.size()][];
        dataVector.copyInto((Object[])data);
        int i2 = 0;
        while (i2 < data.length) {
            this.xyData[0].add(data[i2][0], data[i2][1]);
            this.xyData[1].add(data[i2][0], data[i2][2]);
            ++i2;
        }
        if (!this.graph) {
            return;
        }
        if (this.graphPanel == null) {
            SimpleChart simpleChart = new SimpleChart(this.xyData);
            simpleChart.setSize(new Dimension(512, 400));
            simpleChart.setTitle("monitoring " + this.fileName);
            simpleChart.setChartTitle("total energy and dE");
            simpleChart.setChartProgressListener(this);
            this.graphPanel = new GraphPanel(simpleChart);
            this.graphPanel.addInternalFrameListener(this);
        }
        if (!this.graphPanel.isVisible()) {
            this.graphPanel.setVisible(true);
        }
    }
}

