/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.PathSelector;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.input.InputWizardControllerPHASE;
import ciss.phase_viewer.input.InputWizardEvent;
import ciss.phase_viewer.input.InputWizardListener;
import ciss.phase_viewer.input.InputWizardRoot;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseFileManager;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class PhaseInitializer
implements InputWizardListener {
    private Logger logger = Logger.getLogger((String)PhaseInitializer.class.getName());
    private ProjectInfo projectInfo;
    private final String FS = System.getProperty("file.separator");
    private String nfinp = "nfinp.data";
    private String templatePath;
    private URL fileinfofile = PhaseConstants.FILEINFO_PHASE;
    private ProjectManipulator parent;
    private ProjectDirBrowserNode node;
    private InputWizardController controller;
    private JComboBox typeCombo;
    private String[] typeChoice = new String[]{"SCF"};
    private JTextField iniFileName;
    private JComboBox initFileCombo;
    private String[] initFileChoice = new String[]{"from template", "wizard", "scratch"};
    private PathSelector selector;

    public PhaseInitializer(ProjectInfo projectInfo, ProjectManipulator parent, ProjectDirBrowserNode node) {
        this.projectInfo = projectInfo;
        this.parent = parent;
        this.node = node;
    }

    public void silentInitialization() {
        String baseDir;
        this.logger.debug((Object)"creating new project...");
        if (this.projectInfo == null) {
            this.logger.error((Object)"projectInfo is null!");
        }
        if ((baseDir = this.projectInfo.getProjectDirectory()) == null || baseDir.trim().length() == 0) {
            baseDir = System.getProperty("user.home");
        }
        this.initializeChaseXML(baseDir);
        this.initializeFileManager(baseDir);
    }

    public void runWizard() {
        String baseDir;
        this.logger.debug((Object)"creating new project...");
        if (this.projectInfo == null) {
            this.logger.error((Object)"projectInfo is null!");
        }
        if ((baseDir = this.projectInfo.getProjectDirectory()) == null || baseDir.trim().length() == 0) {
            baseDir = System.getProperty("user.home");
        }
        this.initializeChaseXML(baseDir);
        this.initializeFileManager(baseDir);
        String curnfinp = String.valueOf(baseDir) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_INP").getFileName();
        URL url = PhaseConstants.TABLESPEC;
        DataManager dm = new DataManager(curnfinp, url, false);
        dm.parse();
        InputInterface inp = dm.getInputInterface();
        try {
            IniWiz wiz = new IniWiz();
            this.controller = new InputWizardControllerPHASE(inp, (InputWizardRoot)wiz, this.projectInfo);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.controller.addInputWizardListener(this);
        this.node.getDirBrowser().getTree().scrollPathToVisible(new TreePath(this.node.getPath()));
        this.node.getDirBrowser().getTree().setSelectionPath(new TreePath(this.node.getPath()));
    }

    private void initializeFileManager(String baseDir) {
        this.logger.debug((Object)("baseDir: " + baseDir));
        File filenamesdata = new File(String.valueOf(baseDir) + this.FS + "file_names.data");
        PhaseFileManager pfm = new PhaseFileManager(this.fileinfofile, filenamesdata);
        this.logger.debug((Object)"ok");
        this.projectInfo.setChaseFileManager(pfm);
        this.logger.debug((Object)"FileManager initialized.");
    }

    private void initializeInputData(String baseDir) {
        ChaseFileManager foo;
        this.nfinp = this.iniFileName.getText().trim();
        this.templatePath = this.selector.getRawPath();
        if (this.nfinp == null || this.nfinp.trim().length() == 0) {
            this.nfinp = "nfinp.data";
        }
        this.logger.debug((Object)"init F_INP");
        if (this.initFileCombo.getSelectedIndex() == 2) {
            File inputFile = new File(String.valueOf(baseDir) + this.FS + this.nfinp);
            URL definputFile = this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/nfinp.data");
            try {
                int data;
                FileOutputStream fos = new FileOutputStream(inputFile);
                InputStream is = definputFile.openStream();
                while ((data = is.read()) != -1) {
                    fos.write(data);
                }
                fos.close();
                is.close();
            }
            catch (IOException ioe) {
                this.logger.error((Object)"failed to create default file_names.data!");
            }
        } else if (this.initFileCombo.getSelectedIndex() == 0 && this.templatePath != null && this.templatePath.trim().length() != 0) {
            String nfinpPath = String.valueOf(baseDir) + this.FS + this.nfinp;
            try {
                ExternalProgramExecuter.copy(this.templatePath, nfinpPath);
            }
            catch (IOException ioe) {
                this.logger.warn((Object)("couldn't copy template file " + this.templatePath));
            }
        }
        if ((foo = this.projectInfo.getChaseFileManager()) == null) {
            this.logger.error((Object)"invalid filemanager...");
            return;
        }
        ChaseFile cf = this.projectInfo.getChaseFileManager().getFile("F_INP");
        if (cf == null) {
            this.logger.error((Object)"F_INP is null...");
            return;
        }
        cf.update("filename", this.nfinp);
        this.projectInfo.getChaseFileManager().save();
        this.logger.debug((Object)"done initialization of F_INP.");
    }

    private void initializeChaseXML(String baseDir) {
        URL defchaseXML = this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/phase-viewer.xml");
        Document doc = XMLUtils.getDocumentFromURL(defchaseXML);
        String projchaseXML = String.valueOf(this.projectInfo.getProjectDirectory()) + this.FS + "phase-viewer.xml";
        XMLUtils.saveDocumentTo(doc, new File(projchaseXML));
    }

    @Override
    public void stateChanged(InputWizardEvent ev) {
        if (ev.getState() == InputWizardEvent.FINISHED) {
            String baseDir = this.projectInfo.getProjectDirectory();
            this.initializeInputData(baseDir);
            this.node.selectMe();
            this.parent.init();
            this.logger.debug((Object)(this.projectInfo + " " + this.projectInfo.getParent()));
            this.controller.cleanUp();
        } else if (ev.getState() == InputWizardEvent.TO_NEXT) {
            this.initializeInputData(this.projectInfo.getProjectDirectory());
        } else if (ev.getState() == InputWizardEvent.CANCELED || ev.getState() == InputWizardEvent.CANCELED_ERR || ev.getState() == InputWizardEvent.FINISHED_ERR) {
            ProjectBrowserUtils.remove(this.node);
        }
    }

    class IniWiz
    implements InputWizardRoot {
        private InputWizardController controller;
        private Input input;
        private final Document rootWizDoc = XMLUtils.getDocumentFromURL(PhaseInitializer.class.getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/inputwizard/InputWizardRoot.xml"));
        private JPanel panel;
        private boolean hasNext = true;
        private boolean hasFin = false;

        IniWiz() {
            this.initializeRootCombo();
        }

        @Override
        public void setParent(InputWizardController controller) {
            this.controller = controller;
        }

        @Override
        public void setProperties(HashMap properties) {
        }

        @Override
        public void setInput(Input input) {
            this.input = input;
        }

        @Override
        public String process() {
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public boolean hasFinished() {
            return this.hasFin;
        }

        @Override
        public Document getSpecDocument() {
            Element root = this.rootWizDoc.getRootElement();
            List roots = root.getChildren("root");
            int i = 0;
            while (i < roots.size()) {
                Element ele = (Element)roots.get(i);
                if (PhaseInitializer.this.typeCombo.getSelectedItem().equals(ele.getChildTextTrim("name"))) {
                    Document ret = XMLUtils.getDocumentFromURL(PhaseInitializer.class.getResource(ele.getChildTextTrim("specfile")));
                    return ret;
                }
                ++i;
            }
            return null;
        }

        @Override
        public String getName() {
            return "initial input";
        }

        @Override
        public JPanel getGUI() {
            this.createPanel();
            return this.panel;
        }

        private void update() {
            this.controller.updateButtons(this);
        }

        private void initializeRootCombo() {
            Element root = this.rootWizDoc.getRootElement();
            List list = root.getChildren("root");
            Vector<String> names = new Vector<String>();
            int i = 0;
            while (i < list.size()) {
                names.addElement(((Element)list.get(i)).getChildTextTrim("name"));
                ++i;
            }
            PhaseInitializer.this.typeCombo = new JComboBox(names);
            PhaseInitializer.this.typeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    IniWiz.this.controller.resetWizards();
                }
            });
            PhaseInitializer.this.typeCombo.setEnabled(false);
        }

        private void createPanel() {
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            JPanel typePanel = new JPanel();
            typePanel.setLayout(new BorderLayout());
            typePanel.setBorder(new TitledBorder("wizard type"));
            typePanel.add((Component)PhaseInitializer.this.typeCombo, "West");
            this.panel.add((Component)typePanel, "South");
            PhaseInitializer.this.iniFileName = new JTextField(10);
            PhaseInitializer.this.iniFileName.setText("nfinp.data");
            JPanel iniName = new JPanel();
            iniName.setBorder(new TitledBorder("file name"));
            iniName.add(PhaseInitializer.this.iniFileName);
            PhaseInitializer.this.initFileCombo = new JComboBox<String>(PhaseInitializer.this.initFileChoice);
            JPanel tmp = new JPanel();
            tmp.add(PhaseInitializer.this.initFileCombo);
            JPanel initPanel = new JPanel();
            initPanel.setBorder(new TitledBorder("initial input file"));
            initPanel.setLayout(new BoxLayout(initPanel, 1));
            JPanel tmpco = new JPanel();
            tmpco.setLayout(new BoxLayout(tmpco, 0));
            tmpco.add(tmp);
            JPanel psele = new JPanel();
            PhaseInitializer.this.selector = new PathSelector("", 20, 0);
            psele.add(PhaseInitializer.this.selector);
            tmpco.add(psele);
            initPanel.add(tmpco);
            this.panel.add((Component)initPanel, "North");
            PhaseInitializer.this.initFileCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean tmpb = false;
                    if (PhaseInitializer.this.initFileCombo.getSelectedIndex() == 0) {
                        tmpb = true;
                        IniWiz.this.hasNext = false;
                        IniWiz.this.hasFin = new File(PhaseInitializer.this.selector.getRawPath()).exists();
                        PhaseInitializer.this.typeCombo.setEnabled(false);
                    } else if (PhaseInitializer.this.initFileCombo.getSelectedIndex() == 1) {
                        tmpb = false;
                        IniWiz.this.hasNext = true;
                        IniWiz.this.hasFin = false;
                        PhaseInitializer.this.typeCombo.setEnabled(true);
                    } else {
                        tmpb = false;
                        IniWiz.this.hasNext = false;
                        IniWiz.this.hasFin = true;
                        PhaseInitializer.this.typeCombo.setEnabled(false);
                    }
                    PhaseInitializer.this.selector.setEnabled(tmpb);
                    IniWiz.this.update();
                }
            });
            PhaseInitializer.this.selector.getTextField().addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (PhaseInitializer.this.initFileCombo.getSelectedIndex() != 0) {
                        return;
                    }
                    if (new File(PhaseInitializer.this.selector.getRawPath()).exists()) {
                        IniWiz.this.hasFin = true;
                    } else {
                        IniWiz.this.hasFin = false;
                    }
                    IniWiz.this.update();
                }
            });
            PhaseInitializer.this.initFileCombo.setSelectedIndex(0);
        }

        @Override
        public String getDescription() {
            return "specify calculation type & input file creation method";
        }

        public void stateChanged(InputWizardEvent ev) {
            ev.getState();
        }

        @Override
        public int getNumWizards() {
            if (PhaseInitializer.this.initFileCombo.getSelectedIndex() == 1) {
                return -1;
            }
            return 1;
        }
    }
}

