/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.scripting.scriptreplace.ScriptReplaceRules;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class EkCalScriptReplaceRules
extends ScriptReplaceRules {
    private Logger logger = Logger.getLogger((String)EkCalScriptReplaceRules.class.getName());
    private final String __EKCALL__ = "__EKCAL__";
    private String[] keys = new String[]{"__EKCAL__"};

    @Override
    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public String replace(String file, Document document, boolean overwrite2) {
        if (document == null || !document.hasRootElement()) {
            this.logger.error((Object)"invalid document");
            return null;
        }
        Element jobcontrol = document.getRootElement().getChild(JobController.JOBCONTROL);
        if (jobcontrol == null) {
            this.logger.error((Object)"invalid jobcontrol element");
            return null;
        }
        Element targethost = jobcontrol.getChild("targethost");
        if (targethost == null) {
            this.logger.error((Object)"invalid 'targethost' element");
            return null;
        }
        Element env = targethost.getChild("env");
        if (env == null) {
            this.logger.error((Object)"invalid 'env' element");
            return null;
        }
        String[] keys = this.getKeys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (key.equals("__EKCAL__")) {
                String bindir = MyElement.decode(env.getChildTextTrim("bindir"));
                String ekcal = String.valueOf(bindir) + "/ekcal";
                if (bindir == null || bindir.trim().length() == 0) {
                    ekcal = "ekcal";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    ekcal = String.valueOf(Utils.escapeBackSlash(bindir)) + "\\\\" + "ekcal.exe";
                    if (bindir == null || bindir.trim().length() == 0) {
                        ekcal = "ekcal.exe";
                    }
                }
                file = file.replaceAll(key, ekcal);
            }
            ++i;
        }
        if (!targethost.getTextTrim().equals("localhost") || !System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            file = file.replaceAll("\\r", "");
        }
        return file;
    }

    @Override
    public String replace(String script, Document document) {
        return this.replace(script, document, false);
    }
}

