/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class PPViewer
extends ProjectManipulator
implements ListSelectionListener {
    private Logger logger = Logger.getLogger((String)PPViewer.class.getName());
    private String ppdir = Utils.getDefaultPPDir();
    private File ppprops = new File(String.valueOf(this.ppdir) + System.getProperty("file.separator") + "pseudopotspec.data");
    private PPData[] dat;
    private JPanel panelProps;
    private JList list;
    private JLabel label;

    public PPViewer(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.createPPProps();
        if (this.dat == null) {
            this.add(new NoFilePanel("F_POT"));
            return;
        }
        JPanel plist = new JPanel();
        plist.setBorder(new TitledBorder("pp filename"));
        plist.setLayout(new BoxLayout(plist, 1));
        String[] fname = new String[this.dat.length];
        int i = 0;
        while (i < fname.length) {
            fname[i] = this.dat[i].fileName;
            ++i;
        }
        this.list = new JList<String>(fname);
        JScrollPane pane = new JScrollPane(this.list);
        plist.add(pane);
        this.add(plist);
        this.panelProps = new JPanel();
        this.panelProps.setBorder(new TitledBorder("properties"));
        this.label = new JLabel("");
        this.panelProps.add(this.label);
        this.add(this.panelProps);
        JButton btn = new JButton("close");
        JPanel p = new JPanel();
        p.add(btn);
        this.add(p);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PPViewer.this.projectInfo.getParent().dispose();
            }
        });
        this.list.addListSelectionListener(this);
        this.list.setSelectedIndex(0);
    }

    /*
     * Unable to fully structure code
     */
    private void createPPProps() {
        files = new File(this.ppdir).listFiles();
        pps = new Vector<PPData>();
        if (files == null || files.length == 0) {
            this.logger.error((Object)"ppdir is empty!");
            return;
        }
        info = ElementInfo.getElementInfo();
        i = 0;
        while (i < files.length) {
            block32: {
                block33: {
                    block31: {
                        reader = null;
                        reader = new BufferedReader(new FileReader(files[i]));
                        line = "";
                        while ((line = reader.readLine()) != null) {
                            if (!(line = line.trim()).startsWith("#")) break;
                        }
                        if ((array = line.split("\\s+")) != null && array.length >= 5) break block31;
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block32;
                        }
                        catch (Exception var18_20) {}
                        break block32;
                    }
                    fname = files[i].getName();
                    atomicNumber = -1;
                    ppc = -1;
                    val = -1;
                    try {
                        atomicNumber = Integer.parseInt(array[0]);
                        ppc = Integer.parseInt(array[3]);
                        val = Integer.parseInt(array[1]);
                    }
                    catch (Exception exc) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block32;
                        }
                        catch (Exception var18_21) {}
                        break block32;
                    }
                    if (atomicNumber >= 0 && ppc >= 0) break block33;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block32;
                    }
                    catch (Exception var18_22) {}
                    break block32;
                }
                try {
                    try {
                        elemName = info.getSymbolFromNumber(atomicNumber);
                        foo = fname.split("_");
                        if ((elemName == null || elemName.trim().length() == 0) && foo != null && foo.length != 0) {
                            elemName = foo[0];
                        }
                        type = "";
                        if (foo != null && foo.length >= 3) {
                            type = foo[2];
                        }
                        xctype = reader.readLine().trim().split("\\s+")[0];
                        data = new PPData(fname, elemName, atomicNumber, val, type, xctype, ppc);
                        pps.addElement(data);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        try {
                            if (reader == null) ** GOTO lbl89
                            reader.close();
                        }
                        catch (Exception var18_23) {}
                    }
                }
                catch (Throwable var17_26) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception var18_24) {
                        // empty catch block
                    }
                    throw var17_26;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception var18_25) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.dat = new PPData[pps.size()];
        pps.copyInto(this.dat);
        Arrays.sort(this.dat);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int i = this.list.getSelectedIndex();
        PPData da = this.dat[i];
        String ppc = "on";
        if (da.ppc != 1) {
            ppc = "off";
        }
        String newText = "element: " + da.elementName + " atomic number: " + String.valueOf(da.atomicNumber) + " number of valence electrons: " + String.valueOf(da.valence) + " ppc: " + ppc + " xctype: " + da.xctype + " type: " + da.type;
        this.label.setText(newText);
        this.revalidate();
    }

    class PPData
    implements Comparable {
        String fileName;
        String elementName;
        int atomicNumber;
        int valence;
        String xctype;
        String type;
        int ppc;

        PPData(String fileName, String elementName, int atomicNumber, int valence, String type, String xctype, int ppc) {
            this.fileName = fileName;
            this.elementName = elementName;
            this.atomicNumber = atomicNumber;
            this.valence = valence;
            this.type = type;
            this.xctype = xctype;
            this.ppc = ppc;
        }

        PPData(String longString) {
            String[] array = longString.split(",");
            try {
                this.fileName = array[0].split("=")[1];
                this.atomicNumber = Integer.parseInt(array[1].split("=")[1]);
                this.valence = Integer.parseInt(array[2].split("=")[1]);
                this.elementName = array[3].split("=")[1];
                this.type = array[4].split("=")[1];
                this.xctype = array[5].split("=")[1];
                String foo = array[6].split("=")[1];
                this.ppc = foo.equals("on") ? 1 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int compareTo(Object o) {
            PPData from = (PPData)o;
            if (from.atomicNumber != this.atomicNumber) {
                return this.atomicNumber - from.atomicNumber;
            }
            return this.fileName.compareTo(from.fileName);
        }

        public String toString() {
            String ret = "fileName=" + this.fileName;
            ret = String.valueOf(ret) + ",atomicNumber=" + String.valueOf(this.atomicNumber);
            ret = String.valueOf(ret) + ",valence=" + String.valueOf(this.valence);
            ret = String.valueOf(ret) + ",element=" + this.elementName;
            ret = String.valueOf(ret) + ",type=" + this.type;
            ret = String.valueOf(ret) + ",xctype=" + this.xctype;
            ret = this.ppc == 1 ? String.valueOf(ret) + ",ppc=on" : String.valueOf(ret) + ",ppc=off";
            return ret;
        }
    }
}

