/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.ProjectManipulatorBase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.EpsilonInitializer;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.UvsorEpsilonFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout.EffectiveMass;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout.StaticTensor;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout.StdoutGeneral;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.scripting.ScriptWrapper;
import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;

public class EpsilonManipulator
extends ProjectManipulatorBase {
    private Logger logger = Logger.getLogger((String)EpsilonManipulator.class.getName());
    private String scriptDir = String.valueOf(baseScriptDir) + "uvsor-epsilon";
    private URL phaseSpec = PhaseConstants.FILEINFO_PHASE;
    private ChaseFileManager cfManager;

    public EpsilonManipulator(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    protected URL getSubSelectorURL() {
        return this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/uvsorepsilon/manipulator_sub_selector_properties.xml");
    }

    @Override
    protected URL getProgramDescriptionURL() {
        return this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/uvsorepsilon/intropanel/uvsor.htm");
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void initializeProject(ProjectDirBrowserNode node) {
        EpsilonInitializer initializer = new EpsilonInitializer(this.projectInfo, this, node);
    }

    @Override
    public boolean createDefaultScript() {
        ScriptWrapper[] defaults = this.getDefaultScripts();
        int i = 0;
        while (i < defaults.length) {
            if (!new File(defaults[i].getPath()).exists()) {
                String name = new File(defaults[i].getPath()).getName();
                try {
                    ExternalProgramExecuter.copy(String.valueOf(this.scriptDir) + System.getProperty("file.separator") + name, defaults[i].getPath());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public ScriptWrapper[] getDefaultScripts() {
        ScriptWrapper[] defaults = new ScriptWrapper[REGISTERED_SCRIPT_TYPE.length];
        String prefix = "submit.";
        String FS = System.getProperty("file.separator");
        int i = 0;
        while (i < REGISTERED_SCRIPT_TYPE.length) {
            defaults[i] = new ScriptWrapper(String.valueOf(this.baseDir) + FS + prefix + REGISTERED_SCRIPT_TYPE[i], REGISTERED_SCRIPT_TYPE[i]);
            ++i;
        }
        return defaults;
    }

    @Override
    protected ChaseFileManager getChaseFileManager() {
        File fnamesData = new File(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "file_names.data");
        if (this.cfManager == null) {
            this.cfManager = new UvsorEpsilonFileManager(this.phaseSpec, fnamesData);
        }
        this.cfManager.setFileSpecFile(fnamesData);
        return this.cfManager;
    }

    @Override
    protected String getType() {
        this.getChaseFileManager();
        return this.cfManager.getName();
    }

    @Override
    protected Class[] getStdoutGUIs() {
        return new Class[]{StdoutGeneral.class, StaticTensor.class, EffectiveMass.class};
    }
}

