/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jobcontrol.ReportGenerator;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import org.apache.log4j.Logger;

public abstract class BasicReportGenerator
implements ReportGenerator {
    private Logger logger = Logger.getLogger((String)BasicReportGenerator.class.getName());
    protected String jobstatusIdent = "jobstatus\\d+";
    protected String stdoutIdent = "output\\d+";
    protected File mostRecentJobStatFile;
    protected File mostRecentStdOutFile;
    protected String parentDir;

    @Override
    public String generateReport(String parentDir) {
        String ret;
        block22: {
            this.parentDir = parentDir;
            File parentDirFile = new File(parentDir);
            if (!parentDirFile.isDirectory()) {
                return String.valueOf(parentDir) + " is not a directory.";
            }
            File[] files = parentDirFile.listFiles();
            if (files == null || files.length == 0) {
                return "no files found under " + parentDir;
            }
            this.mostRecentJobStatFile = null;
            this.mostRecentStdOutFile = null;
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().matches(this.jobstatusIdent) && (this.mostRecentJobStatFile == null || this.mostRecentJobStatFile.lastModified() < files[i].lastModified())) {
                    this.mostRecentJobStatFile = files[i];
                }
                if (files[i].getName().matches(this.stdoutIdent) && (this.mostRecentStdOutFile == null || this.mostRecentStdOutFile.lastModified() < files[i].lastModified())) {
                    this.mostRecentStdOutFile = files[i];
                }
                ++i;
            }
            ret = "date : " + Calendar.getInstance().getTime().toString() + "\n";
            try {
                ret = String.valueOf(ret) + "\n";
                InetAddress host = InetAddress.getLocalHost();
                ret = String.valueOf(ret) + "ran on host : " + host.getHostName() + "\n";
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ret = String.valueOf(ret) + "\n";
            ret = String.valueOf(ret) + "working directory : " + parentDir + "\n";
            if (this.mostRecentJobStatFile == null) {
                ret = String.valueOf(ret) + "\n";
                ret = String.valueOf(ret) + "could not find jobstatus file.\n";
            } else {
                ret = String.valueOf(ret) + "\n";
                ret = String.valueOf(ret) + "jobstatus file : " + this.mostRecentJobStatFile.getName() + "\n";
                BufferedReader reader = Utils.getReader(this.mostRecentJobStatFile.getAbsolutePath());
                try {
                    try {
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            ret = String.valueOf(ret) + line + "\n";
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        try {
                            reader.close();
                        }
                        catch (IOException ioe2) {
                            ioe2.printStackTrace();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        ret = String.valueOf(ret) + "\n";
        String aa = this.getOthers();
        if (aa != null) {
            ret = String.valueOf(ret) + aa;
        }
        return ret;
    }

    protected abstract String getOthers();

    public static String getReportGeneratorPath(ProjectInfo projectInfo) {
        String reportGeneratorPath = "ciss.phase_viewer.plugins.projectmanipulator.phase.jobcontrolpanel.PhaseReportGenerator";
        if (projectInfo.getProjectType().equals("ekcal")) {
            reportGeneratorPath = "ciss.phase_viewer.plugins.projectmanipulator.ekcal.jobcontrolpanel.EkcalReportGenerator";
        } else if (projectInfo.getProjectType().equals("uvsor-epsilon")) {
            reportGeneratorPath = "ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.jobcontrolpanel.UvsorEpsilonReportGenerator";
        }
        return reportGeneratorPath;
    }
}

