/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.graph.plotattributes;

import ciss.phase_viewer.common.FontChooser;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class GeneralAttributes
extends PlotAttributesSubEditor {
    private Logger logger = Logger.getLogger((String)GeneralAttributes.class.getName());
    private JCheckBox cbplottitle;
    private JTextField taplottitle;
    private JButton btntitlefont;
    private JCheckBox cblegend;
    private JComboBox cmboxlegend;
    private JTextField talegend;
    private JComboBox comboanchor;
    private JButton btnlegendfont;
    private XYPlot xyplot;
    private PiePlot pieplot;
    private JCheckBox cbantialias;
    private JPanel thispanel;
    private String[] range;
    private String[] stranchorpos = new String[]{"bottom", "top", "right", "left"};

    public GeneralAttributes(PlotAttributesEditor parent) {
        super(parent);
        this.thispanel = this;
    }

    @Override
    public boolean updateChart() {
        this.logger.debug((Object)"updating chart!");
        JFreeChart chart = this.parent.getGraphPanel().getChart();
        chart.setAntiAlias(this.cbantialias.isSelected());
        String title = "";
        if (this.cbplottitle.isSelected()) {
            title = this.taplottitle.getText();
            chart.getTitle().setFont(this.btntitlefont.getFont());
        } else {
            title = "";
        }
        chart.getTitle().setText(title);
        XYPlot lsource = null;
        if (this.xyplot != null) {
            int dsetCount = this.xyplot.getDatasetCount();
            int count = 0;
            int i = 0;
            while (i < dsetCount) {
                XYSeriesCollection collection = (XYSeriesCollection)this.xyplot.getDataset(i);
                int scount = collection.getSeriesCount();
                int j = 0;
                while (j < scount) {
                    collection.getSeries(j).setKey((Comparable)((Object)this.range[count]));
                    ++count;
                    ++j;
                }
                ++i;
            }
            lsource = this.xyplot;
        } else if (this.pieplot != null) {
            DefaultPieDataset old = (DefaultPieDataset)this.pieplot.getDataset();
            Number[] values = new Number[this.range.length];
            int i = 0;
            while (i < this.range.length) {
                values[i] = old.getValue(i);
                ++i;
            }
            DefaultPieDataset data = new DefaultPieDataset();
            int i2 = 0;
            while (i2 < this.range.length) {
                data.setValue((Comparable)((Object)this.range[i2]), values[i2]);
                ++i2;
            }
            this.pieplot.setDataset((PieDataset)data);
            lsource = this.pieplot;
        }
        boolean blegend = this.cblegend.isSelected();
        chart.removeLegend();
        if (blegend) {
            LegendTitle ltitle = new LegendTitle((LegendItemSource)lsource);
            String legendanchor = this.comboanchor.getSelectedItem().toString();
            if (legendanchor.equals(this.stranchorpos[0])) {
                ltitle.setPosition(RectangleEdge.BOTTOM);
            } else if (legendanchor.equals(this.stranchorpos[1])) {
                ltitle.setPosition(RectangleEdge.TOP);
            } else if (legendanchor.equals(this.stranchorpos[2])) {
                ltitle.setPosition(RectangleEdge.RIGHT);
            } else if (legendanchor.equals(this.stranchorpos[3])) {
                ltitle.setPosition(RectangleEdge.LEFT);
            }
            chart.addLegend(ltitle);
        }
        return true;
    }

    @Override
    public void init() {
        if (this.parent == null) {
            this.logger.debug((Object)"'parent' is null.");
            return;
        }
        Plot plot = this.parent.getSelectedPlot();
        if (plot == null) {
            this.logger.debug((Object)"'plot' is null.");
            return;
        }
        if (plot instanceof XYPlot) {
            this.xyplot = (XYPlot)plot;
        } else if (plot instanceof PiePlot) {
            this.pieplot = (PiePlot)plot;
        } else {
            return;
        }
    }

    @Override
    protected void initGUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        JPanel ptitle = new JPanel();
        ptitle.setLayout(new BoxLayout(ptitle, 0));
        String title = this.parent.getGraphPanel().getChart().getTitle().getText();
        boolean titleEnabled = true;
        if (title == null || title.trim().length() == 0) {
            titleEnabled = false;
        }
        this.cbplottitle = new JCheckBox("show title");
        this.cbplottitle.setSelected(titleEnabled);
        this.taplottitle = new JTextField(25);
        this.btntitlefont = new JButton("select font");
        if (titleEnabled) {
            this.taplottitle.setText(title);
            this.btntitlefont.setFont(this.parent.getGraphPanel().getChart().getTitle().getFont());
        }
        ptitle.add(this.cbplottitle);
        ptitle.add(this.taplottitle);
        ptitle.add(this.btntitlefont);
        ptitle.setBorder(new TitledBorder("title"));
        p.add((Component)ptitle, constraints);
        JPanel plegend = new JPanel();
        plegend.setLayout(new GridLayout(1, 5));
        this.cblegend = new JCheckBox("show legend");
        Vector<String> rangeVector = new Vector<String>();
        if (this.xyplot != null) {
            int dsetCount = this.xyplot.getDatasetCount();
            int i = 0;
            while (i < dsetCount) {
                XYSeriesCollection collection = (XYSeriesCollection)this.xyplot.getDataset(i);
                int scount = collection.getSeriesCount();
                int j = 0;
                while (j < scount) {
                    rangeVector.addElement(collection.getSeries(j).getKey().toString());
                    ++j;
                }
                ++i;
            }
        } else if (this.pieplot != null) {
            DefaultPieDataset data = (DefaultPieDataset)this.pieplot.getDataset();
            List keys = data.getKeys();
            int i = 0;
            while (i < keys.size()) {
                rangeVector.addElement((String)keys.get(i));
                ++i;
            }
        }
        if (rangeVector.size() != 0) {
            this.range = new String[rangeVector.size()];
            rangeVector.copyInto(this.range);
        } else {
            this.logger.error((Object)"could not obtain series!");
        }
        if (this.range != null) {
            this.cmboxlegend = new JComboBox<String>(this.range);
            this.talegend = new JTextField(13);
            this.talegend.setText(this.cmboxlegend.getItemAt(0).toString());
        } else {
            this.cmboxlegend = new JComboBox();
            this.talegend = new JTextField(13);
        }
        JPanel panchor = new JPanel();
        this.comboanchor = new JComboBox<String>(this.stranchorpos);
        panchor.setBorder(new TitledBorder("anchor position"));
        panchor.add(this.comboanchor);
        this.btnlegendfont = new JButton("select font");
        plegend.add(this.cblegend);
        plegend.add(this.cmboxlegend);
        plegend.add(this.talegend);
        plegend.add(this.comboanchor);
        plegend.add(this.btnlegendfont);
        plegend.setBorder(new TitledBorder("legend"));
        constraints.gridy = 1;
        p.add((Component)plegend, constraints);
        JPanel panti = new JPanel();
        panti.setLayout(new BoxLayout(panti, 0));
        panti.setBorder(new TitledBorder("anti-aliasing"));
        this.cbantialias = new JCheckBox("enable anti-aliasing");
        this.cbantialias.setSelected(this.parent.getGraphPanel().getChart().getAntiAlias());
        panti.add(this.cbantialias);
        constraints.gridy = 2;
        p.add((Component)panti, constraints);
        this.cmboxlegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralAttributes.this.talegend.setText(GeneralAttributes.this.range[GeneralAttributes.this.cmboxlegend.getSelectedIndex()]);
            }
        });
        this.talegend.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                ((GeneralAttributes)GeneralAttributes.this).range[((GeneralAttributes)GeneralAttributes.this).cmboxlegend.getSelectedIndex()] = GeneralAttributes.this.talegend.getText().trim();
            }
        });
        this.btntitlefont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = FontChooser.chooseFont(GeneralAttributes.this.btntitlefont.getFont(), GeneralAttributes.this.thispanel);
                GeneralAttributes.this.btntitlefont.setFont(font);
            }
        });
        this.btnlegendfont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = FontChooser.chooseFont(GeneralAttributes.this.btnlegendfont.getFont(), GeneralAttributes.this.thispanel);
                GeneralAttributes.this.btnlegendfont.setFont(font);
            }
        });
        this.add((Component)p, "North");
    }

    @Override
    public void plotChanged(Plot plot) {
        this.updateChart();
        this.init();
        this.initGUI();
        this.revalidate();
    }
}

