/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.graph.plotattributes;

import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jfree.chart.plot.Plot;

public class BGColorAttributes
extends PlotAttributesSubEditor {
    private Logger logger = Logger.getLogger((String)BGColorAttributes.class.getName());
    private JPanel thispanel = this;
    private Plot plot;
    private JButton btnchartcolor;
    private JButton btnplotcolor;

    public BGColorAttributes(PlotAttributesEditor parent) {
        super(parent);
    }

    @Override
    protected void init() {
        if (this.parent == null) {
            this.logger.debug((Object)"'parent' is null.");
            return;
        }
        this.plot = this.parent.getSelectedPlot();
        this.logger.debug((Object)("plot here: " + this.plot));
        if (this.plot == null) {
            this.logger.debug((Object)"'plot' is null.");
            return;
        }
    }

    @Override
    protected void initGUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        Color chartColor = (Color)this.getEditor().getGraphPanel().getChart().getBackgroundPaint();
        JPanel pbtncolor = new JPanel();
        if (this.plot == null) {
            this.logger.debug((Object)"plot is null.");
            return;
        }
        Color plotColor = (Color)this.plot.getBackgroundPaint();
        pbtncolor.setBorder(new TitledBorder("back ground color"));
        this.btnchartcolor = new JButton("select chart color");
        this.btnchartcolor.setBackground(chartColor);
        this.btnplotcolor = new JButton("select plot color");
        this.btnplotcolor.setBackground(plotColor);
        pbtncolor.add(this.btnchartcolor);
        pbtncolor.add(this.btnplotcolor);
        p.add((Component)pbtncolor, constraints);
        this.add((Component)p, "North");
        this.btnchartcolor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(BGColorAttributes.this.thispanel, "Choose", BGColorAttributes.this.btnchartcolor.getBackground());
                if (color != null) {
                    BGColorAttributes.this.btnchartcolor.setBackground(color);
                    BGColorAttributes.this.btnchartcolor.revalidate();
                }
            }
        });
        this.btnplotcolor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(BGColorAttributes.this.thispanel, "Choose", BGColorAttributes.this.btnplotcolor.getBackground());
                if (color != null) {
                    BGColorAttributes.this.btnplotcolor.setBackground(color);
                    BGColorAttributes.this.btnplotcolor.revalidate();
                }
            }
        });
    }

    @Override
    public boolean updateChart() {
        this.getEditor().getGraphPanel().getChart().setBackgroundPaint((Paint)this.btnchartcolor.getBackground());
        this.plot.setBackgroundPaint((Paint)this.btnplotcolor.getBackground());
        return true;
    }

    @Override
    public void plotChanged(Plot plot) {
        this.updateChart();
        this.init();
        this.initGUI();
        this.revalidate();
    }
}

