/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.fbz.edit;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.Kpoint;
import ciss.phase_viewer.acviewer.fbz.KpointGenerator;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointBG;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.acviewer.geom.BoundPlane;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class KpointMeshPanel
extends JPanel
implements KpointGenerator {
    private Logger logger = Logger.getLogger((String)KpointMeshPanel.class.getName());
    private FBZ fbz;
    private WignerSeitzCell wscell;
    private JTextField textn1;
    private JTextField textn2;
    private JTextField textn3;

    public KpointMeshPanel(J3DPanel basePanel) {
        this.fbz = (FBZ)basePanel;
        this.wscell = this.fbz.getFBZ();
        this.init();
    }

    private void init() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("mesh"));
        panel.setLayout(new BoxLayout(panel, 0));
        this.textn1 = new JTextField(8);
        this.textn2 = new JTextField(8);
        this.textn3 = new JTextField(8);
        this.textn1.setText("20");
        this.textn2.setText("20");
        this.textn3.setText("20");
        JPanel xpanel = new JPanel();
        xpanel.setBorder(new TitledBorder("n1"));
        xpanel.add(this.textn1);
        JPanel ypanel = new JPanel();
        ypanel.setBorder(new TitledBorder("n2"));
        ypanel.add(this.textn2);
        JPanel zpanel = new JPanel();
        zpanel.setBorder(new TitledBorder("n3"));
        zpanel.add(this.textn3);
        panel.add(xpanel);
        panel.add(ypanel);
        panel.add(zpanel);
        this.add(panel);
    }

    @Override
    public void saveInput(Kpoint[] kpoints, double deltak) {
    }

    @Override
    public void generateKpoints(Kpoint[] kpoints, double dk) {
        PrintWriter writer;
        Vector<Boolean> inbz;
        int n3h;
        int n2h;
        int n1h;
        Point3f[] lat;
        block41: {
            BoundPlane[] planes;
            int n1 = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                n1 = Integer.parseInt(this.textn1.getText().trim());
                n2 = Integer.parseInt(this.textn2.getText().trim());
                n3 = Integer.parseInt(this.textn3.getText().trim());
            }
            catch (Exception exc) {
                this.logger.error((Object)"invalid values");
                return;
            }
            float[][] recvec = this.fbz.getReciprocalLatticeVector();
            lat = new Point3f[]{new Point3f(recvec[0]), new Point3f(recvec[1]), new Point3f(recvec[2])};
            n1h = n1;
            n2h = n2;
            n3h = n3;
            float delta1 = 1.0f / (float)n1h;
            float delta2 = 1.0f / (float)n2h;
            float delta3 = 1.0f / (float)n3h;
            float de1 = recvec[0][0] * delta1 + recvec[1][0] * delta2 + recvec[2][0] * delta3;
            float de2 = recvec[0][1] * delta1 + recvec[1][1] * delta2 + recvec[2][1] * delta3;
            float de3 = recvec[0][2] * delta1 + recvec[1][2] * delta2 + recvec[2][2] * delta3;
            float ratio1 = de1 / (float)Math.sqrt(recvec[0][0] * recvec[0][0] + recvec[1][0] * recvec[1][0] + recvec[2][0] * recvec[2][0]);
            float ratio2 = de2 / (float)Math.sqrt(recvec[0][1] * recvec[0][1] + recvec[1][1] * recvec[1][1] + recvec[2][1] * recvec[2][1]);
            float ratio3 = de3 / (float)Math.sqrt(recvec[0][2] * recvec[0][2] + recvec[1][2] * recvec[1][2] + recvec[2][2] * recvec[2][2]);
            float rat = ratio1;
            if (ratio2 > rat) {
                rat = ratio2;
            }
            if (ratio3 > rat) {
                rat = ratio3;
            }
            if ((planes = this.wscell.getPlanes()) == null) {
                this.logger.error((Object)"invalid planes!!!");
                return;
            }
            BoundPlane[] biggerPlane = new BoundPlane[planes.length];
            Point3f orig = new Point3f();
            float bigger = 1.1f;
            this.logger.debug((Object)("plane enlargement factor: " + bigger));
            int i = 0;
            while (i < biggerPlane.length) {
                float d = planes[i].getDistanceFrom(orig);
                biggerPlane[i] = new BoundPlane();
                biggerPlane[i].setVertices(planes[i].getVertices());
                biggerPlane[i].setNormalVector(planes[i].getNormalVector());
                Point3f origorig = planes[i].getOrigin();
                Point3f neworig = new Point3f();
                neworig.x = origorig.x * bigger;
                neworig.y = origorig.y * bigger;
                neworig.z = origorig.z * bigger;
                biggerPlane[i].setOrigin(neworig);
                ++i;
            }
            WignerSeitzAttributes wsattrs = new WignerSeitzAttributes();
            Vector<String> points = new Vector<String>();
            inbz = new Vector<Boolean>();
            int i2 = -n3h;
            while (i2 <= n3h) {
                int j = -n2h;
                while (j <= n2h) {
                    int k = -n1h;
                    while (k <= n1h) {
                        Point3f point = new Point3f();
                        point.x = recvec[0][0] * delta1 * (float)i2 + recvec[1][0] * delta2 * (float)j + recvec[2][0] * delta3 * (float)k;
                        point.y = recvec[0][1] * delta1 * (float)i2 + recvec[1][1] * delta2 * (float)j + recvec[2][1] * delta3 * (float)k;
                        point.z = recvec[0][2] * delta1 * (float)i2 + recvec[1][2] * delta2 * (float)j + recvec[2][2] * delta3 * (float)k;
                        int inplane = 0;
                        int l = 0;
                        while (l < biggerPlane.length) {
                            if (biggerPlane[l].getVertices().length <= 2) {
                                this.logger.error((Object)"invalid plane....");
                            } else {
                                float d1 = biggerPlane[l].getDistanceFrom(point);
                                float d2 = biggerPlane[l].getDistanceFrom(orig);
                                if (d1 <= 0.0f && d2 <= 0.0f || d1 >= 0.0f && d2 >= 0.0f) {
                                    ++inplane;
                                }
                            }
                            ++l;
                        }
                        if (inplane == biggerPlane.length) {
                            points.addElement(new Kpoint(new SymmetryPointBG(new Vector3f((Tuple3f)point), lat, wsattrs)).toString_bandkptpl());
                            inbz.addElement(new Boolean(true));
                        } else {
                            inbz.addElement(new Boolean(false));
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            String kpointfile = String.valueOf(this.fbz.getParentDirectory()) + System.getProperty("file.separator") + "kpoint.data";
            writer = null;
            try {
                try {
                    writer = new PrintWriter(new BufferedWriter(new FileWriter(kpointfile)));
                    writer.println(String.valueOf(String.valueOf(points.size())) + " " + String.valueOf(points.size()));
                    int i3 = 0;
                    while (i3 < points.size()) {
                        String str = (String)points.get(i3);
                        str = String.valueOf(str) + " 1";
                        writer.println(str);
                        ++i3;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    writer.flush();
                    try {
                        writer.close();
                    }
                    catch (Exception l) {}
                    break block41;
                }
            }
            catch (Throwable inplane) {
                writer.flush();
                try {
                    writer.close();
                }
                catch (Exception l) {
                    // empty catch block
                }
                throw inplane;
            }
            writer.flush();
            try {
                writer.close();
            }
            catch (Exception l) {
                // empty catch block
            }
        }
        String fsfile = String.valueOf(this.fbz.getParentDirectory()) + System.getProperty("file.separator") + "fs.data";
        float dlat1x = lat[0].x / (float)n1h;
        float dlat1y = lat[0].y / (float)n1h;
        float dlat1z = lat[0].z / (float)n1h;
        float dlat2x = lat[1].x / (float)n2h;
        float dlat2y = lat[1].y / (float)n2h;
        float dlat2z = lat[1].z / (float)n2h;
        float dlat3x = lat[2].x / (float)n3h;
        float dlat3y = lat[2].y / (float)n3h;
        float dlat3z = lat[2].z / (float)n3h;
        try {
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(fsfile)));
                writer.println(String.valueOf(String.valueOf(2 * n1h + 1)) + " " + dlat1x + " " + dlat1y + " " + dlat1z);
                writer.println(String.valueOf(String.valueOf(2 * n2h + 1)) + " " + dlat2x + " " + dlat2y + " " + dlat2z);
                writer.println(String.valueOf(String.valueOf(2 * n3h + 1)) + " " + dlat3x + " " + dlat3y + " " + dlat3z);
                int count = 0;
                int i = -n3h;
                while (i <= n3h) {
                    int j = -n2h;
                    while (j <= n2h) {
                        int k = -n1h;
                        while (k <= n1h) {
                            writer.println(String.valueOf(i) + " " + j + " " + k + " " + inbz.get(count));
                            ++count;
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                writer.flush();
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            writer.flush();
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Kpoint[] getKpointsFrom(String file) {
        return null;
    }
}

