/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.ChaseGUI;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class Chase {
    private static Logger logger = Logger.getLogger((String)Chase.class.getName());
    private static ChaseGUI gui;
    private final String FS = System.getProperty("file.separator");

    public Chase(boolean splash) {
        if (!this.checkInstallation()) {
            System.out.println("failed installation ... exiting program");
            System.exit(0);
        }
        gui = new ChaseGUI(splash);
    }

    public static ChaseGUI getGUI() {
        return gui;
    }

    public static void updateUI() {
        try {
            SwingUtilities.updateComponentTreeUI(gui);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setUI(String str) {
        try {
            UIManager.setLookAndFeel(str);
            Chase.updateUI();
        }
        catch (Exception exc) {
            logger.error((Object)("Error loading L&F: " + str));
            exc.printStackTrace();
        }
    }

    private boolean checkInstallation() {
        boolean ret = true;
        String chaseini = String.valueOf(System.getProperty("user.home")) + this.FS + ".phase-viewer";
        String chaseInstDir = String.valueOf(System.getProperty("pviewer.home")) + this.FS + "install" + this.FS + "install_files";
        File file = new File(chaseini);
        if (!file.exists()) {
            if (!file.mkdir()) {
                System.out.println("failed to create " + chaseini + " ... exiting program");
                System.exit(0);
            }
        } else if (!file.isDirectory()) {
            System.out.println(String.valueOf(chaseini) + " must be a directory ... exiting program");
            System.exit(0);
        }
        GlobalProperties gpini = PropertiesManager.getGlobalProperties(4);
        Enumeration<?> filenames = gpini.propertyNames();
        ret = Chase.generateDefaultDotChaseDir(false);
        return ret;
    }

    public static boolean generateDefaultDotChaseDir(boolean overwrite2) {
        boolean ret = true;
        String FS = System.getProperty("file.separator");
        String chaseini = String.valueOf(System.getProperty("user.home")) + FS + ".phase-viewer";
        String chaseInstDir = String.valueOf(System.getProperty("pviewer.home")) + FS + "install" + FS + "install_files";
        GlobalProperties gpini = PropertiesManager.getGlobalProperties(4);
        Enumeration<?> filenames = gpini.propertyNames();
        while (filenames.hasMoreElements()) {
            String ident = (String)filenames.nextElement();
            String value = gpini.getProperty(ident);
            File checkFile = new File(String.valueOf(chaseini) + FS + value);
            if (checkFile.exists() && !overwrite2) continue;
            try {
                File origFile = new File(String.valueOf(chaseInstDir) + FS + value);
                if (!origFile.isDirectory()) {
                    ExternalProgramExecuter.copy(String.valueOf(chaseInstDir) + FS + value, String.valueOf(chaseini) + FS + value);
                    logger.debug((Object)("copied " + chaseInstDir + FS + value + " to " + chaseini + FS + value));
                    continue;
                }
                Utils.copyDir(new File(String.valueOf(chaseInstDir) + FS + value), new File(chaseini));
                logger.debug((Object)("copied dir: " + value));
            }
            catch (Exception exc) {
                System.out.println("failed to copy " + chaseInstDir + FS + value);
                logger.error((Object)("failed to copy " + chaseInstDir + FS + value));
                return false;
            }
        }
        Vector<String> subprojs = ProjectBrowserUtils.getSupportedSubProjectTypes();
        for (String subproj : subprojs) {
            File jobscriptDir = new File(String.valueOf(chaseini) + FS + "scripts" + FS + "jobcontrol" + FS + subproj);
            if (jobscriptDir.exists()) continue;
            if (!jobscriptDir.mkdir()) {
                System.out.println("failed to create " + jobscriptDir + " ... exiting program");
                System.exit(0);
            }
            File fromDir = new File(String.valueOf(chaseInstDir) + FS + "scripts" + FS + "jobcontrol" + FS + subproj);
            File toDir = jobscriptDir.getParentFile();
            if (!fromDir.exists()) continue;
            Utils.copyDir(fromDir, toDir);
        }
        return ret;
    }
}

