/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.jdom;

import ciss.phase_viewer.jdom.MyElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtils {
    private static Logger logger = Logger.getLogger((String)XMLUtils.class.getName());

    private XMLUtils() {
    }

    public static Element getContent(Document doc, String ident) {
        List list = null;
        try {
            list = doc.getContent();
        }
        catch (IllegalStateException exc) {
            return null;
        }
        if (list == null || list.size() == 0) {
            Element host = new Element(ident);
            doc.addContent((Content)host);
            return host;
        }
        int i = 0;
        while (i < list.size()) {
            Element elem;
            Object obj = list.get(i);
            if (obj instanceof Element && (elem = (Element)obj).getName().equals(ident)) {
                return elem;
            }
            ++i;
        }
        Element host = new Element(ident);
        doc.addContent((Content)host);
        return host;
    }

    public static Document getDocumentFromURL(URL url) {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        if (url == null) {
            return null;
        }
        try {
            doc = builder.build(url);
        }
        catch (JDOMException jde) {
            logger.error((Object)("failed to parse " + url));
            logger.error((Object)"unrecoverable error.");
            jde.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            logger.error((Object)("failed to parse " + url));
            logger.error((Object)"unrecoverable error.");
            ioe.printStackTrace();
            return null;
        }
        return doc;
    }

    public static Document getDocumentFromFile(File file) {
        Document doc = null;
        if (file == null || !file.exists()) {
            return null;
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(file);
        }
        catch (Exception jde) {
            logger.error((Object)("failed to parse " + file));
            logger.error((Object)"unrecoverable error.");
            jde.printStackTrace();
            return null;
        }
        return doc;
    }

    public static void saveDocumentTo(Document doc, String file) {
        XMLUtils.saveDocumentTo(doc, new File(file));
    }

    public static void saveDocumentTo(Document doc, File file) {
        OutputStreamWriter writer = null;
        logger.debug((Object)("saving document to: " + file.getAbsolutePath()));
        if (file.exists() && !file.canWrite()) {
            return;
        }
        try {
            try {
                writer = new FileWriter(file);
                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                outputter.output(doc, (Writer)writer);
            }
            catch (IOException ioe) {
                logger.warn((Object)("cannot save to file " + file.getAbsolutePath()));
                try {
                    writer.close();
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
            }
            catch (NullPointerException nullPointerException) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static Element[] getElementsFromTableModel(TableModel model, String rowname) {
        int numrow = model.getRowCount();
        Element[] ret = new Element[numrow];
        if (model == null) {
            logger.error((Object)"'table model' is null.");
            return null;
        }
        int numcol = model.getColumnCount();
        int i = 0;
        while (i < numrow) {
            Element elemroot = new Element(rowname);
            int j = 0;
            while (j < numcol) {
                String colname = model.getColumnName(j);
                Element element = new Element(colname);
                Object obj = model.getValueAt(i, j);
                String sobj = "";
                if (obj instanceof String) {
                    sobj = (String)obj;
                } else if (obj instanceof Boolean) {
                    sobj = ((Boolean)obj).toString();
                }
                element.addContent(MyElement.encode(sobj));
                elemroot.addContent((Content)element);
                ++j;
            }
            ret[i] = elemroot;
            ++i;
        }
        return ret;
    }
}

