/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.dataset;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.graph.dataset.DataSet;
import ciss.phase_viewer.graph.dataset.DataSetCollection;
import ciss.phase_viewer.graph.dataset.DataSetElement;
import ciss.phase_viewer.graph.dataset.DataSetExporter;
import ciss.phase_viewer.graph.dataset.DataSetImporter;
import ciss.phase_viewer.graph.dataset.PlotProperties;
import ciss.phase_viewer.graph.dataset.PlotPropertiesEditor;
import ciss.phase_viewer.graph.dataset.SubPlotProperties;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DataSetManipulator
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)DataSetManipulator.class.getName());
    private DataSet[] dset;
    private PlotSelectionPanel plot;
    private DataSetManipulator manipulator;
    private PlotProperties props;
    private int initialDir;
    private DataSetBrowser browserX;
    private DataSetBrowser browserY;

    public DataSetManipulator() {
        super("data sets", true, true, true, true, new Dimension(700, 560));
        this.manipulator = this;
        this.init();
    }

    public DataSetManipulator(DataSet[] dset) {
        super("data sets", true, true, true, true, new Dimension(700, 560));
        this.dset = dset;
        this.manipulator = this;
        this.init();
    }

    private void init() {
        Container container = this.getContentPane();
        container.removeAll();
        this.props = new PlotProperties();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.browserX = new DataSetBrowser("domain", this.dset, 1);
        this.browserY = new DataSetBrowser("range", this.dset);
        JSplitPane splitpane = new JSplitPane(1, this.browserX, this.browserY);
        splitpane.setDividerLocation(0.5);
        splitpane.setResizeWeight(0.5);
        panel.add((Component)splitpane, "North");
        this.plot = new PlotSelectionPanel("plot");
        panel.add((Component)this.plot, "Center");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        JButton btnplot = new JButton("plot");
        btnpanel.add((Component)btnplot, gc);
        JButton btnimport = new JButton("import dataset");
        JButton btnexport = new JButton("export dataset");
        gc.gridx = 1;
        btnpanel.add(btnimport);
        gc.gridx = 2;
        btnpanel.add(btnexport);
        JButton btnclose = new JButton("close");
        gc.gridx = 3;
        gc.fill = 0;
        btnpanel.add((Component)btnclose, gc);
        panel.add((Component)btnpanel, "South");
        container.add(panel);
        btnplot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetManipulator.this.doPlot();
            }
        });
        btnexport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataSetManipulator.this.dset != null && DataSetManipulator.this.dset.length != 0) {
                    DataSetExporter dataSetExporter = new DataSetExporter(DataSetManipulator.this.dset);
                } else {
                    DataSetManipulator.this.logger.info((Object)"no data set to export");
                }
            }
        });
        btnimport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetManipulator.this.doImport();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetManipulator.this.dispose();
            }
        });
    }

    private void doImport() {
        ChaseFileChooser fdlg = new ChaseFileChooser(true);
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("select");
        fdlg.setFileSelectionMode(0);
        if (fdlg.showDialog(this, "open") != 0) {
            return;
        }
        String path = fdlg.getSelectedFile().getAbsolutePath();
        DataSetImporter dsi = new DataSetImporter(path);
        DataSet data = dsi.getDataSet();
        if (data == null) {
            this.logger.error((Object)"import failed.");
            return;
        }
        int newDsetLength = 1;
        if (this.dset != null) {
            newDsetLength = this.dset.length + 1;
        }
        DataSet[] newDataset = new DataSet[newDsetLength];
        if (this.dset != null) {
            int i = 0;
            while (i < this.dset.length) {
                newDataset[i] = this.dset[i];
                ++i;
            }
        }
        newDataset[newDsetLength - 1] = data;
        this.dset = newDataset;
        this.init();
    }

    private void doPlot() {
        Vector plotprops = new Vector();
        AxisSelectionPanel[] axisx = this.plot.getAxisX();
        AxisSelectionPanel[] axisy = this.plot.getAxisY();
        if (axisx == null || axisx.length == 0) {
            this.logger.error((Object)"no data.");
            return;
        }
        String dir = null;
        int i = 0;
        while (i < axisx.length) {
            int k;
            int j;
            DataSetElement[][] dxa = axisx[i].getDataSetElements();
            String[] axisxnames = axisx[i].getNames();
            DataSetElement[][] dy = axisy[i].getDataSetElements();
            String[] axisynames = axisy[i].getNames();
            DataSetElement dx = null;
            String axisxname = "";
            try {
                dx = dxa[0][0];
                dir = new File(dx.getParent().getFileName()).getParent();
                axisxname = axisxnames[0];
            }
            catch (NullPointerException npe) {
                this.logger.error((Object)"invalid data.");
                return;
            }
            this.props.setTitle(dx.getParent().getName());
            DataSetCollection coll = new DataSetCollection(this.plot.getPlotTitle(i));
            int count = axisynames.length;
            if (count > axisxnames.length) {
                j = 0;
                while (j < count) {
                    coll.setRangeAxisName(j, axisynames[j]);
                    coll.setDomainAxisName(j, axisxname);
                    coll.setDomain(j, dx);
                    k = 0;
                    while (k < dy[j].length) {
                        coll.addRange(j, dy[j][k]);
                        ++k;
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < axisxnames.length) {
                    coll.setRangeAxisName(j, axisynames[0]);
                    coll.setDomainAxisName(j, axisxnames[j]);
                    coll.setDomain(j, dxa[j][0]);
                    k = 0;
                    while (k < dy[0].length) {
                        coll.addRange(j, dy[0][k]);
                        ++k;
                    }
                    ++j;
                }
            }
            SubPlotProperties spp = this.props.getSubPlotPropertiesAt(i);
            spp.setDataSetCollection(coll);
            if (axisy[i].getAxisCount() >= 2) {
                spp.setMultipleAxisType(SubPlotProperties.MULTIPLE_AXIS_Y);
            } else if (axisx[i].getAxisCount() >= 2) {
                spp.setMultipleAxisType(SubPlotProperties.MULTIPLE_AXIS_X);
            }
            ++i;
        }
        GraphPanel gpanel = new GraphPanel(this.props.getTitle(), this.props, dir);
    }

    void changeAxisState(AxisSelectionPanel p, int numaxis) {
        boolean enable = false;
        if (numaxis <= 1) {
            enable = true;
        }
        if (p == this.browserX.getAxisPanel()) {
            this.browserY.getAxisPanel().enableAxisManipulation(enable);
        } else if (p == this.browserY.getAxisPanel()) {
            this.browserX.getAxisPanel().enableAxisManipulation(enable);
        }
    }

    class AxisSelectionPanel
    extends JPanel {
        private Logger logger = Logger.getLogger((String)AxisSelectionPanel.class.getName());
        public static final String AXIS_TYPE_DOMAIN = "domain";
        public static final String AXIS_TYPE_RANGE = "range";
        private String axisType;
        private JComboBox selector;
        private int selectionType = 0;
        private JList listofaxis;
        private DefaultListModel listModel;
        private JTextField newaxisTextField;
        private JPanel plistOfData = new JPanel();
        private Vector listOfData = new Vector();
        private String ID = "";
        private JButton button;
        private JButton buttonrem;

        public AxisSelectionPanel(String axisType, String ID) {
            this.axisType = axisType;
            this.ID = ID;
            this.selectionType = axisType.equals(AXIS_TYPE_RANGE) ? 2 : 0;
            this.init();
        }

        void enableAxisManipulation(boolean enable) {
            this.button.setEnabled(enable);
            this.buttonrem.setEnabled(enable);
            this.newaxisTextField.setEnabled(enable);
        }

        String getID() {
            return this.ID;
        }

        JList getList() {
            return this.listofaxis;
        }

        int getAxisCount() {
            return this.selector.getItemCount();
        }

        private void init() {
            this.setLayout(new BoxLayout(this, 1));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            this.selector = new JComboBox<String>(new String[]{String.valueOf(this.axisType) + "-axis"});
            this.plistOfData = new JPanel();
            this.plistOfData.setBorder(new TitledBorder("list of data"));
            this.plistOfData.setLayout(new BoxLayout(this.plistOfData, 0));
            ListOfData list = new ListOfData(this.selectionType);
            this.listOfData.addElement(list);
            this.listModel = new DefaultListModel();
            constraints.gridy = 1;
            this.plistOfData.add(list);
            this.add((Component)this.plistOfData, constraints);
            constraints.gridy = 2;
            JPanel newaxispanel = new JPanel();
            newaxispanel.setLayout(new BoxLayout(newaxispanel, 0));
            newaxispanel.setBorder(new TitledBorder("manipulate axis"));
            this.button = new JButton("create");
            this.buttonrem = new JButton("remove");
            this.newaxisTextField = new JTextField(10);
            newaxispanel.add(this.selector);
            newaxispanel.add(this.newaxisTextField);
            newaxispanel.add(this.button);
            newaxispanel.add(this.buttonrem);
            this.add((Component)newaxispanel, constraints);
            this.selector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisSelectionPanel.this.selectList();
                }
            });
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisSelectionPanel.this.createNewAxis();
                }
            });
            this.buttonrem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisSelectionPanel.this.removeSelectedAxis();
                }
            });
        }

        public DataSetElement[][] getDataSetElements() {
            Vector<DataSetElement[]> retVec = new Vector<DataSetElement[]>();
            int i = 0;
            while (i < this.selector.getItemCount()) {
                DataSetElement[] dse = ((ListOfData)this.listOfData.get(i)).getData();
                retVec.addElement(dse);
                ++i;
            }
            if (retVec.size() == 0) {
                return null;
            }
            DataSetElement[][] ret = new DataSetElement[retVec.size()][];
            retVec.copyInto((Object[])ret);
            return ret;
        }

        public String[] getNames() {
            String[] ret = new String[this.selector.getItemCount()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = this.selector.getItemAt(i).toString();
                ++i;
            }
            return ret;
        }

        public void addData(DataSetElement data) {
            ListOfData list = this.getSelectedList();
            list.addNewData(data);
        }

        public void removeSelectedData() {
            ListOfData list = this.getSelectedList();
            list.removeSelectedData();
        }

        public DataSetElement[] getData() {
            ListOfData list = this.getSelectedList();
            return list.getData();
        }

        private ListOfData getSelectedList() {
            int indx = this.selector.getSelectedIndex();
            if (indx >= this.listOfData.size() || indx < 0) {
                this.logger.error((Object)"something is wrong!");
                return null;
            }
            return (ListOfData)this.listOfData.get(indx);
        }

        private void selectList() {
            int indx = this.selector.getSelectedIndex();
            if (indx < 0 || indx > this.listOfData.size()) {
                return;
            }
            if (indx >= this.listOfData.size() - 1) {
                ListOfData listofdata = new ListOfData(this.selectionType);
                this.listOfData.addElement(listofdata);
            }
            ListOfData list = (ListOfData)this.listOfData.get(indx);
            this.plistOfData.removeAll();
            this.plistOfData.setBorder(new TitledBorder("list of data"));
            this.plistOfData.setLayout(new BoxLayout(this.plistOfData, 0));
            this.plistOfData.add(list);
        }

        private void createNewAxis() {
            String newAxisName = this.newaxisTextField.getText();
            int i = 0;
            while (i < this.selector.getItemCount()) {
                if (this.selector.getItemAt(i).toString().equals(newAxisName)) {
                    this.logger.warn((Object)"duplicate axis name.");
                }
                ++i;
            }
            if (newAxisName == null || newAxisName.trim().length() == 0) {
                newAxisName = String.valueOf(this.selector.getItemAt(0).toString()) + String.valueOf(this.selector.getItemCount());
            }
            this.selector.addItem(newAxisName);
            this.selector.setSelectedItem(newAxisName);
            DataSetManipulator.this.manipulator.changeAxisState(this, this.selector.getItemCount());
        }

        private void removeSelectedAxis() {
            if (this.selector.getItemCount() == 1) {
                this.logger.warn((Object)"you need at least one axis.");
                return;
            }
            Object sele = this.selector.getSelectedItem();
            this.selector.removeItem(sele);
            DataSetManipulator.this.manipulator.changeAxisState(this, this.selector.getItemCount());
        }

        class ListOfData
        extends JScrollPane {
            private Logger logger = Logger.getLogger((String)ListOfData.class.getName());
            private JList listofdata;
            private DefaultListModel listModel;
            private int selectionType;
            private Vector dataVector = new Vector();

            protected ListOfData(int selectionType) {
                this.setPreferredSize(new Dimension(400, 150));
                this.selectionType = selectionType;
                this.init();
            }

            private void init() {
                this.listModel = new DefaultListModel();
                this.listofdata = new JList(this.listModel);
                this.viewport.add(this.listofdata);
            }

            void addNewData(DataSetElement data) {
                if (this.selectionType == 0) {
                    this.logger.debug((Object)"SINGLE_SELECTION");
                    this.listModel.removeAllElements();
                    this.dataVector.removeAllElements();
                } else {
                    this.logger.debug((Object)"MULTIPLE_SELECTION");
                }
                String listString = "data set: " + data.getParent().getName() + " element: " + data.toString();
                int i = 0;
                while (i < this.listModel.size()) {
                    String comp = this.listModel.get(i).toString();
                    if (comp.equals(listString)) {
                        this.logger.warn((Object)"duplicate data");
                        return;
                    }
                    ++i;
                }
                this.listModel.addElement("data set: " + data.getParent().getName() + " element: " + data);
                this.dataVector.addElement(data);
                this.listofdata.revalidate();
            }

            void removeSelectedData() {
                Object[] sele = this.listofdata.getSelectedValues();
                int[] indeces = this.listofdata.getSelectedIndices();
                if (sele == null) {
                    return;
                }
                int i = sele.length - 1;
                while (i >= 0) {
                    this.listModel.removeElement(sele[i]);
                    --i;
                }
                i = indeces.length - 1;
                while (i >= 0) {
                    this.dataVector.removeElementAt(indeces[i]);
                    --i;
                }
                this.listofdata.revalidate();
            }

            DataSetElement[] getData() {
                int size = this.listModel.getSize();
                if (size <= 0) {
                    return null;
                }
                DataSetElement[] ele = new DataSetElement[size];
                int i = 0;
                while (i < size) {
                    ele[i] = (DataSetElement)this.dataVector.get(i);
                    ++i;
                }
                return ele;
            }
        }
    }

    class DataSetBrowser
    extends JPanel {
        private Logger logger = Logger.getLogger((String)DataSetBrowser.class.getName());
        private int treeSelectionMode = 4;
        private String title;
        private DataSet[] dset;
        private DataSetTree tree;
        private AxisSelectionPanel axis;
        private DataSetBrowser browser;
        private String axis_type;

        public DataSetBrowser(String title, DataSet[] dset) {
            this.title = title;
            this.dset = dset;
            this.init();
        }

        public DataSetBrowser(String title, DataSet[] dset, int selectionMode) {
            this.title = title;
            this.dset = dset;
            this.treeSelectionMode = selectionMode;
            this.init();
        }

        public DataSetElement[][] getDataSetElements() {
            return this.axis.getDataSetElements();
        }

        public String[] getNames() {
            return this.axis.getNames();
        }

        private void init() {
            this.setLayout(new BoxLayout(this, 1));
            this.tree = new DataSetTree(this.title, this.dset, this.treeSelectionMode);
            JButton btndown = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/Down.gif"));
            JButton btndele = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/Delete.gif"));
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(btndown);
            panel.add(btndele);
            this.add(this.tree);
            this.add(panel);
            btndown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataSetElement[] data = DataSetBrowser.this.tree.getSelectedDataSetElement();
                    if (data == null || data.length == 0) {
                        return;
                    }
                    int i = 0;
                    while (i < data.length) {
                        DataSetBrowser.this.axis.addData(data[i]);
                        ++i;
                    }
                }
            });
            btndele.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataSetBrowser.this.axis.removeSelectedData();
                }
            });
        }

        AxisSelectionPanel getAxisPanel() {
            return this.axis;
        }

        void setAxisPanel(AxisSelectionPanel ax) {
            int n = this.getComponentCount();
            int i = n - 1;
            while (i >= 0) {
                Component comp = this.getComponent(i);
                if (comp instanceof AxisSelectionPanel) {
                    this.remove(comp);
                }
                --i;
            }
            this.axis = ax;
            this.add(ax);
            this.revalidate();
        }
    }

    class DataSetTree
    extends JPanel {
        private Logger logger = Logger.getLogger((String)DataSetTree.class.getName());
        private DataSet[] dset;
        private JTree tree;
        private DefaultTreeModel treeModel;
        private int selectionMode = 4;

        public DataSetTree(String title, DataSet[] dset) {
            this.dset = dset;
            this.setBorder(new TitledBorder(title));
            this.init();
            this.createGUI();
        }

        public DataSetTree(String title, DataSet[] dset, int selectionMode) {
            this.dset = dset;
            this.selectionMode = selectionMode;
            this.setBorder(new TitledBorder(title));
            this.init();
            this.createGUI();
        }

        private void init() {
            if (this.dset == null || this.dset.length == 0) {
                return;
            }
            DataSetBrowserNode rootNode = new DataSetBrowserNode("data set");
            this.treeModel = new DefaultTreeModel(rootNode);
            int i = 0;
            while (i < this.dset.length) {
                DataSetBrowserNode dsetNode = new DataSetBrowserNode(this.dset[i]);
                rootNode.add(dsetNode);
                DataSetElement[] dsetElement = this.dset[i].getData();
                if (dsetElement != null && dsetElement.length != 0) {
                    int j = 0;
                    while (j < dsetElement.length) {
                        DataSetBrowserNode dsetENode = new DataSetBrowserNode(dsetElement[j]);
                        dsetNode.add(dsetENode);
                        ++j;
                    }
                }
                ++i;
            }
            this.tree = new JTree(this.treeModel);
            this.tree.setCellRenderer(new DataSetBrowserRenderer());
            this.tree.getSelectionModel().setSelectionMode(this.selectionMode);
        }

        private void createGUI() {
            this.setLayout(new BoxLayout(this, 1));
            JScrollPane scr = new JScrollPane();
            scr.setPreferredSize(new Dimension(400, 150));
            scr.setSize(scr.getPreferredSize());
            scr.getViewport().setView(this.tree);
            this.add(scr);
        }

        public JTree getTree() {
            return this.tree;
        }

        public DataSetElement[] getSelectedDataSetElement() {
            Object[] ret = null;
            TreePath[] path = this.tree.getSelectionPaths();
            if (path == null || path.length == 0) {
                this.logger.warn((Object)"no selection.");
                return null;
            }
            Vector<DataSetElement> dsetVector = new Vector<DataSetElement>();
            int i = 0;
            while (i < path.length) {
                DataSetElement dse;
                DataSetBrowserNode node = (DataSetBrowserNode)path[i].getLastPathComponent();
                if (node.isLeaf() && (dse = node.getDataSetElement()) != null) {
                    dsetVector.addElement(dse);
                }
                ++i;
            }
            if (dsetVector.size() == 0) {
                this.logger.warn((Object)"no data selected.");
                return null;
            }
            ret = new DataSetElement[dsetVector.size()];
            dsetVector.copyInto(ret);
            return ret;
        }

        class DataSetBrowserNode
        extends DefaultMutableTreeNode {
            DataSetBrowserNode() {
            }

            DataSetBrowserNode(Object obj) {
                super(obj);
            }

            DataSetBrowserNode(Object obj, boolean allowChild) {
                super(obj, allowChild);
            }

            DataSetElement getDataSetElement() {
                if (this.userObject instanceof DataSetElement) {
                    return (DataSetElement)this.userObject;
                }
                return null;
            }
        }

        class DataSetBrowserRenderer
        extends DefaultTreeCellRenderer {
            DataSetBrowserRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            }
        }
    }

    class PlotSelectionPanel
    extends JPanel {
        private Logger logger = Logger.getLogger((String)PlotSelectionPanel.class.getName());
        private JComboBox plotSelector;
        private JTextField tfnewplot;
        private Vector plotProperties = new Vector();
        private Vector axisxCache = new Vector();
        private Vector axisyCache = new Vector();

        public PlotSelectionPanel(String title) {
            JPanel pplot = new JPanel();
            pplot.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            String axis_type = "range";
            pplot.setBorder(new TitledBorder("manipulate plot"));
            pplot.setLayout(new BoxLayout(pplot, 0));
            this.plotSelector = new JComboBox<String>(new String[]{title});
            SubPlotProperties spp = new SubPlotProperties();
            DataSetManipulator.this.props.addSubPlotProperties(spp);
            this.tfnewplot = new JTextField(10);
            JButton btnnewplot = new JButton("create plot");
            JButton btnremplot = new JButton("remove plot");
            JButton btneditConfig = new JButton("edit configuration");
            pplot.add((Component)this.plotSelector, gc);
            pplot.add((Component)this.tfnewplot, gc);
            pplot.add((Component)btnnewplot, gc);
            pplot.add(btnremplot);
            pplot.add((Component)btneditConfig, gc);
            this.add(pplot);
            btnnewplot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotSelectionPanel.this.newPlot();
                }
            });
            btnremplot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotSelectionPanel.this.removePlot();
                }
            });
            this.plotSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotSelectionPanel.this.plotSelected();
                }
            });
            btneditConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotPropertiesEditor editor = new PlotPropertiesEditor(PlotSelectionPanel.this.plotSelector.getSelectedItem().toString(), DataSetManipulator.this.props, PlotSelectionPanel.this.plotSelector.getSelectedIndex());
                }
            });
            this.plotSelector.setSelectedIndex(0);
        }

        private void newPlot() {
            String newplotName = this.tfnewplot.getText();
            int i = 0;
            while (i < this.plotSelector.getItemCount()) {
                if (this.plotSelector.getItemAt(i).toString().equals(newplotName)) {
                    this.logger.warn((Object)"duplicate plot name.");
                }
                ++i;
            }
            if (newplotName == null || newplotName.trim().length() == 0) {
                newplotName = String.valueOf(this.plotSelector.getItemAt(0).toString()) + String.valueOf(this.plotSelector.getItemCount());
            }
            this.plotSelector.addItem(newplotName);
            this.plotSelector.setSelectedItem(newplotName);
            SubPlotProperties spp = new SubPlotProperties();
            DataSetManipulator.this.props.addSubPlotProperties(spp);
        }

        private void removePlot() {
            if (this.plotSelector.getItemCount() == 1) {
                this.logger.warn((Object)"you need at least one plot.");
                return;
            }
            int remind = this.plotSelector.getSelectedIndex();
            SubPlotProperties spp = DataSetManipulator.this.props.getSubPlotPropertiesAt(remind);
            DataSetManipulator.this.props.removeSubPlotProperty(spp);
            Object ox = this.axisxCache.get(remind);
            this.axisxCache.remove(ox);
            Object oy = this.axisyCache.get(remind);
            this.axisyCache.remove(oy);
            Object o = this.plotSelector.getSelectedItem();
            this.plotSelector.removeItem(o);
        }

        private void plotSelected() {
            String ID = this.plotSelector.getSelectedItem().toString();
            AxisSelectionPanel axisx = null;
            AxisSelectionPanel axisy = null;
            int i = 0;
            while (i < this.axisxCache.size()) {
                if (((AxisSelectionPanel)this.axisxCache.get(i)).getID().equals(ID)) {
                    axisx = (AxisSelectionPanel)this.axisxCache.get(i);
                    axisy = (AxisSelectionPanel)this.axisyCache.get(i);
                    break;
                }
                ++i;
            }
            if (axisx == null) {
                axisx = new AxisSelectionPanel("domain", ID);
                axisy = new AxisSelectionPanel("range", ID);
                this.axisxCache.addElement(axisx);
                this.axisyCache.addElement(axisy);
            }
            DataSetManipulator.this.browserX.setAxisPanel(axisx);
            DataSetManipulator.this.browserY.setAxisPanel(axisy);
            DataSetManipulator.this.manipulator.revalidate();
        }

        AxisSelectionPanel[] getAxisX() {
            return this.getArrayFrom(this.axisxCache);
        }

        AxisSelectionPanel[] getAxisY() {
            return this.getArrayFrom(this.axisyCache);
        }

        String getPlotTitle(int i) {
            return this.plotSelector.getItemAt(i).toString();
        }

        private AxisSelectionPanel[] getArrayFrom(Vector vec) {
            if (vec == null || vec.size() == 0) {
                return null;
            }
            Object[] p = new AxisSelectionPanel[vec.size()];
            vec.copyInto(p);
            return p;
        }
    }
}

