/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.filebrowser.MyJLabel;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class FileProperty
extends JScrollPane {
    private RemoteFile file;

    protected FileProperty(RemoteFile file) {
        this.file = file;
        this.createFileProperty();
    }

    private void createFileProperty() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        String location = "";
        RemoteFile parent = (RemoteFile)this.file.getParentFile();
        location = parent == null ? "root" : parent.getAbsolutePath();
        String slocation = "location:      " + location;
        MyJLabel llocation = new MyJLabel(slocation);
        boolean isDirectory = this.file.isDirectory();
        String type = "file type:     ";
        type = isDirectory ? String.valueOf(type) + "directory" : String.valueOf(type) + "file";
        MyJLabel ltype = new MyJLabel(type);
        boolean canread = this.file.canRead();
        String scanread = "read:          ";
        scanread = canread ? String.valueOf(scanread) + "yes" : String.valueOf(scanread) + "no";
        MyJLabel lcanread = new MyJLabel(scanread);
        boolean canwrite = this.file.canWrite();
        String scanwrite = "write:         ";
        scanwrite = canwrite ? String.valueOf(scanwrite) + "yes" : String.valueOf(scanwrite) + "no";
        MyJLabel lcanwrite = new MyJLabel(scanwrite);
        String lastmodified = "last modified: " + FileProperty.getTime(this.file.lastModified());
        MyJLabel llastmodified = new MyJLabel(lastmodified);
        long size = this.file.length();
        String ssize = "size:          " + String.valueOf(size) + " bytes";
        MyJLabel lsize = new MyJLabel(ssize);
        p.add(llocation);
        p.add(ltype);
        p.add(lcanread);
        p.add(lcanwrite);
        p.add(llastmodified);
        p.add(lsize);
        this.getViewport().setView(p);
    }

    protected static String getTime(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar.getTime().toString();
    }
}

