/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.filebrowser.FileBrowserEvent;
import ciss.phase_viewer.filebrowser.FileBrowserTree;
import ciss.phase_viewer.filebrowser.FileBrowserTreeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DefaultFileBrowserPanel
extends JPanel
implements FileBrowserTreeListener {
    private Logger logger = Logger.getLogger((String)DefaultFileBrowserPanel.class.getName());
    private String initDir = System.getProperty("user.home");
    private FileBrowserTree local;
    private String nodeClass = "ciss.phase_viewer.filebrowser.DefaultFileBrowserNode";

    public DefaultFileBrowserPanel() {
        this.init();
    }

    public DefaultFileBrowserPanel(String initDir) {
        this.initDir = initDir;
        this.init();
    }

    public DefaultFileBrowserPanel(String initDir, String nodeClass) {
        this.initDir = initDir;
        this.nodeClass = nodeClass;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        int os = 0;
        if (!System.getProperty("os.name").trim().toLowerCase().startsWith("windows")) {
            os = 1;
        }
        this.local = new FileBrowserTree(os, this.initDir, this, this.nodeClass, true, false);
        this.add(this.local);
    }

    public FileBrowserTree getFileBrowserTree() {
        return this.local;
    }

    public void addFileBrowserTreeListener(FileBrowserTreeListener listener) {
        if (this.local != null) {
            this.local.addFileBrowserListener(listener);
        }
    }

    @Override
    public void directoryHasChanged(FileBrowserEvent e) {
    }

    public String[] getSelectedPaths() {
        return this.local.getSelectedPaths();
    }
}

