/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileInfoSpec;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.jobcontrol.JobControllerElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public abstract class ChaseFileManager
implements JobControllerElement {
    private Logger logger = Logger.getLogger((String)ChaseFileManager.class.getName());
    protected File fileSpecFile;
    protected URL specFile;
    protected Element fileInf;
    protected HostInfo hostInfo;
    protected Document fileInfoDocument;
    protected ProjectInfo projectInfo;
    public static String BASEDIR = "basedir";
    public static String BLOCK = "block";
    protected Element[] file_templates;
    protected Vector file_vector = new Vector();
    protected LinkedHashMap chaseFileInfoSpec = new LinkedHashMap();
    protected String outputDirectory = "";

    public ChaseFileManager(HostInfo hostInfo, URL specFile, File fileSpecFile) {
        this.hostInfo = hostInfo;
        this.specFile = specFile;
        this.fileSpecFile = fileSpecFile;
        if (fileSpecFile != null) {
            this.logger.debug((Object)("specFile: " + specFile.toString() + " fileSpecFile: " + fileSpecFile.getAbsolutePath()));
        }
        this.parseSpecFile();
    }

    public void setFileSpecFile(File fileSpecFile) {
        this.fileSpecFile = fileSpecFile;
    }

    public ChaseFileManager(URL specFile, File fileSpecFile) {
        this(HostList.getHostList().getHostInfo("localhost"), specFile, fileSpecFile);
    }

    private void parseSpecFile() {
        Document document = XMLUtils.getDocumentFromURL(this.specFile);
        Element fileinf = null;
        if (document == null) {
            this.logger.fatal((Object)"FATAL ERROR invalid fileinfo file");
            return;
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            this.logger.fatal((Object)"FATAL ERROR invalid fileinfo file");
            return;
        }
        List fileinfos = rootElement.getChildren("fileinfo");
        if (fileinfos == null || fileinfos.size() == 0) {
            this.logger.fatal((Object)("no fileinfos in: " + this.specFile.toString()));
            return;
        }
        int i = 0;
        while (i < fileinfos.size()) {
            Element finfo = (Element)fileinfos.get(i);
            Attribute att = finfo.getAttribute("fileinfoname");
            if (att == null) {
                this.logger.fatal((Object)"invalid fileinfo.");
                return;
            }
            if (att.getValue().equals(this.getName())) {
                fileinf = finfo;
            }
            ++i;
        }
        if (fileinf == null) {
            this.logger.fatal((Object)"couldn't find an appropriate file info.");
            return;
        }
        Element fispec = fileinf.getChild("fileinfospec");
        List fispecList = fispec.getChildren();
        int i2 = 0;
        while (i2 < fispecList.size()) {
            Element ele = (Element)fispecList.get(i2);
            ChaseFileInfoSpec cfispec = new ChaseFileInfoSpec(ele);
            this.chaseFileInfoSpec.put(cfispec.getName(), cfispec);
            ++i2;
        }
        List li = fileinf.getChildren("file");
        this.file_templates = new Element[li.size()];
        int i3 = 0;
        while (i3 < li.size()) {
            this.file_templates[i3] = (Element)li.get(i3);
            ++i3;
        }
    }

    public ChaseFileInfoSpec[] getFileInfoSpecs() {
        Collection col = this.chaseFileInfoSpec.values();
        ChaseFileInfoSpec[] specs = new ChaseFileInfoSpec[col.size()];
        col.toArray(specs);
        return specs;
    }

    public ChaseFileInfoSpec getFileInfoSpec(Object key) {
        Object obj = this.chaseFileInfoSpec.get(key);
        if (obj instanceof ChaseFileInfoSpec) {
            return (ChaseFileInfoSpec)obj;
        }
        return null;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.logger.debug((Object)"at setProjectInfo");
        this.fileInfoDocument = JobController.getJobControlDocument(projectInfo, this);
        this.logger.debug((Object)"got fileInfoDocument...");
        if (this.fileInfoDocument != projectInfo.getProjectPropertyDocument()) {
            projectInfo.setProjectPropertyDocument(this.fileInfoDocument);
        } else {
            this.logger.debug((Object)"fileTransferDocument == projectInfo.getProjectPropertyDocument()");
        }
        this.save();
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    private ChaseFile findFile(String ident, String fname) {
        boolean useFname = true;
        if (fname == null || fname.trim().length() == 0) {
            useFname = false;
        }
        int i = 0;
        while (i < this.file_vector.size()) {
            ChaseFile cfi = (ChaseFile)this.file_vector.get(i);
            if (!useFname ? ident.matches(cfi.getIdentifier().getValue()) : ident.matches(cfi.getIdentifier().getValue()) && fname.equals(cfi.getFileName())) {
                return cfi;
            }
            ++i;
        }
        return null;
    }

    public ChaseFile addFile(Element element) {
        ChaseFile cfi = new ChaseFile(element);
        this.fileInf.addContent((Content)element);
        this.file_vector.addElement(cfi);
        return cfi;
    }

    public ChaseFile addFileByKey(String ident, String key, String value) {
        int i = 0;
        while (i < this.file_templates.length) {
            String ide = this.file_templates[i].getChildTextTrim("identifier");
            if (ident.matches(ide)) {
                this.logger.debug((Object)("at addFileByKey. ident: " + ident + " key: " + key + " value: " + value));
                Element elem = (Element)this.file_templates[i].clone();
                if (key != null && value != null) {
                    elem.getChild(key).setText(value);
                }
                this.fileInf.addContent((Content)elem);
                ChaseFile cfi = new ChaseFile(elem, this.chaseFileInfoSpec);
                this.file_vector.addElement(cfi);
                return cfi;
            }
            ++i;
        }
        return null;
    }

    public ChaseFile addFile(String relative_path, String ident, String filename) {
        int i = 0;
        while (i < this.file_templates.length) {
            String ide = this.file_templates[i].getChildTextTrim("identifier");
            if (ident.matches(ide)) {
                Element elem = (Element)this.file_templates[i].clone();
                this.fileInf.addContent((Content)elem);
                ChaseFile cfi = new ChaseFile(elem, this.chaseFileInfoSpec);
                cfi.update("relative_path", relative_path);
                cfi.update("filename", filename);
                this.file_vector.addElement(cfi);
                return cfi;
            }
            ++i;
        }
        return null;
    }

    public ChaseFile addFileAt(int ind, String relative_path, String ident, String filename) {
        int i = 0;
        while (i < this.file_templates.length) {
            String ide = this.file_templates[i].getChildTextTrim("identifier");
            if (ident.matches(ide)) {
                Element elem = (Element)this.file_templates[i].clone();
                this.fileInf.addContent(ind, (Content)elem);
                ChaseFile cfi = new ChaseFile(elem, this.chaseFileInfoSpec);
                cfi.update("relative_path", relative_path);
                cfi.update("filename", filename);
                if (ind < this.file_vector.size() && ind >= 0) {
                    this.file_vector.add(ind, cfi);
                } else {
                    this.file_vector.add(cfi);
                }
                return cfi;
            }
            ++i;
        }
        return null;
    }

    public void updateFile(String ident, String fname, String key, String val) {
        ChaseFile cfi = this.findFile(ident, fname);
        if (cfi == null) {
            this.addFileByKey(ident, key, val);
            return;
        }
        cfi.update(key, val);
    }

    public void updateFile(String ident, String fname, String key, boolean b) {
        String val = Boolean.toString(b);
        this.updateFile(ident, fname, key, val);
    }

    public void updateFile(String ident, String key, String val) {
        this.updateFile(ident, null, key, val);
    }

    public void updateFile(String ident, String key, boolean b) {
        String val = Boolean.toString(b);
        this.updateFile(ident, key, val);
    }

    public void removeFile(Object file) {
        int i = 0;
        while (i < this.file_vector.size()) {
            Object obj = this.file_vector.get(i);
            if (obj == file) {
                this.logger.debug((Object)"found file to remove...");
                this.file_vector.remove(i);
                if (!(file instanceof ChaseFile)) break;
                ((ChaseFile)file).getElement().detach();
                break;
            }
            ++i;
        }
    }

    public ChaseFile[] getFiles(String ident) {
        ChaseFile cf;
        Vector<ChaseFile> tmp = new Vector<ChaseFile>();
        int i = 0;
        while (i < this.file_vector.size()) {
            cf = (ChaseFile)this.file_vector.get(i);
            if (ident.matches(cf.getIdentifier().getValue())) {
                tmp.addElement(cf);
            }
            ++i;
        }
        if (tmp.size() == 0) {
            this.addFileByKey(ident, null, null);
            i = 0;
            while (i < this.file_vector.size()) {
                cf = (ChaseFile)this.file_vector.get(i);
                if (ident.matches(cf.getIdentifier().getValue())) {
                    tmp.addElement(cf);
                }
                ++i;
            }
            if (tmp.size() == 0) {
                return null;
            }
        }
        Object[] ret = new ChaseFile[tmp.size()];
        tmp.copyInto(ret);
        return ret;
    }

    public ChaseFile getFile(String ident) {
        int i = 0;
        while (i < this.file_vector.size()) {
            ChaseFile cf = (ChaseFile)this.file_vector.get(i);
            if (ident.matches(cf.getIdentifier().getValue())) {
                return cf;
            }
            ++i;
        }
        ChaseFile ret = this.addFileByKey(ident, null, null);
        this.save();
        return ret;
    }

    public ChaseFile[] getFiles() {
        Object[] ret = new ChaseFile[this.file_vector.size()];
        this.file_vector.copyInto(ret);
        return ret;
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public void setHostInfo(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public void save() {
        this.saveSub();
        this.saveFileInfo();
    }

    protected abstract void saveSub();

    protected abstract void postInit();

    protected abstract void postRead();

    protected void saveFileInfo() {
        if (this.fileInfoDocument == null) {
            this.logger.error((Object)"fileInfoDocument is NNNNNUUUULLLLL!!!!");
        }
        this.logger.debug((Object)("projectdir at this point: " + this.projectInfo.getProjectDirectory()));
        JobController.saveJobControlFile(this.projectInfo.getProjectDirectory(), this.fileInfoDocument);
    }

    public abstract String getName();

    @Override
    public void initJobControlDocument(Document doc) {
        Element root = doc.getRootElement().getChild(JobController.JOBCONTROL);
        Element fileInfo = new Element("fileinfo");
        int i = 0;
        while (i < this.file_templates.length) {
            String fname = this.file_templates[i].getChildTextTrim("filename");
            String defname = this.file_templates[i].getChildTextTrim("defaultname");
            if (fname != null && fname.trim().length() != 0 || defname != null && defname.trim().length() != 0) {
                fileInfo.addContent((Content)((Element)this.file_templates[i].clone()));
            }
            ++i;
        }
        root.addContent((Content)fileInfo);
        this.postInit();
    }

    public String getOutputDir() {
        return this.outputDirectory;
    }

    @Override
    public boolean readJobControlDocument(Document doc) {
        Element root = doc.getRootElement();
        if (root == null) {
            this.logger.debug((Object)"no root element...");
            return false;
        }
        Element jobControlElement = root.getChild(JobController.JOBCONTROL);
        if (jobControlElement == null) {
            this.logger.debug((Object)"no jobcontrol element...");
            return false;
        }
        Element elem = jobControlElement.getChild("fileinfo");
        if (elem == null) {
            this.logger.debug((Object)"no fileinfo...");
            return false;
        }
        this.fileInf = elem;
        List files = elem.getChildren("file");
        if (files == null || files.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < files.size()) {
            Element file = (Element)files.get(i);
            this.logger.debug((Object)("ident: " + file.getChildTextTrim("identifier")));
            this.file_vector.addElement(new ChaseFile(file, this.chaseFileInfoSpec));
            ++i;
        }
        this.postRead();
        return true;
    }
}

