/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import org.apache.log4j.Logger;

public class VectorOperations {
    private static final Logger logger = Logger.getLogger((String)VectorOperations.class.getName());

    public static double calDist(double[] firstVector, double[] secondVector) {
        double dist = 0.0;
        if (firstVector == null || secondVector == null) {
            logger.error((Object)"either first vector or second vector is null... ");
            return 0.0;
        }
        int ndim = firstVector.length;
        if (ndim > secondVector.length) {
            ndim = secondVector.length;
        }
        if (ndim != secondVector.length) {
            logger.warn((Object)("the dimension of the two vectors are inconsistent... using the smaller one, " + ndim));
        }
        int i = 0;
        while (i < ndim) {
            dist += Math.pow(firstVector[i] - secondVector[i], 2.0);
            ++i;
        }
        dist = Math.sqrt(dist);
        return dist;
    }

    public static float calDist(float[] firstVector, float[] secondVector) {
        double[] dfv = new double[firstVector.length];
        double[] dsv = new double[secondVector.length];
        int i = 0;
        while (i < dfv.length) {
            dfv[i] = firstVector[i];
            ++i;
        }
        i = 0;
        while (i < dsv.length) {
            dsv[i] = secondVector[i];
            ++i;
        }
        float ret = (float)VectorOperations.calDist(dfv, dsv);
        return ret;
    }

    public static double dotProduct(double[] v1, double[] v2) {
        if (v1 == null || v2 == null) {
            logger.error((Object)"either first vector or second vector is null... ");
            return 0.0;
        }
        int ndim = v1.length;
        if (ndim > v2.length) {
            ndim = v2.length;
        }
        if (v1.length != v2.length) {
            logger.warn((Object)("the dimension of the two vectors are inconsistent... using the smaller one, " + ndim));
        }
        double dot = 0.0;
        int i = 0;
        while (i < ndim) {
            dot += v1[i] * v2[i];
            ++i;
        }
        return dot;
    }

    public static float dotProduct(float[] v1, float[] v2) {
        double[] d1 = new double[v1.length];
        double[] d2 = new double[v2.length];
        int i = 0;
        while (i < d1.length) {
            d1[i] = v1[i];
            ++i;
        }
        i = 0;
        while (i < d2.length) {
            d2[i] = v2[i];
            ++i;
        }
        float ret = (float)VectorOperations.dotProduct(d1, d2);
        return ret;
    }

    public static double[] crossProduct(double[] v1, double[] v2) {
        double[] ret = null;
        if (v1 != null && v2 != null) {
            ret = new double[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
        } else {
            logger.error((Object)"either v1 or v2 was null ...");
            logger.error((Object)"returning null.");
        }
        return ret;
    }

    public static float[] crossProduct(float[] v1, float[] v2) {
        double[] d1 = new double[v1.length];
        double[] d2 = new double[v2.length];
        int i = 0;
        while (i < d1.length) {
            d1[i] = v1[i];
            ++i;
        }
        i = 0;
        while (i < d2.length) {
            d2[i] = v2[i];
            ++i;
        }
        double[] foo = VectorOperations.crossProduct(d1, d2);
        float[] ret = new float[foo.length];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = (float)foo[i2];
            ++i2;
        }
        return ret;
    }

    public static double norm(double[] v) {
        double norm = 0.0;
        if (v != null) {
            int i = 0;
            while (i < v.length) {
                norm += v[i] * v[i];
                ++i;
            }
        } else {
            logger.error((Object)"v was null ... ");
        }
        return Math.sqrt(norm);
    }

    public static float norm(float[] v) {
        double[] dv = new double[v.length];
        int i = 0;
        while (i < dv.length) {
            dv[i] = v[i];
            ++i;
        }
        float ret = (float)VectorOperations.norm(dv);
        return ret;
    }

    public static double[] getNormalVector(double[] firstVector, double[] secondVector) {
        if (firstVector == null || secondVector == null) {
            logger.error((Object)"either vector 1 or vector 2 was null...");
            return null;
        }
        if (firstVector.length < 3 || secondVector.length < 3) {
            logger.error((Object)"the dimension of the vectors must at least be greater than 3.");
            return null;
        }
        if (firstVector.length != 3 || secondVector.length != 3) {
            logger.warn((Object)"the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn((Object)"truncating higher dimensions...");
        }
        double[] n1 = VectorOperations.crossProduct(firstVector, secondVector);
        double norm1 = VectorOperations.norm(n1);
        int i = 0;
        while (i < 3) {
            n1[i] = n1[i] / norm1;
            ++i;
        }
        return n1;
    }

    public static float[] getNormalVector(float[] fv, float[] sv) {
        double[] dfv = new double[fv.length];
        double[] dsv = new double[sv.length];
        int i = 0;
        while (i < dfv.length) {
            dfv[i] = fv[i];
            dsv[i] = sv[i];
            ++i;
        }
        double[] ret = VectorOperations.getNormalVector(dfv, dsv);
        float[] retu = new float[ret.length];
        int i2 = 0;
        while (i2 < retu.length) {
            retu[i2] = (float)ret[i2];
            ++i2;
        }
        return retu;
    }

    public static double getDistanceFromPlane(double[] point, double[] firstVector, double[] secondVector, double[] origin) {
        return VectorOperations.getDistanceFromPlane(point, firstVector, secondVector, origin, false);
    }

    public static double getDistanceFromPlane(double[] point, double[] firstVector, double[] secondVector, double[] origin, boolean orientationToo) {
        if (firstVector == null || secondVector == null) {
            logger.error((Object)"either vector 1 or vector 2 was null...");
            return 0.0;
        }
        if (firstVector.length < 3 || secondVector.length < 3) {
            logger.error((Object)"the dimension of the vectors must at least be greater than 3.");
            return 0.0;
        }
        if (firstVector.length != 3 || secondVector.length != 3) {
            logger.warn((Object)"the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn((Object)"truncating higher dimensions...");
        }
        double[] referanceVector = new double[3];
        int i = 0;
        while (i < 3) {
            referanceVector[i] = point[i] - (firstVector[i] + origin[i]);
            ++i;
        }
        double[] normalVector = VectorOperations.getNormalVector(firstVector, secondVector);
        if (!orientationToo) {
            return Math.abs(VectorOperations.dotProduct(normalVector, referanceVector));
        }
        return VectorOperations.dotProduct(normalVector, referanceVector);
    }

    public static double getDistanceFromPlane(double[] point, double[] normalVector, double[] origin) {
        return VectorOperations.getDistanceFromPlane(point, normalVector, origin, false);
    }

    public static double getDistanceFromPlane(double[] point, double[] normalVector, double[] origin, boolean orientationToo) {
        if (normalVector == null) {
            logger.error((Object)"invalid normal...");
            return 0.0;
        }
        if (normalVector.length < 3) {
            logger.error((Object)"the dimension of the vectors must at least be greater than 3.");
            return 0.0;
        }
        if (normalVector.length != 3) {
            logger.warn((Object)"the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn((Object)"truncating higher dimensions...");
        }
        double[] referenceVector = new double[3];
        int i = 0;
        while (i < 3) {
            referenceVector[i] = point[i] - origin[i];
            ++i;
        }
        if (!orientationToo) {
            return Math.abs(VectorOperations.dotProduct(normalVector, referenceVector));
        }
        return VectorOperations.dotProduct(normalVector, referenceVector);
    }

    public static float getAngleBetween(float[] vector1, float[] vector2) {
        float verySmall = 1.0E-4f;
        float norm1 = VectorOperations.norm(vector1);
        float norm2 = VectorOperations.norm(vector2);
        float[] vecbuff1 = vector1;
        float[] vecbuff2 = vector2;
        if (norm1 < verySmall || norm2 < verySmall) {
            return 0.0f;
        }
        float cosine = VectorOperations.dotProduct(vecbuff1, vecbuff2) / (norm1 * norm2);
        if (cosine > 1.0f) {
            cosine = 1.0f;
        }
        if (cosine < -1.0f) {
            cosine = -1.0f;
        }
        return (float)Math.acos(cosine);
    }
}

