/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class RegExpedString {
    private Logger logger = Logger.getLogger((String)RegExpedString.class.getName());
    private String string;
    private boolean hasRegExp = false;
    private String replaceString = "";

    public RegExpedString(String string) {
        this.string = string;
    }

    public RegExpedString(String string, boolean hasRegExp) {
        this.string = string;
        this.hasRegExp = hasRegExp;
    }

    public RegExpedString(String string, boolean hasRegExp, String replaceString) {
        this.string = string;
        this.hasRegExp = hasRegExp;
        this.replaceString = replaceString;
    }

    public RegExpedString(Element element) {
        Attribute rattr = element.getAttribute("hasregexp");
        Attribute replattr = element.getAttribute("replace_string");
        this.string = element.getTextTrim();
        if (rattr != null) {
            this.hasRegExp = rattr.getValue().equals("true");
        }
        if (replattr != null) {
            this.replaceString = replattr.getValue();
        }
    }

    public String getValue() {
        return this.string;
    }

    public boolean hasRegExp() {
        return this.hasRegExp;
    }

    public String getReplaceString() {
        return this.replaceString;
    }

    public String getDefault() {
        if (this.hasRegExp()) {
            return this.replaceString;
        }
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.equalsString((String)obj);
        }
        if (obj instanceof RegExpedString) {
            return ((RegExpedString)obj).getValue().equals(this.string);
        }
        return false;
    }

    private boolean equalsString(String comp) {
        if (this.hasRegExp) {
            boolean matches = false;
            this.logger.debug((Object)("testing if " + this.string + " and " + comp + " matches ..."));
            matches = comp.matches(this.string);
            if (matches) {
                this.logger.debug((Object)"yes.");
            } else {
                this.logger.debug((Object)"no.");
            }
            return matches;
        }
        return this.string.equals(comp);
    }
}

