/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.OldOutputParser;
import java.util.StringTokenizer;

public class DosParser
extends OldOutputParser {
    private int numColumns;
    private int numColumnsMax = 0;
    private int numRows;

    public DosParser(String filename) {
        super(filename);
        String cr = OldOutputParser.CR;
        this.addHeader("# filename: " + filename + cr);
        this.addHeader("# density of states ");
    }

    @Override
    public void parseString(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String strdata = new String();
        boolean bloopisData = false;
        this.numColumns = st.countTokens();
        if (this.numColumns >= this.numColumnsMax) {
            this.setNumColumns(this.numColumns);
            this.numColumnsMax = this.numColumns;
        }
        int i = 0;
        while (i < this.getNumColumns()) {
            if (!st.hasMoreTokens()) break;
            strdata = st.nextToken();
            if (str.trim().startsWith("No")) {
                this.addColumnName(strdata);
                bloopisData = false;
            } else if (str.toLowerCase().trim().startsWith("end")) {
                bloopisData = false;
            } else {
                this.addDataColumn(strdata);
                bloopisData = true;
            }
            ++i;
        }
        if (bloopisData) {
            this.addDataRow();
        }
    }
}

