/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.symmetry;

import Jama.Matrix;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.atomcoord.symmetry.Generic;
import ciss.phase_viewer.atomcoord.symmetry.Primitive;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.main.PluginLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class BravaisLattice
implements InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger((String)BravaisLattice.class.getName());
    public static final String PRIMITIVE = "primitive";
    public static final String RHOMBOHEDRAL = "rhombohedral";
    public static final String HEXAGONAL = "hexagonal";
    public static final String BODY_CENTERED = "bodycentered";
    public static final String BASE_CENTERED = "basecentered";
    public static final String FACE_CENTERED = "facecentered";
    protected String latticeSystem = "primitive";
    protected String[] latticeSystems = new String[]{"primitive", "rhombohedral", "hexagonal", "bodycentered", "basecentered", "facecentered"};
    protected double a;
    protected double b;
    protected double c;
    protected double alpha;
    protected double beta;
    protected double gamma;
    protected HashMap operatorMap;
    private double epsilon = 0.001;
    private double[][] pm = new double[][]{{1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0}, {-1.0, 1.0, -1.0}, {1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0}};
    private boolean isBravais = true;

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
    }

    @Override
    public void inputInterfaceInitialized() {
    }

    @Override
    public void inputInterfaceInitializing() {
    }

    protected BravaisLattice() {
        this.operatorMap = new HashMap();
        this.operatorMap.put(FACE_CENTERED, new double[][]{{0.5, 0.5, 0.0}, {0.5, 0.0, 0.5}, {0.0, 0.5, 0.5}});
        this.operatorMap.put(BODY_CENTERED, new double[][]{{0.5, 0.5, 0.5}});
        this.operatorMap.put(BASE_CENTERED, new double[][]{{0.5, 0.5, 0.0}});
        this.operatorMap.put(RHOMBOHEDRAL, new double[][]{{0.6666666666666666, 0.3333333333333333, 0.3333333333333333}, {0.3333333333333333, 0.6666666666666666, 0.6666666666666666}});
    }

    public double[][] getOperators() {
        Object obj = this.operatorMap.get(this.latticeSystem);
        if (obj == null) {
            return null;
        }
        return (double[][])obj;
    }

    public abstract String getName();

    public abstract String getCrystalSystem();

    public String getLatticeSystem() {
        return this.latticeSystem;
    }

    public void setLatticeSystem(String latticeSystem) {
        this.latticeSystem = latticeSystem;
    }

    public abstract double[][] getPrimitiveLatticeVector();

    public abstract String[] getLatticeSystemCandidate();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BravaisLattice getBravaisLattice(double[] avec, double[] bvec, double[] cvec) {
        block15: {
            breader = null;
            is = null;
            BravaisLattice.logger.debug((Object)"creating bravais lattice");
            cellparams = BravaisLattice.getCellParameters(avec, bvec, cvec);
            BravaisLattice.logger.debug((Object)("a, b, c, alpha, beta, gamma: " + cellparams[0] + ", " + cellparams[1] + ", " + cellparams[2] + ", " + cellparams[3] + ", " + cellparams[4] + ", " + cellparams[5]));
            try {
                is = BravaisLattice.class.getResourceAsStream("/ciss/phase_viewer/atomcoord/symmetry/bravaislattice.properties");
                breader = new BufferedReader(new InputStreamReader(is));
                line = "";
                ** GOTO lbl-1000
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    breader.close();
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break block15;
            }
            catch (Throwable var11_17) {
                try {
                    breader.close();
                    is.close();
                    throw var11_17;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw var11_17;
            }
lbl28:
            // 1 sources

            while (true) {
                try {
                    breader.close();
                    is.close();
                    return var12_12;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return var12_12;
            }
lbl-1000:
            // 3 sources

            {
                ** while ((line = breader.readLine()) != null)
            }
lbl-1000:
            // 1 sources

            {
                if ((line = line.trim()).startsWith("#") || (foo = line.split("=")) == null || foo.length < 2) continue;
                path = foo[1];
                lat = (BravaisLattice)PluginLoader.instantiate(path, null);
                lat.a = cellparams[0];
                lat.b = cellparams[1];
                lat.c = cellparams[2];
                lat.alpha = cellparams[3];
                lat.beta = cellparams[4];
                lat.gamma = cellparams[5];
                ret = lat.tryToCreateBravaisLattice(avec, bvec, cvec);
                if (ret == null) continue;
                var12_12 = ret;
                ** continue;
lbl50:
                // 1 sources

                ** GOTO lbl28
            }
lbl51:
            // 1 sources

            try {
                breader.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BravaisLattice.logger.warn((Object)"no matching crystal!!!");
        lat = new Generic();
        lat.a = cellparams[0];
        lat.b = cellparams[1];
        lat.c = cellparams[2];
        lat.alpha = cellparams[3];
        lat.beta = cellparams[4];
        lat.gamma = cellparams[5];
        return lat;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BravaisLattice getBravaisLattice(double a, double b, double c, double alpha, double beta, double gamma, String latticeSystem) {
        block15: {
            breader = null;
            is = null;
            BravaisLattice.logger.debug((Object)"creating bravais lattice");
            try {
                is = BravaisLattice.class.getResourceAsStream("/ciss/phase_viewer/atomcoord/symmetry/bravaislattice.properties");
                breader = new BufferedReader(new InputStreamReader(is));
                line = "";
                ** GOTO lbl-1000
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    breader.close();
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break block15;
            }
            catch (Throwable var20_20) {
                try {
                    breader.close();
                    is.close();
                    throw var20_20;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw var20_20;
            }
lbl26:
            // 1 sources

            while (true) {
                try {
                    breader.close();
                    is.close();
                    return var21_15;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return var21_15;
            }
lbl-1000:
            // 3 sources

            {
                ** while ((line = breader.readLine()) != null)
            }
lbl-1000:
            // 1 sources

            {
                if ((line = line.trim()).startsWith("#") || (foo = line.split("=")) == null || foo.length < 2) continue;
                na = foo[0];
                path = foo[1];
                lat = (BravaisLattice)PluginLoader.instantiate(path, null);
                if (!lat.isThisForMe(a, b, c, alpha, beta, gamma)) continue;
                lat.a = a;
                lat.b = b;
                lat.c = c;
                lat.alpha = alpha;
                lat.beta = beta;
                lat.gamma = gamma;
                lat.latticeSystem = latticeSystem;
                BravaisLattice.logger.debug((Object)("created bravais lattice : " + lat));
                var21_15 = lat;
                ** continue;
lbl50:
                // 1 sources

                ** GOTO lbl26
            }
lbl51:
            // 1 sources

            try {
                breader.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BravaisLattice.logger.warn((Object)"no matching crystal!!!");
        lat = new Primitive();
        lat.a = a;
        lat.b = b;
        lat.c = c;
        lat.alpha = alpha;
        lat.beta = beta;
        lat.gamma = gamma;
        lat.isBravais(false);
        return lat;
    }

    protected abstract boolean isThisForMe(double var1, double var3, double var5, double var7, double var9, double var11);

    protected abstract BravaisLattice tryToCreateBravaisLattice(double[] var1, double[] var2, double[] var3);

    protected boolean epsilonEquals(double a, double b) {
        return Math.abs(a - b) < this.epsilon;
    }

    public String toString() {
        return this.getName();
    }

    public static boolean isBravais(InputInterface inputInterface) {
        InputInterfacePrimitiveEntry uni = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell_type");
        return !uni.getValue().equalsIgnoreCase(PRIMITIVE);
    }

    public static String getLatticeSystemFrom(InputInterface inputInterface) {
        InputInterfacePrimitiveEntry crystal_symmetry = inputInterface.getInputInterfacePrimitiveEntry("structure.symmetry.crystal_structure");
        if (crystal_symmetry.getValue().equalsIgnoreCase("fcc") || crystal_symmetry.getValue().equalsIgnoreCase("diamond")) {
            return FACE_CENTERED;
        }
        if (crystal_symmetry.getValue().equalsIgnoreCase("bcc")) {
            return BODY_CENTERED;
        }
        InputInterfacePrimitiveEntry lattice_system = inputInterface.getInputInterfacePrimitiveEntry("structure.symmetry.tspace.lattice_system");
        String val = lattice_system.getValue();
        if (val.equalsIgnoreCase(RHOMBOHEDRAL) || val.equalsIgnoreCase("trigonal") || val.equalsIgnoreCase("r") || val.equalsIgnoreCase("t") || val.equalsIgnoreCase("-1")) {
            return RHOMBOHEDRAL;
        }
        if (val.equalsIgnoreCase(HEXAGONAL) || val.equalsIgnoreCase("h") || val.equalsIgnoreCase("1")) {
            return HEXAGONAL;
        }
        if (val.equalsIgnoreCase(PRIMITIVE) || val.equalsIgnoreCase("simple") || val.equalsIgnoreCase("p") || val.equalsIgnoreCase("s")) {
            return PRIMITIVE;
        }
        if (val.equalsIgnoreCase(FACE_CENTERED) || val.equalsIgnoreCase("f") || val.equalsIgnoreCase("2")) {
            return FACE_CENTERED;
        }
        if (val.equalsIgnoreCase(BODY_CENTERED) || val.equalsIgnoreCase("b") || val.equalsIgnoreCase("3")) {
            return BODY_CENTERED;
        }
        if (val.equalsIgnoreCase("bottomcentered") || val.equalsIgnoreCase(BASE_CENTERED) || val.equalsIgnoreCase("onefacecentered") || val.equalsIgnoreCase("bot") || val.equalsIgnoreCase("ba") || val.equalsIgnoreCase("o") || val.equalsIgnoreCase("4")) {
            return BASE_CENTERED;
        }
        return PRIMITIVE;
    }

    public static double[] getCellParameters(double[] avec, double[] bvec, double[] cvec) {
        double[] ret = new double[6];
        double ar = 0.0;
        double br = 0.0;
        double cr = 0.0;
        int i = 0;
        while (i < 3) {
            ar += Math.pow(avec[i], 2.0);
            br += Math.pow(bvec[i], 2.0);
            cr += Math.pow(cvec[i], 2.0);
            ++i;
        }
        ar = Math.sqrt(ar);
        br = Math.sqrt(br);
        cr = Math.sqrt(cr);
        double cda = 0.0;
        double cdb = 0.0;
        double adb = 0.0;
        int i2 = 0;
        while (i2 < 3) {
            cda += cvec[i2] * avec[i2];
            cdb += cvec[i2] * bvec[i2];
            adb += avec[i2] * bvec[i2];
            ++i2;
        }
        double cosbeta = 0.0;
        double cosalph = 0.0;
        double cosgamm = 0.0;
        double beta = 0.0;
        double alph = 0.0;
        double gamm = 0.0;
        try {
            cosbeta = cda / (cr * ar);
            cosalph = cdb / (cr * br);
            cosgamm = adb / (ar * br);
            beta = Math.acos(cosbeta) * 57.29577951308232;
            alph = Math.acos(cosalph) * 57.29577951308232;
            gamm = Math.acos(cosgamm) * 57.29577951308232;
        }
        catch (Exception e) {
            return null;
        }
        ret[0] = ar;
        ret[1] = br;
        ret[2] = cr;
        ret[3] = alph;
        ret[4] = beta;
        ret[5] = gamm;
        return ret;
    }

    public double[][] getGenericPrimitiveVector() {
        int j;
        double[] cellLength = new double[]{this.a, this.b, this.c};
        double alpha = this.alpha * (Math.PI / 180);
        double beta = this.beta * (Math.PI / 180);
        double gamma = this.gamma * (Math.PI / 180);
        double temp = 0.0;
        double[][] cellVec = new double[3][3];
        logger.debug((Object)("cellLength: " + cellLength[0] + " " + cellLength[1] + " " + cellLength[2]));
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                cellVec[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        cellVec[0][0] = 1.0;
        cellVec[1][0] = Math.cos(gamma);
        cellVec[2][0] = Math.cos(beta);
        cellVec[1][1] = Math.sin(gamma);
        cellVec[2][1] = temp = (Math.cos(alpha) - Math.cos(beta) * Math.cos(gamma)) / Math.sin(gamma);
        cellVec[2][2] = Math.sqrt(Math.sin(beta) * Math.sin(beta) - temp * temp);
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                double[] dArray = cellVec[j];
                int n = i;
                dArray[n] = dArray[n] * cellLength[j];
                ++j;
            }
            ++i;
        }
        return cellVec;
    }

    public void addSubLatticeAtoms(AtomCoords coords) {
        if (this.latticeSystem.equals(PRIMITIVE) || this.latticeSystem.equals(HEXAGONAL)) {
            return;
        }
        AtomList atomList = coords.getAtomList();
        double[][] cellvec = this.getGenericPrimitiveVector();
        double[][] operations = this.getOperators();
        if (operations == null) {
            return;
        }
        int undoCount = 0;
        int numat = atomList.size();
        int i = 0;
        while (i < numat) {
            Atom atom = atomList.getAtomAt(i);
            if (!atom.isBoundaryAtom() && !atom.isSubLatticeAtom()) {
                double[] pos = atom.getDouble();
                int j = 0;
                while (j < operations.length) {
                    double[] newpos = new double[3];
                    int l = 0;
                    while (l < 3) {
                        newpos[l] = pos[l];
                        int k = 0;
                        while (k < 3) {
                            int n = l;
                            newpos[n] = newpos[n] + operations[j][k] * cellvec[k][l];
                            ++k;
                        }
                        ++l;
                    }
                    Atom newAtom = new Atom(atom.getElementName(), newpos, atom.getAuxil());
                    newAtom.isSubLatticeAtom(true);
                    atomList.addAtom(newAtom);
                    ++undoCount;
                    ++j;
                }
            }
            ++i;
        }
        atomList.setUndoCount(undoCount);
    }

    public void estimateLatticeSystem(AtomCoords coords) {
        int i;
        String currlat = new String(this.latticeSystem);
        String[] latsys = this.getLatticeSystemCandidate();
        if (!currlat.equalsIgnoreCase(PRIMITIVE) && !currlat.equals(HEXAGONAL)) {
            i = 0;
            while (i < latsys.length) {
                if (latsys[i].equals(currlat)) {
                    return;
                }
                ++i;
            }
        }
        logger.debug((Object)"estimating lattice system");
        i = 0;
        while (i < latsys.length) {
            Vector tmpvec = new Vector();
            if (this.doLatticeSystem(coords, latsys[i], tmpvec)) {
                this.latticeSystem = latsys[i];
                logger.debug((Object)("new lattice system: " + this.latticeSystem));
                return;
            }
            ++i;
        }
    }

    public void stripSubLatticeAtoms(AtomCoords coords) {
        String currlat = new String(this.latticeSystem);
        if (this.stripSubLatticeAtoms(coords, currlat)) {
            return;
        }
        String[] latsys = this.getLatticeSystemCandidate();
        int sys = 0;
        while (sys < latsys.length) {
            if (!latsys[sys].equals(currlat) && this.stripSubLatticeAtoms(coords, latsys[sys])) {
                this.latticeSystem = latsys[sys];
                logger.debug((Object)("new lattice system: " + this.latticeSystem));
                return;
            }
            ++sys;
        }
    }

    public void saveToInputInterface(InputInterface inputInterface) {
        logger.debug((Object)("isBravais(): " + this.isBravais));
        InputInterfacePrimitiveEntry brava = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell_type");
        if (this.isBravais()) {
            brava.setValue("bravais");
        } else {
            brava.setValue(PRIMITIVE);
        }
        inputInterface.replaceEntry(brava, this, true);
        InputInterfacePrimitiveEntry lats = inputInterface.getInputInterfacePrimitiveEntry("structure.symmetry.tspace.lattice_system");
        lats.setValue(this.latticeSystem);
        inputInterface.replaceEntry(lats, this, true);
    }

    public boolean stripSubLatticeAtoms(AtomCoords coords, String latsys) {
        Vector remvec = new Vector();
        boolean strip = this.doLatticeSystem(coords, latsys, remvec);
        int remcount = 0;
        AtomList li = coords.getAtomList();
        if (strip) {
            Vector<Integer> indeces = new Vector<Integer>();
            int i = 0;
            while (i < remvec.size()) {
                int index = li.indexOf(remvec.get(i));
                indeces.addElement(new Integer(index));
                ++i;
            }
            Object[] ints = new Integer[indeces.size()];
            indeces.copyInto(ints);
            Arrays.sort(ints);
            int i2 = ints.length - 1;
            while (i2 >= 0) {
                int index = (Integer)ints[i2];
                logger.debug((Object)("index: " + index));
                if (index < li.getNumAt()) {
                    li.removeAtomAt(index);
                }
                ++remcount;
                --i2;
            }
            logger.debug((Object)("num. at: " + li.getNumAt()));
            li.setUndoCount(remcount);
        }
        return strip;
    }

    private boolean doLatticeSystem(AtomCoords coords, String latsys, Vector remvec) {
        AtomList li = coords.getAtomList();
        AtomList copy = li.getCopy();
        double[][] cellvec = this.getGenericPrimitiveVector();
        Object obj = this.operatorMap.get(latsys);
        if (obj == null) {
            return false;
        }
        double[][] operators = (double[][])obj;
        int i = 0;
        while (i < copy.getNumAt() - 1) {
            Atom at = copy.getAtomAt(i);
            if (!at.isVirtualAtom()) {
                int j = copy.getNumAt() - 1;
                while (j >= i + 1) {
                    Atom compat = copy.getAtomAt(j);
                    if (!compat.isVirtualAtom()) {
                        int iope = 0;
                        while (iope < operators.length) {
                            int ipm = 0;
                            while (ipm < this.pm.length) {
                                double[] tmpop = new double[3];
                                int l = 0;
                                while (l < 3) {
                                    tmpop[l] = this.pm[ipm][l] * operators[iope][l];
                                    ++l;
                                }
                                double[] newpos = new double[3];
                                double[] pos = compat.getDouble();
                                int l2 = 0;
                                while (l2 < 3) {
                                    newpos[l2] = pos[l2];
                                    int k = 0;
                                    while (k < 3) {
                                        int n = l2;
                                        newpos[n] = newpos[n] + tmpop[k] * cellvec[k][l2];
                                        ++k;
                                    }
                                    ++l2;
                                }
                                Atom at2 = new Atom(compat.getElementName(), newpos);
                                if (at2.epsilonEquals(at) && copy.removeAtom(compat, false)) {
                                    remvec.add(compat);
                                }
                                ++ipm;
                            }
                            ++iope;
                        }
                    }
                    --j;
                }
            }
            ++i;
        }
        int numat = copy.getRealNumAt();
        int numorg = numat * (operators.length + 1);
        logger.debug((Object)("numat " + numat + ", numorg " + numorg + ", " + li.getRealNumAt()));
        boolean strip = numorg == li.getRealNumAt();
        return strip;
    }

    public void isBravais(boolean isBravais) {
        this.isBravais = isBravais;
    }

    public boolean isBravais() {
        return this.isBravais;
    }

    public VolumetricData getPrimitiveVolumetricDataFromBravais(VolumetricData origData) {
        if (this.latticeSystem.equals(PRIMITIVE) || this.latticeSystem.equals(HEXAGONAL)) {
            return origData;
        }
        origData.stripPBC();
        double[][] primlat = this.getPrimitiveLatticeVector();
        int[] origNdiv = origData.getNumDiv();
        float[][] origDelta = origData.getDelta();
        float[] origDensity = origData.getDensity();
        float[] origOrigin = origData.getOrigin();
        int[] newNdiv = new int[3];
        float[][] newDelta = new float[3][3];
        float[] newOrigin = new float[3];
        int i = 0;
        while (i < 3) {
            newNdiv[i] = origNdiv[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            newOrigin[i] = origOrigin[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                newDelta[i][j] = (float)(primlat[i][j] / (double)newNdiv[i]);
                ++j;
            }
            ++i;
        }
        logger.debug((Object)("origNdiv: " + origNdiv[0] + ", " + origNdiv[1] + ", " + origNdiv[2]));
        logger.debug((Object)("newNdiv: " + newNdiv[0] + ", " + newNdiv[1] + ", " + newNdiv[2]));
        logger.debug((Object)("origDelta1: " + origDelta[0][0] + ", " + origDelta[0][1] + ", " + origDelta[0][2]));
        logger.debug((Object)("origDelta2: " + origDelta[1][0] + ", " + origDelta[1][1] + ", " + origDelta[1][2]));
        logger.debug((Object)("origDelta3: " + origDelta[2][0] + ", " + origDelta[2][1] + ", " + origDelta[2][2]));
        logger.debug((Object)("newDelta1: " + newDelta[0][0] + ", " + newDelta[0][1] + ", " + newDelta[0][2]));
        logger.debug((Object)("newDelta2: " + newDelta[1][0] + ", " + newDelta[1][1] + ", " + newDelta[1][2]));
        logger.debug((Object)("newDelta3: " + newDelta[2][0] + ", " + newDelta[2][1] + ", " + newDelta[2][2]));
        float[] newDensity = new float[newNdiv[0] * newNdiv[1] * newNdiv[2]];
        double[][] tmpPoint = new double[3][1];
        double[][] tmpprimlat = new double[3][3];
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                tmpprimlat[j][i2] = primlat[i2][j];
                ++j;
            }
            ++i2;
        }
        Matrix primMatrix = new Matrix(tmpprimlat);
        int[] tmpind = new int[3];
        int i3 = 0;
        while (i3 < origNdiv[2]) {
            int j = 0;
            while (j < origNdiv[1]) {
                int k = 0;
                while (k < origNdiv[0]) {
                    int l = 0;
                    while (l < 3) {
                        tmpPoint[l][0] = (float)i3 * origDelta[2][l] + (float)j * origDelta[1][l] + (float)k * origDelta[0][l];
                        ++l;
                    }
                    Matrix pointMatrix = new Matrix(tmpPoint);
                    Matrix keisu = primMatrix.solve(pointMatrix);
                    int l2 = 0;
                    while (l2 < 3) {
                        double foo = keisu.get(l2, 0) - Math.floor(keisu.get(l2, 0));
                        tmpind[l2] = (int)Math.round(foo * (double)newNdiv[l2]);
                        if (tmpind[l2] >= newNdiv[l2]) {
                            tmpind[l2] = 0;
                        }
                        ++l2;
                    }
                    int newtmpind = tmpind[0] * newNdiv[2] * newNdiv[1] + tmpind[1] * newNdiv[2] + tmpind[2];
                    int oldtmpind = k * origNdiv[2] * origNdiv[1] + j * origNdiv[2] + i3;
                    if (newtmpind >= newDensity.length) {
                        System.out.println("ind " + tmpind[0] + ", " + tmpind[1] + ", " + tmpind[2] + " 1dind: " + newtmpind);
                    } else {
                        newDensity[newtmpind] = origDensity[oldtmpind];
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        origData.doPBC(origDensity, origNdiv);
        VolumetricData vdata = new VolumetricData(newDensity, newNdiv, newDelta, newOrigin);
        return vdata;
    }

    public VolumetricData bravaisVolumetricData2Primitive(VolumetricData origData) {
        if (this.latticeSystem.equals(PRIMITIVE) || this.latticeSystem.equals(HEXAGONAL)) {
            return origData;
        }
        origData.stripPBC();
        double[][] primlat = this.getPrimitiveLatticeVector();
        double[][] bravlat = this.getGenericPrimitiveVector();
        int[] origNdiv = origData.getNumDiv();
        float[][] origDelta = origData.getDelta();
        float[] origDensity = origData.getDensity();
        float[] origOrigin = origData.getOrigin();
        int[] newNdiv = new int[3];
        float[][] newDelta = new float[3][3];
        float[] newOrigin = new float[3];
        int i = 0;
        while (i < 3) {
            newNdiv[i] = origNdiv[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            newOrigin[i] = origOrigin[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                newDelta[i][j] = (float)(bravlat[i][j] / (double)newNdiv[i]);
                ++j;
            }
            ++i;
        }
        logger.debug((Object)("origNdiv: " + origNdiv[0] + ", " + origNdiv[1] + ", " + origNdiv[2]));
        logger.debug((Object)("newNdiv: " + newNdiv[0] + ", " + newNdiv[1] + ", " + newNdiv[2]));
        logger.debug((Object)("origDelta1: " + origDelta[0][0] + ", " + origDelta[0][1] + ", " + origDelta[0][2]));
        logger.debug((Object)("origDelta2: " + origDelta[1][0] + ", " + origDelta[1][1] + ", " + origDelta[1][2]));
        logger.debug((Object)("origDelta3: " + origDelta[2][0] + ", " + origDelta[2][1] + ", " + origDelta[2][2]));
        logger.debug((Object)("newDelta1: " + newDelta[0][0] + ", " + newDelta[0][1] + ", " + newDelta[0][2]));
        logger.debug((Object)("newDelta2: " + newDelta[1][0] + ", " + newDelta[1][1] + ", " + newDelta[1][2]));
        logger.debug((Object)("newDelta3: " + newDelta[2][0] + ", " + newDelta[2][1] + ", " + newDelta[2][2]));
        float[] newDensity = new float[newNdiv[0] * newNdiv[1] * newNdiv[2]];
        logger.debug((Object)("origDensitySize: " + origDensity.length));
        logger.debug((Object)("newDensitySize: " + newDensity.length));
        double[][] tmpPoint = new double[3][1];
        double[][] tmpprimlat = new double[3][3];
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                tmpprimlat[j][i2] = primlat[i2][j];
                ++j;
            }
            ++i2;
        }
        Matrix primMatrix = new Matrix(tmpprimlat);
        int[] tmpind = new int[3];
        int i3 = 0;
        while (i3 < newNdiv[2]) {
            int j = 0;
            while (j < newNdiv[1]) {
                int k = 0;
                while (k < newNdiv[0]) {
                    int l = 0;
                    while (l < 3) {
                        tmpPoint[l][0] = (float)i3 * newDelta[2][l] + (float)j * newDelta[1][l] + (float)k * newDelta[0][l];
                        ++l;
                    }
                    Matrix pointMatrix = new Matrix(tmpPoint);
                    Matrix keisu = primMatrix.solve(pointMatrix);
                    int l2 = 0;
                    while (l2 < 3) {
                        double foo = keisu.get(l2, 0) - Math.floor(keisu.get(l2, 0));
                        tmpind[l2] = (int)Math.round(foo * (double)origNdiv[l2]);
                        if (tmpind[l2] >= origNdiv[l2]) {
                            tmpind[l2] = 0;
                        }
                        ++l2;
                    }
                    int oldtmpind = tmpind[0] * origNdiv[2] * origNdiv[1] + tmpind[1] * origNdiv[2] + tmpind[2];
                    int newtmpind = k * newNdiv[2] * newNdiv[1] + j * newNdiv[2] + i3;
                    if (oldtmpind >= origDensity.length) {
                        System.out.println("ind " + tmpind[0] + ", " + tmpind[1] + ", " + tmpind[2] + " 1dind: " + oldtmpind);
                    }
                    newDensity[newtmpind] = origDensity[oldtmpind];
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        origData.setDelta(newDelta);
        origData.doPBC(newDensity, newNdiv);
        origData.createBuffer(newDensity, newNdiv);
        return origData;
    }
}

