/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class FrameCombo
extends JPanel {
    static String FIRST_FRAME = "first frame";
    static String LAST_FRAME = "last frame";
    static String ALL_FRAME = "all";
    private String[] frameChoice = new String[]{FIRST_FRAME, LAST_FRAME, ALL_FRAME};
    private JComboBox combo;
    private Logger logger = Logger.getLogger((String)FrameCombo.class.getName());

    public FrameCombo() {
        this.init();
    }

    private void init() {
        this.setBorder(new TitledBorder("select frame"));
        this.combo = new JComboBox<String>(this.frameChoice);
        this.combo.setEditable(true);
        this.add(this.combo);
    }

    void addActionListener(ActionListener listener) {
        this.combo.addActionListener(listener);
    }

    String getChoice() {
        return this.combo.getSelectedItem().toString();
    }

    int getTargetFrame(int numFrame) {
        int targetFrame = 0;
        String frame = this.getChoice();
        if (frame.equals(ALL_FRAME)) {
            return -1;
        }
        if (frame.equals(LAST_FRAME)) {
            return numFrame - 1;
        }
        if (frame.equals(FIRST_FRAME)) {
            return 0;
        }
        try {
            targetFrame = Integer.parseInt(frame.trim());
        }
        catch (NumberFormatException npe) {
            targetFrame = 0;
        }
        catch (NullPointerException npe) {
            targetFrame = 0;
        }
        if (targetFrame >= numFrame) {
            targetFrame = numFrame - 1;
        }
        return targetFrame;
    }
}

