/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.common.Utils;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CrystalStudioASCIIImporter
implements Importer {
    private Logger logger = Logger.getLogger((String)CrystalStudioASCIIImporter.class.getName());
    private BufferedReader reader = null;
    private AtomCoords coords;
    private boolean readCell = false;
    private boolean isCart = false;
    private int unit = 2;
    private Vector elemSpec = new Vector();

    /*
     * Exception decompiling
     */
    @Override
    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseLine(String line) {
        if (line.startsWith("#")) return true;
        if (line.length() == 0) {
            return true;
        }
        if (this.readCell) return true;
        if (!line.startsWith("Original")) return true;
        try {
            String avec = this.reader.readLine();
            String bvec = this.reader.readLine();
            String cvec = this.reader.readLine();
            this.logger.debug((Object)"avec, bvec, cvec: ");
            this.logger.debug((Object)avec);
            this.logger.debug((Object)bvec);
            this.logger.debug((Object)cvec);
            String[] av = avec.trim().split("\\s+");
            String[] bv = bvec.trim().split("\\s+");
            String[] cv = cvec.trim().split("\\s+");
            double[] dav = new double[3];
            double[] dbv = new double[3];
            double[] dcv = new double[3];
            try {
                int i = 0;
                while (i < 3) {
                    dav[i] = Double.parseDouble(av[i]);
                    dbv[i] = Double.parseDouble(bv[i]);
                    dcv[i] = Double.parseDouble(cv[i]);
                    ++i;
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            catch (ArrayIndexOutOfBoundsException aobe) {
                return false;
            }
            Cell cell = new Cell(av, bv, cv);
            this.coords.setCell(cell);
            String cellang = this.reader.readLine();
            this.logger.debug((Object)("cell ang: " + cellang));
            String cart_and_unit = this.reader.readLine();
            String[] dat = cart_and_unit.trim().split("\\s+");
            if (dat[0].equalsIgnoreCase("cartesian")) {
                this.isCart = true;
            } else if (dat[0].equalsIgnoreCase("fractional")) {
                this.isCart = false;
            }
            if (dat.length >= 2 && dat[1].length() >= 1) {
                String stru = dat[1].substring(1, dat[1].length() - 1);
                if (stru.equalsIgnoreCase("angstrom")) {
                    this.unit = 2;
                } else if (stru.equalsIgnoreCase("bohr")) {
                    this.unit = 1;
                }
            }
            String[] spec = this.reader.readLine().trim().split(",");
            int i = 0;
            while (i < spec.length) {
                Elem el = new Elem();
                String[] spec_ = spec[i].trim().split("\\s+");
                int j = 0;
                while (j < spec_.length) {
                    if (Utils.isNumber(spec_[j])) {
                        el.numAtoms = Integer.parseInt(spec_[j]);
                    } else if (j != 0 && !Utils.isNumber(spec_[j])) {
                        el.bondType = spec_[j];
                    } else {
                        el.elemName = spec_[j].indexOf("+") >= 0 ? spec_[j].split("\\+")[0] : (spec_[j].indexOf("-") >= 0 ? spec_[j].split("\\-")[0] : spec_[j]);
                    }
                    ++j;
                }
                this.logger.debug((Object)("elem spec: " + el));
                this.elemSpec.add(el);
                ++i;
            }
            this.readCell = true;
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            this.logger.error((Object)("not enough data: " + line));
            return false;
        }
        catch (IOException ioe) {
            this.logger.error((Object)"failed read");
            return false;
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)("could not convert " + line + " to a number."));
            return false;
        }
        catch (NullPointerException npe) {
            this.logger.error((Object)"not enough data.");
            return false;
        }
        this.coords.isCart(this.isCart);
        this.coords.setUnit(this.unit);
        try {
            int i = 0;
            while (i < this.elemSpec.size()) {
                Elem e = (Elem)this.elemSpec.get(i);
                String elemName = e.elemName;
                int j = 0;
                while (j < e.numAtoms) {
                    String[] co = this.reader.readLine().trim().split("\\s+");
                    double[] tmpdouble = new double[3];
                    int k = 0;
                    while (k < co.length) {
                        this.logger.debug((Object)("pos " + k + " : " + co[k]));
                        try {
                            tmpdouble[k] = Double.parseDouble(co[k]);
                        }
                        catch (NumberFormatException exc) {
                            return true;
                        }
                        ++k;
                    }
                    Atom atom = new Atom(elemName, tmpdouble);
                    this.coords.getAtomList().addAtom(atom);
                    ++j;
                }
                ++i;
            }
            return true;
        }
        catch (IOException ioe) {
            this.logger.error((Object)"not enough data.");
            return false;
        }
    }

    @Override
    public boolean isImportable(String fileName) {
        return !new File(fileName).isDirectory();
    }

    @Override
    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "Crystal Studio file";
            }
        };
    }

    @Override
    public String getType() {
        return "Crystal Studio file";
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public void setOptions(HashMap options) {
    }

    class Elem {
        String elemName = "X";
        int numAtoms = 0;
        String bondType = "";

        Elem() {
        }

        public String toString() {
            return "elementName: " + this.elemName + " num.atoms: " + String.valueOf(this.numAtoms) + " bond type: " + this.bondType;
        }
    }
}

