/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.CIFFileFilter;
import ciss.phase_viewer.atomcoord.io.Exporter;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CIFExporter
implements Exporter {
    private Logger logger = Logger.getLogger((String)CIFExporter.class.getName());

    @Override
    public boolean writeAtomCoordsTo(AtomCoords[] coords, String fileName) {
        int nframe = coords.length;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new File(fileName));
        }
        catch (FileNotFoundException fnf) {
            return false;
        }
        int i = 0;
        while (i < nframe) {
            AtomCoords coor = coords[i];
            boolean ret = this.writeAtomCoordsTo(coor, writer, i);
            if (!ret) {
                writer.close();
                return false;
            }
            ++i;
        }
        writer.close();
        return true;
    }

    private boolean writeAtomCoordsTo(AtomCoords coor, PrintWriter writer, int i) {
        writer.println("data_frame" + String.valueOf(i));
        double[][] latvec = coor.getCell(1).getDouble();
        if (latvec == null || latvec.length != 2 || latvec[0].length != 3 || latvec[1].length != 3) {
            return false;
        }
        AtomCoords coo = coor.getCopy();
        coo.convertCell(1);
        coo.convert(7, 8);
        writer.println("_symmetry_cell_setting triclinic");
        writer.println("_symmetry_space_group_name_H-M  'P1'");
        writer.println("_symmetry_Int_Tables_number  1");
        writer.println("_cell_length_a " + String.valueOf(latvec[0][0]));
        writer.println("_cell_length_b " + String.valueOf(latvec[0][1]));
        writer.println("_cell_length_c " + String.valueOf(latvec[0][2]));
        writer.println("_cell_angle_alpha " + String.valueOf(latvec[1][0]));
        writer.println("_cell_angle_beta  " + String.valueOf(latvec[1][1]));
        writer.println("_cell_angle_gamma " + String.valueOf(latvec[1][2]));
        int nat = coo.getNumAt();
        writer.println("loop_");
        writer.println("    _atom_site_label");
        writer.println("    _atom_site_fract_x");
        writer.println("    _atom_site_fract_y");
        writer.println("    _atom_site_fract_z");
        writer.println("    _atom_site_type_symbol");
        writer.println("    _atom_site_occupancy");
        int iat = 0;
        while (iat < nat) {
            Atom atom = coo.getAtomList().getAtomAt(iat);
            String elem = atom.getElementName();
            String[] pos = atom.getPos();
            writer.println(String.valueOf(elem) + " " + pos[0] + " " + pos[1] + " " + pos[2] + " " + elem + " 0");
            ++iat;
        }
        return true;
    }

    @Override
    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public String getType() {
        return "CIF";
    }

    @Override
    public FileFilter getFileFilter() {
        return new CIFFileFilter();
    }

    @Override
    public void setOptions(HashMap options) {
    }
}

