/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.operations.BasicOperations;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class MultipleAtomEditor
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)MultipleAtomEditor.class.getName());
    private CoordsViewerInterface parent;
    private JButton btnapply;
    private JButton btnremoveAll;
    private JButton btnclose;
    private AtomObject[] selectedAtoms;
    private AtomCoords coords;
    private JTextField textx;
    private JTextField texty;
    private JTextField textz;
    private Vector attrEditors = new Vector();

    public MultipleAtomEditor(CoordsViewerInterface parent) {
        super("edit multiple atoms", new Dimension(500, 400));
        this.parent = parent;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.init();
    }

    private void init() {
        this.initTrans();
        this.initAttrEditors();
        this.createButtons();
        this.pack();
        this.setVisible(true);
    }

    private void createButtons() {
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        this.btnapply = new JButton("apply");
        this.btnremoveAll = new JButton("remove selected");
        this.btnclose = new JButton("close");
        pbtns.add(this.btnapply);
        pbtns.add(this.btnremoveAll);
        pbtns.add(this.btnclose);
        this.btnapply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MultipleAtomEditor.this.apply();
            }
        });
        this.btnremoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MultipleAtomEditor.this.doRemoveAll();
            }
        });
        this.btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MultipleAtomEditor.this.dispose();
            }
        });
        this.getContentPane().add(pbtns);
    }

    private void apply() {
        BasicOperations bao = this.parent.getBasicOperations();
        bao.wait(true);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(this.textx.getText());
            y = Double.parseDouble(this.texty.getText());
            z = Double.parseDouble(this.textz.getText());
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)"enter double values.");
        }
        catch (NullPointerException npe) {
            this.logger.error((Object)"found invalid value at 'translation'");
        }
        bao.translateSelectedAtoms(x, y, z);
        String elem = "";
        String element = "element";
        String[] pos = new String[3];
        Vector<TaggedString> auxvec = new Vector<TaggedString>();
        int i = 0;
        while (i < this.attrEditors.size()) {
            AttrEditor editor = (AttrEditor)this.attrEditors.elementAt(i);
            if (editor.isSelected()) {
                String ident = editor.getIdent();
                if (ident.equals(element)) {
                    elem = editor.getValue();
                } else {
                    TaggedString aux = new TaggedString(ident, editor.getValue());
                    auxvec.addElement(aux);
                }
            }
            ++i;
        }
        bao.modifyAttributesOfSelectedAtoms(elem, auxvec);
        bao.doUpdate();
    }

    private void doRemoveAll() {
        BasicOperations bao = this.parent.getBasicOperations();
        bao.removeSelectedAtoms();
        this.dispose();
    }

    private void initTrans() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBorder(new TitledBorder("translation"));
        JPanel px = new JPanel();
        px.setBorder(new TitledBorder("x"));
        this.textx = new JTextField(5);
        px.add(this.textx);
        this.textx.setText("0.0");
        JPanel py = new JPanel();
        py.setBorder(new TitledBorder("y"));
        this.texty = new JTextField(5);
        py.add(this.texty);
        this.texty.setText("0.0");
        JPanel pz = new JPanel();
        pz.setBorder(new TitledBorder("z"));
        this.textz = new JTextField(5);
        pz.add(this.textz);
        this.textz.setText("0.0");
        p.add(px);
        p.add(py);
        p.add(pz);
        this.getContentPane().add(p);
    }

    private void initAttrEditors() {
        InputInterfaceTableColumns[] columns = this.parent.getData().getTableColums();
        if (columns == null && columns.length == 0) {
            this.logger.error((Object)"invalid TableSpec file.");
            return;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("attributes"));
        int editor_per_row = 4;
        int editor_count = 0;
        JPanel prow = null;
        int i = 0;
        while (i < columns.length) {
            if (columns[i].hasApplytoAll()) {
                if (editor_count % editor_per_row == 0) {
                    prow = new JPanel();
                    prow.setLayout(new GridLayout(1, editor_per_row));
                    this.logger.debug((Object)"adding prow");
                    p.add(prow);
                    editor_count = 0;
                }
                AttrEditor attrEditor = new AttrEditor(columns[i]);
                prow.add(attrEditor);
                this.attrEditors.addElement(attrEditor);
                ++editor_count;
            }
            ++i;
        }
        this.getContentPane().add(p);
    }

    class AttrEditor
    extends JPanel {
        private InputInterfaceTableColumns column;
        private JTextField text;
        private JCheckBox check;
        private JComboBox box;
        private JCheckBox apply;

        AttrEditor(InputInterfaceTableColumns column) {
            this.column = column;
            this.init();
        }

        String getIdent() {
            return this.column.getName();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder(this.column.getName()));
            this.apply = new JCheckBox();
            this.add((Component)this.apply, "West");
            if (this.column.getCellEditor().equals(InputInterfaceTableColumns.TEXT_FIELD)) {
                this.text = new JTextField(5);
                this.text.setEnabled(false);
                this.add((Component)this.text, "East");
            } else if (this.column.getCellEditor().equals(InputInterfaceTableColumns.CHECK_BOX)) {
                this.check = new JCheckBox(this.column.getName());
                this.check.setEnabled(false);
                this.add((Component)this.check, "East");
            } else if (this.column.getCellEditor().equals(InputInterfaceTableColumns.COMBO_BOX)) {
                this.box = new JComboBox<String>(this.column.getChoices());
                this.box.setEnabled(false);
                this.add((Component)this.box, "East");
            }
            this.apply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean val = AttrEditor.this.apply.isSelected();
                    if (AttrEditor.this.text != null) {
                        AttrEditor.this.text.setEnabled(val);
                    }
                    if (AttrEditor.this.check != null) {
                        AttrEditor.this.check.setEnabled(val);
                    }
                    if (AttrEditor.this.box != null) {
                        AttrEditor.this.box.setEnabled(val);
                    }
                }
            });
        }

        boolean isSelected() {
            return this.apply.isSelected();
        }

        String getValue() {
            if (this.text != null) {
                return this.text.getText();
            }
            if (this.check != null) {
                return this.check.isSelected() ? "1" : "0";
            }
            if (this.box != null) {
                return this.box.getSelectedItem().toString();
            }
            return "";
        }
    }
}

