/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.mouselistener;

import ciss.phase_viewer.acviewer.MainPanel;
import java.awt.event.MouseEvent;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public abstract class MouseMotionListenerAction {
    private static Logger logger = Logger.getLogger((String)MouseMotionListenerAction.class.getName());
    protected MainPanel parent;

    public MouseMotionListenerAction(MainPanel parent) {
        this.parent = parent;
    }

    abstract void init(MouseEvent var1);

    abstract void finalize(MouseEvent var1);

    abstract void processMouseDrag(MouseEvent var1);

    abstract void processMouseMove(MouseEvent var1);

    public static double getScreenScale(MainPanel parent) {
        Transform3D viewplat = new Transform3D();
        parent.getUniverse().getViewingPlatform().getViewPlatformTransform().getTransform(viewplat);
        Vector3d vvd = new Vector3d();
        viewplat.get(vvd);
        double dviewplat = vvd.z;
        Transform3D tgatom3d = new Transform3D();
        parent.getScene().getTGAtom().getTransform(tgatom3d);
        Vector3d transatom = new Vector3d();
        tgatom3d.get(transatom);
        return (dviewplat - transatom.z) / dviewplat;
    }

    public static Point3d getCoordsFromMousePosPlat(MainPanel parent, MouseEvent e) {
        double screenScale = 1.0;
        if (screenScale < parent.getCanvas().getView().getFrontClipDistance()) {
            screenScale = parent.getCanvas().getView().getFrontClipDistance();
        } else if (screenScale > parent.getCanvas().getView().getBackClipDistance()) {
            screenScale = parent.getCanvas().getView().getBackClipDistance();
        }
        int canvSizex = parent.getCanvas().getSize().width;
        int canvSizey = parent.getCanvas().getSize().height;
        double x = 2.0 * screenScale * (double)e.getX() / (double)canvSizex - screenScale;
        double y = 2.0 * screenScale * (double)e.getY() / (double)canvSizey - screenScale;
        logger.debug((Object)("canvSizex, canvSizey: " + canvSizex + ", " + canvSizey));
        logger.debug((Object)("mousePosx, mousePosy: " + e.getX() + ", " + e.getY()));
        logger.debug((Object)("x, y: " + x + ", " + y));
        return new Point3d(x, y, 0.0);
    }

    public static Point3d getCoordsFromMousePos(MainPanel parent, MouseEvent e) {
        Transform3D viewplat = new Transform3D();
        parent.getUniverse().getViewingPlatform().getViewPlatformTransform().getTransform(viewplat);
        Vector3d vvd = new Vector3d();
        viewplat.get(vvd);
        double dviewplat = vvd.z;
        Transform3D tgatom3d = new Transform3D();
        parent.getScene().getTGAtom().getTransform(tgatom3d);
        Vector3d transatom = new Vector3d();
        tgatom3d.get(transatom);
        double screenScale = (dviewplat - transatom.z) / dviewplat;
        if (screenScale < parent.getCanvas().getView().getFrontClipDistance()) {
            screenScale = parent.getCanvas().getView().getFrontClipDistance();
        } else if (screenScale > parent.getCanvas().getView().getBackClipDistance()) {
            screenScale = parent.getCanvas().getView().getBackClipDistance();
        }
        int canvSizex = parent.getCanvas().getSize().width;
        int canvSizey = parent.getCanvas().getSize().height;
        double x = 2.0 * screenScale * (double)e.getX() / (double)canvSizex - screenScale;
        double y = 2.0 * screenScale * (double)e.getY() / (double)canvSizey - screenScale;
        return new Point3d(x, y, 0.0);
    }
}

