/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.keylistener;

import ciss.phase_viewer.acviewer.Animater;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.apache.log4j.Logger;

public class AnimKeyListener
implements KeyListener,
PropertiesListener {
    private Logger logger = Logger.getLogger((String)AnimKeyListener.class.getName());
    private J3DPanel parent;
    private Animater anim;
    private int skip = 5;

    public AnimKeyListener(J3DPanel parent) {
        this.parent = parent;
        PropertiesManager.getGlobalProperties(1);
        GlobalProperties.addPropertiesListener(this);
        this.anim = ((CoordsViewerInterface)((Object)parent)).getAssociatedAnimater();
        try {
            this.skip = Integer.parseInt(PropertiesManager.getGlobalProperties(1).getProperty("keylistener_frame_skip"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.logger.debug((Object)("keyCode: " + e.getKeyCode()));
        if (e.getKeyCode() == 91 || e.getKeyCode() == 80) {
            this.anim.previousFrame();
        } else if (e.getKeyCode() == 93 || e.getKeyCode() == 78) {
            this.anim.nextFrame();
        } else if (e.getKeyCode() == 35 || e.getKeyCode() == 52 && e.isShiftDown()) {
            this.anim.lastFrame();
        } else if (e.getKeyCode() == 36 || e.getKeyCode() == 48 && !e.isShiftDown()) {
            this.anim.firstFrame();
        } else if (e.getKeyCode() == 34 || e.getKeyCode() == 70 && e.isControlDown()) {
            this.anim.nextFrame(this.skip);
        } else if (e.getKeyCode() == 33 || e.getKeyCode() == 66 && e.isControlDown()) {
            this.anim.previousFrame(this.skip);
        } else if (e.getKeyCode() == 65 && e.isControlDown()) {
            this.anim.doAnim();
        }
    }

    @Override
    public void propertiesStored(GlobalProperties properties) {
        try {
            this.skip = Integer.parseInt(properties.getProperty("keylistener_frame_skip"));
            this.logger.debug((Object)("'skip' update : " + this.skip));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

