/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.geom;

import ciss.phase_viewer.acviewer.geom.Plane;
import ciss.phase_viewer.acviewer.geom.Side;
import ciss.phase_viewer.acviewer.geom.Sorter;
import ciss.phase_viewer.common.VectorOperations;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.apache.log4j.Logger;

public class BoundPlane
extends Plane {
    private Logger logger = Logger.getLogger((String)BoundPlane.class.getName());
    private Vector vertices = new Vector();
    float verySmall = 1.0E-4f;

    public BoundPlane() {
    }

    public BoundPlane(Point3f normal) {
        super(normal);
    }

    public BoundPlane(Point3f normal, Point3f origin) {
        super(normal, origin);
    }

    public void setVertices(Point3f[] points) {
        this.vertices = new Vector();
        int i = 0;
        while (i < points.length) {
            this.vertices.addElement(points[i]);
            ++i;
        }
        this.sortVertices();
    }

    public void generateNormal() {
        if (this.vertices.size() < 3) {
            return;
        }
        Point3f p1 = (Point3f)this.vertices.get(0);
        Point3f p2 = (Point3f)this.vertices.get(1);
        Point3f p3 = (Point3f)this.vertices.get(2);
        Point3f ref1 = new Point3f();
        Point3f ref2 = new Point3f();
        ref1.add((Tuple3f)p1);
        ref1.sub((Tuple3f)p2);
        ref2.add((Tuple3f)p3);
        ref2.sub((Tuple3f)p2);
        float[] norm = VectorOperations.getNormalVector(new float[]{ref1.x, ref1.y, ref1.z}, new float[]{ref2.x, ref2.y, ref2.z});
        this.setNormalVector(new Point3f(norm));
    }

    public void generateOrigin() {
        if (this.vertices.size() == 0) {
            return;
        }
        this.setOrigin(new Point3f((Point3f)this.vertices.get(0)));
    }

    public void addVertex(Point3f vertex) {
        int i = 0;
        while (i < this.vertices.size()) {
            Point3f tmp = (Point3f)this.vertices.get(i);
            if (tmp.epsilonEquals((Tuple3f)vertex, this.verySmall)) {
                return;
            }
            ++i;
        }
        this.vertices.addElement(vertex);
    }

    public void setVertexAt(Point3f vertex, int i) {
        this.vertices.setElementAt(vertex, i);
    }

    public void removeVertex(Point3f vertex) {
        int i = 0;
        while (i < this.vertices.size()) {
            Point3f p3f = (Point3f)this.vertices.get(i);
            if (p3f.epsilonEquals((Tuple3f)vertex, this.verySmall)) {
                this.vertices.removeElementAt(i);
            }
            ++i;
        }
    }

    public void replaceVertex(Point3f from, Point3f to) {
        int i = 0;
        while (i < this.vertices.size()) {
            Point3f p3f = (Point3f)this.vertices.get(i);
            if (p3f.epsilonEquals((Tuple3f)from, this.verySmall)) {
                this.vertices.set(i, to);
                return;
            }
            ++i;
        }
        this.vertices.add(to);
    }

    public void removeVertex(int i) {
        this.vertices.remove(i);
    }

    public Point3f[] getVertices() {
        Object[] ret = new Point3f[this.vertices.size()];
        this.vertices.copyInto(ret);
        return ret;
    }

    public void sortVertices() {
        if (this.vertices == null || this.vertices.size() <= 2) {
            return;
        }
        this.vertices.trimToSize();
        Object[] verts = new Point3f[this.vertices.size()];
        this.vertices.copyInto(verts);
        Point3f[] ordered = Sorter.radiallyClockWise((Point3f[])verts);
        if (ordered != null && ordered.length >= 2) {
            int i = 0;
            while (i < ordered.length) {
                this.vertices.set(i, ordered[i]);
                ++i;
            }
        } else {
            this.logger.error((Object)"invalid vertices!!");
        }
    }

    public boolean hasSide(Side side) {
        Point3f sp1 = side.getPoint1();
        Point3f sp2 = side.getPoint2();
        int i = 0;
        while (i < this.vertices.size() - 1) {
            int j = i + 1;
            while (j < this.vertices.size()) {
                Point3f lp1 = (Point3f)this.vertices.get(i);
                Point3f lp2 = (Point3f)this.vertices.get(j);
                if (lp1.epsilonEquals((Tuple3f)sp1, this.verySmall) && lp2.epsilonEquals((Tuple3f)sp2, this.verySmall) || lp2.epsilonEquals((Tuple3f)sp1, this.verySmall) && lp1.epsilonEquals((Tuple3f)sp2, this.verySmall)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public Side[] getSides() {
        if (this.vertices == null || this.vertices.size() < 2) {
            return null;
        }
        Vector<Side> sides = new Vector<Side>();
        int i = 0;
        while (i < this.vertices.size()) {
            int i2 = i + 1;
            if (i2 == this.vertices.size()) {
                i2 = 0;
            }
            Point3f p3f1 = (Point3f)this.vertices.get(i);
            Point3f p3f2 = (Point3f)this.vertices.get(i2);
            Side side = new Side(p3f1, p3f2);
            sides.addElement(side);
            ++i;
        }
        Object[] ret = new Side[sides.size()];
        sides.copyInto(ret);
        return ret;
    }

    public boolean hasVertex(Point3f v) {
        int i = 0;
        while (i < this.vertices.size()) {
            Point3f p = (Point3f)this.vertices.get(i);
            if (p.epsilonEquals((Tuple3f)v, this.verySmall)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        String ret = "";
        ret = String.valueOf(ret) + "vertices: ";
        int i = 0;
        while (i < this.vertices.size()) {
            ret = String.valueOf(ret) + System.getProperty("line.separator") + this.vertices.get(i).toString();
            ++i;
        }
        return ret;
    }
}

