/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.common.ElementDef;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Font;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;

public class J3DDataManager {
    private Logger logger = Logger.getLogger((String)J3DDataManager.class.getName());
    public static final int DARKER = 0;
    public static final int BRIGHTER = 1;
    public static String[] ATOM_RENDERING_METHODS = new String[]{"sphere", "filled_circle", "null"};
    private String atomRenderingMethod = ATOM_RENDERING_METHODS[0];
    public static int EDGE_OF_CELL = 0;
    public static int CENTER_OF_CELL = 1;
    private double bondfactor;
    private float bgr;
    private float bgg;
    private float bgb;
    private int numnodes;
    private int numnodesbond;
    private float[] bondcolor;
    private double bondwidth;
    private float[] bgcolor;
    private float scale;
    private float scaleatom;
    private boolean drawcell;
    private float cellwidth;
    private int numnodescell;
    private float cellr;
    private float cellg;
    private float cellb;
    private float[] cellcolor;
    private boolean gettext;
    private boolean legend;
    private boolean axis;
    private String[] label;
    private boolean bmobile;
    private int labelOffset;
    private GlobalProperties propManager;
    private int mobilityDisplayMode;
    private Font font;
    private Color3f fontColor = new Color3f(0.0f, 0.0f, 0.0f);
    private J3DPanel mp;
    private int shiftPolicy;
    private boolean useWireForCell = false;
    private boolean wireForBond = false;
    private ElementInfo einfo;

    public J3DDataManager() {
        this.propManager = PropertiesManager.getGlobalProperties(1);
        this.setBondFactor(1.06);
        this.setBgColor(0.6f, 0.6f, 0.6f);
        this.setBondColor(0.0f, 0.2f, 0.2f);
        this.setBondWidth(0.01);
        this.setScale(1.0f);
        this.setNumNodesAtom(10);
        this.setNumNodesBond(10);
        this.setScaleAtom(1.0f);
        this.setCellWidth(0.005f);
        this.setNumNodesCell(10);
        this.setCellColor(1.0f, 1.0f, 1.0f);
        this.setDrawCell(false);
        this.setText(false);
        this.setMobile(false);
        this.setLabelOffset(3);
        this.setMobilityDisplayMode(0);
        this.setFont(new Font("Helvetica", 0, 18));
        this.readACVPrefs();
        this.readElementInfo();
        this.logger.debug((Object)"initialized J3DDataManager.");
    }

    public void setAtomRenderingMethod(String method) {
        this.atomRenderingMethod = method;
    }

    public String getAtomRenderingMethod() {
        return this.atomRenderingMethod;
    }

    public void setDefaults() {
        this.setBondFactor(1.06);
        this.setBgColor(0.6f, 0.6f, 0.6f);
        this.setScale(1.0f);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontColor(Color3f fontColor) {
        this.fontColor = fontColor;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("Helvetica", 0, 18);
        }
        return this.font;
    }

    public Color3f getFontColor() {
        if (this.fontColor == null) {
            this.fontColor = new Color3f(0.0f, 0.0f, 0.0f);
        }
        return this.fontColor;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScaleAtom(float scaleatom) {
        this.scaleatom = scaleatom;
    }

    public float getScaleAtom() {
        return this.scaleatom;
    }

    public void setBgColor(float bgr, float bgg, float bgb) {
        this.bgr = bgr;
        this.bgg = bgg;
        this.bgb = bgb;
        this.bgcolor = new float[3];
        this.bgcolor[0] = this.bgr;
        this.bgcolor[1] = this.bgg;
        this.bgcolor[2] = this.bgb;
    }

    public float[] getBgColor() {
        return this.bgcolor;
    }

    public void setBondFactor(double bondfactor) {
        this.bondfactor = bondfactor;
    }

    public double getBondFactor() {
        return this.bondfactor;
    }

    public int getNumEl() {
        return this.einfo.getElementDef().length;
    }

    public void setElement(String element, int i) {
        this.einfo.getElementDef()[i].setSymbol(element);
    }

    public String[] getElement() {
        String[] ret = new String[this.einfo.getElementDef().length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = this.einfo.getElementDef()[i].getSymbol();
            ++i;
        }
        return ret;
    }

    public int getShiftPolicy() {
        return this.shiftPolicy;
    }

    public void setUseWireForBond(boolean wireForBond) {
        this.wireForBond = wireForBond;
    }

    public boolean getUseWireForBond() {
        return this.wireForBond;
    }

    public void setCovRad(double covrad, int i) {
        this.einfo.getElementDef()[i].setCovalentRadius(covrad);
    }

    public double[] getCovRad() {
        double[] ret = new double[this.einfo.getElementDef().length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = this.einfo.getElementDef()[i].getCovalentRadius();
            ++i;
        }
        return ret;
    }

    public void setRad(float rad, int i) {
        this.einfo.getElementDef()[i].setRadius(rad);
    }

    public float[] getRad() {
        float[] ret = new float[this.einfo.getElementDef().length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = this.einfo.getElementDef()[i].getRadius();
            ++i;
        }
        return ret;
    }

    public void setColor(float[] color, int i) {
        this.einfo.getElementDef()[i].setColor(color);
    }

    public float[][] getColor() {
        float[][] ret = new float[this.einfo.getElementDef().length][3];
        int i = 0;
        while (i < ret.length) {
            ret[i] = this.einfo.getElementDef()[i].getColor();
            ++i;
        }
        return ret;
    }

    public void setNumNodesAtom(int numnodes) {
        this.numnodes = numnodes;
    }

    public int getNumNodesAtom() {
        return this.numnodes;
    }

    public void setNumNodesBond(int numnodesbond) {
        this.numnodesbond = numnodesbond;
    }

    public int getNumNodesBond() {
        return this.numnodesbond;
    }

    public void setBondColor(float bndcolorr, float bndcolorb, float bndcolorg) {
        this.bondcolor = new float[3];
        this.bondcolor[0] = bndcolorr;
        this.bondcolor[1] = bndcolorb;
        this.bondcolor[2] = bndcolorg;
    }

    public float[] getBondColor() {
        return this.bondcolor;
    }

    public void setBondWidth(double bondwidth) {
        this.bondwidth = bondwidth;
    }

    public double getBondWidth() {
        return this.bondwidth;
    }

    public void setDrawCell(boolean drawcell) {
        this.drawcell = drawcell;
    }

    public boolean getDrawCell() {
        return this.drawcell;
    }

    public void setNumNodesCell(int numnodescell) {
        this.numnodescell = numnodescell;
    }

    public int getNumNodesCell() {
        return this.numnodescell;
    }

    public void setCellWidth(float cellwidth) {
        this.cellwidth = cellwidth;
    }

    public float getCellWidth() {
        return this.cellwidth;
    }

    public void setCellColor(float cellr, float cellg, float cellb) {
        this.cellcolor = new float[3];
        this.cellcolor[0] = cellr;
        this.cellcolor[1] = cellg;
        this.cellcolor[2] = cellb;
    }

    public float[] getCellColor() {
        return this.cellcolor;
    }

    public void setText(boolean gettext) {
        this.gettext = gettext;
    }

    public boolean getText() {
        return this.gettext;
    }

    public void setLabel(String[] label) {
        this.label = label;
    }

    public String[] getLabel() {
        return this.label;
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
    }

    public boolean getLegend() {
        return this.legend;
    }

    public void setAxis(boolean axis) {
        this.axis = axis;
    }

    public boolean getAxis() {
        return this.axis;
    }

    public void setMobile(boolean bmobile) {
        this.bmobile = bmobile;
    }

    public boolean getMobile() {
        return this.bmobile;
    }

    public void setMobilityDisplayMode(int mobilityDisplayMode) {
        this.mobilityDisplayMode = mobilityDisplayMode;
    }

    public int getMobilityDisplayMode() {
        return this.mobilityDisplayMode;
    }

    public void setLabelOffset(int labelOffset) {
        this.labelOffset = labelOffset;
    }

    public int getLabelOffset() {
        return this.labelOffset;
    }

    public void setUseWireForCell(boolean wc) {
        this.useWireForCell = wc;
    }

    public boolean getUseWireForCell() {
        return this.useWireForCell;
    }

    private void readACVPrefs() {
        this.setBondFactor(Double.parseDouble(this.propManager.getProperty("bondfactor").trim()));
        this.setBgColor(Float.parseFloat(this.propManager.getProperty("bgcolor_r").trim()), Float.parseFloat(this.propManager.getProperty("bgcolor_g").trim()), Float.parseFloat(this.propManager.getProperty("bgcolor_b").trim()));
        this.setBondColor(Float.parseFloat(this.propManager.getProperty("bondcolor_r").trim()), Float.parseFloat(this.propManager.getProperty("bondcolor_g").trim()), Float.parseFloat(this.propManager.getProperty("bondcolor_b").trim()));
        this.setBondWidth(Double.parseDouble(this.propManager.getProperty("bondwidth").trim()));
        this.setUseWireForBond(new Boolean(this.propManager.getProperty("usewireforbond").trim()));
        this.setUseWireForCell(new Boolean(this.propManager.getProperty("usewireforcell").trim()));
        this.setScale(Float.parseFloat(this.propManager.getProperty("scale").trim()));
        this.setNumNodesAtom(Integer.parseInt(this.propManager.getProperty("numnodesatom").trim()));
        this.setNumNodesBond(Integer.parseInt(this.propManager.getProperty("numnodesbond").trim()));
        this.setScaleAtom(Float.parseFloat(this.propManager.getProperty("scaleatom").trim()));
        this.setDrawCell(Boolean.valueOf(this.propManager.getProperty("drawcell").trim()));
        this.setCellWidth(Float.parseFloat(this.propManager.getProperty("cellwidth").trim()));
        this.setCellColor(Float.parseFloat(this.propManager.getProperty("cellcolor_r").trim()), Float.parseFloat(this.propManager.getProperty("cellcolor_g").trim()), Float.parseFloat(this.propManager.getProperty("cellcolor_b").trim()));
        this.setNumNodesCell(Integer.parseInt(this.propManager.getProperty("numnodescell").trim()));
        this.setText(Boolean.valueOf(this.propManager.getProperty("setlabel").trim()));
        this.setLegend(Boolean.valueOf(this.propManager.getProperty("setlegend").trim()));
        this.setAxis(Boolean.valueOf(this.propManager.getProperty("setaxis").trim()));
        this.setMobile(Boolean.valueOf(this.propManager.getProperty("showmobility").trim()));
        this.setLabelOffset(Integer.parseInt(this.propManager.getProperty("labeloffset").trim()));
        this.setMobilityDisplayMode(Integer.parseInt(this.propManager.getProperty("mobilitydisplaymode").trim()));
        this.setFont(new Font(this.propManager.getProperty("font_name"), Integer.parseInt(this.propManager.getProperty("font_style")), Integer.parseInt(this.propManager.getProperty("font_size"))));
        String[] sfontColor = this.propManager.getProperty("font_color").split(",");
        this.setFontColor(new Color3f(Float.parseFloat(sfontColor[0]), Float.parseFloat(sfontColor[1]), Float.parseFloat(sfontColor[2])));
        this.setAtomRenderingMethod(this.propManager.getProperty("atomobject"));
        try {
            this.setShiftPolicy(Integer.parseInt(this.propManager.getProperty("atom_shift_policy")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShiftPolicy(int shiftPolicy) {
        this.shiftPolicy = shiftPolicy;
    }

    private void readElementInfo() {
        this.einfo = ElementInfo.getElementInfo();
    }

    public ElementInfo getEInfo() {
        return this.einfo;
    }

    public void addElementInfo(String nameNew, float radiusNew, double covalentradiusNew, float[] elementcolorNew) {
        ElementDef def = new ElementDef();
        def.setSymbol(nameNew);
        def.setRadius(radiusNew);
        def.setCovalentRadius(covalentradiusNew);
        def.setColor(elementcolorNew);
        this.einfo.addElementDef(def);
    }

    public void writeACVData() {
        this.writeACVPrefs();
        this.writeElemInfo();
    }

    private void writeACVPrefs() {
        this.propManager.setProperty("bgcolor_r", Float.toString(this.getBgColor()[0]));
        this.propManager.setProperty("bgcolor_g", Float.toString(this.getBgColor()[1]));
        this.propManager.setProperty("bgcolor_b", Float.toString(this.getBgColor()[2]));
        this.propManager.setProperty("bondfactor", Double.toString(this.getBondFactor()));
        this.propManager.setProperty("bondwidth", Double.toString(this.getBondWidth()));
        this.propManager.setProperty("usewireforbond", String.valueOf(this.getUseWireForBond()));
        this.propManager.setProperty("scale", Float.toString(this.getScale()));
        this.propManager.setProperty("scaleatom", Float.toString(this.getScaleAtom()));
        this.propManager.setProperty("numnodesatom", Integer.toString(this.getNumNodesAtom()));
        this.propManager.setProperty("numnodesbond", Integer.toString(this.getNumNodesBond()));
        this.propManager.setProperty("numnodescell", Integer.toString(this.getNumNodesCell()));
        this.propManager.setProperty("drawcell", Boolean.toString(this.getDrawCell()));
        this.propManager.setProperty("usewireforcell", String.valueOf(this.getUseWireForCell()));
        this.propManager.setProperty("cellwidth", Float.toString(this.getCellWidth()));
        this.propManager.setProperty("cellcolor_r", Float.toString(this.getCellColor()[0]));
        this.propManager.setProperty("cellcolor_g", Float.toString(this.getCellColor()[1]));
        this.propManager.setProperty("cellcolor_b", Float.toString(this.getCellColor()[2]));
        this.propManager.setProperty("setlabel", Boolean.toString(this.getText()));
        this.propManager.setProperty("setaxis", Boolean.toString(this.getAxis()));
        this.propManager.setProperty("setlegend", Boolean.toString(this.getLegend()));
        this.propManager.setProperty("showmobility", Boolean.toString(this.getMobile()));
        this.propManager.setProperty("bondcolor_r", Float.toString(this.getBondColor()[0]));
        this.propManager.setProperty("bondcolor_g", Float.toString(this.getBondColor()[1]));
        this.propManager.setProperty("bondcolor_b", Float.toString(this.getBondColor()[2]));
        this.propManager.setProperty("labeloffset", Integer.toString(this.getLabelOffset()));
        this.propManager.setProperty("mobilitydisplaymode", Integer.toString(this.getMobilityDisplayMode()));
        this.font = this.getFont();
        this.propManager.setProperty("font_name", this.font.getName());
        this.propManager.setProperty("font_style", String.valueOf(this.font.getStyle()));
        this.propManager.setProperty("font_syze", String.valueOf(this.font.getSize()));
        this.propManager.setProperty("font_color", String.valueOf(String.valueOf(this.fontColor.x)) + "," + String.valueOf(this.fontColor.y) + "," + String.valueOf(this.fontColor.z));
        this.propManager.setProperty("atomobject", this.atomRenderingMethod);
        this.propManager.storeProperty();
    }

    private void writeElemInfo() {
        this.einfo.toDisk();
    }

    public void setParent(J3DPanel mp) {
        this.mp = mp;
    }

    public J3DPanel getParent() {
        return this.mp;
    }
}

