/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ChaseCanvas3D;
import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.JCanvas3DWrapper;
import ciss.phase_viewer.acviewer.PluginParser;
import ciss.phase_viewer.acviewer.vrml.VRMLExportFileType;
import ciss.phase_viewer.acviewer.vrml.VRMLExporter;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.common.Drawable;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.graph.export.EPSExportFileType;
import ciss.phase_viewer.graph.export.PDFExportFileType;
import ciss.phase_viewer.graph.export.SVGExportFileType;
import ciss.phase_viewer.imageviewer.ImagePrinter;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentFloat;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.VirtualUniverse;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;
import org.freehep.graphicsio.exportchooser.ImageExportFileType;
import org.freehep.util.export.ExportDialog;
import org.freehep.util.export.ExportFileType;

public abstract class BaseJ3DPanel
extends InternalFrameChase
implements Drawable,
J3DPanel {
    protected static Dimension defaultSize = new Dimension(512, 540);
    private Logger logger = Logger.getLogger((String)BaseJ3DPanel.class.getName());
    protected BranchGroup rootBranch;
    protected Canvas3D canvas3d;
    protected SimpleUniverse simpleU;
    protected Vector associatedGUIs = new Vector();
    protected JLabel exportLabel;
    protected PluginParser pluginParser;
    protected String parentDir = System.getProperty("user.home");
    protected J3DDataManager dataManager;
    protected boolean doRedraw = true;
    protected GlobalProperties prop = PropertiesManager.getGlobalProperties(1);
    private static boolean USE_JCANVAS3D = new Boolean(PropertiesManager.getGlobalProperties(1).getProperty("canvas3d_use_jcanvas3d"));
    protected JPanel jCanvas3D;

    public BaseJ3DPanel(String title, Dimension initSize) {
        super(title, true, true, true, true, initSize, 0, false);
        this.initBaseJ3DPanel();
    }

    protected String getPluginPath() {
        return "/ciss/phase_viewer/acviewer/plugins.xml";
    }

    public static boolean useJCanvas3D() {
        return new Boolean(PropertiesManager.getGlobalProperties(1).getProperty("canvas3d_use_jcanvas3d"));
    }

    private GraphicsConfiguration getGC() {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setStencilSize(0);
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
    }

    private void initBaseJ3DPanel() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent ev) {
                BaseJ3DPanel.this.destroy();
            }
        });
        if (BaseJ3DPanel.useJCanvas3D()) {
            JCanvas3DWrapper wra = new JCanvas3DWrapper();
            this.jCanvas3D = wra.getPanel();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(this.jCanvas3D);
            this.canvas3d = wra.getCanvas3D();
        } else {
            try {
                GraphicsConfiguration gc = SimpleUniverse.getPreferredConfiguration();
                if (gc == null) {
                    gc = this.getGC();
                }
                if (gc == null) {
                    System.out.println("gc is still null");
                }
                this.canvas3d = new ChaseCanvas3D(gc);
                this.jCanvas3D = new JPanel();
                this.jCanvas3D.add((Component)this.canvas3d);
                Dimension canvsize = this.getSize();
                canvsize.height -= 90;
                canvsize.width -= 10;
                this.canvas3d.setSize(canvsize);
                this.getContentPane().add((Component)this.canvas3d);
                if (Utils.parseJREVersion() < 170) {
                    this.setLayer(new Integer(1));
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.simpleU = new SimpleUniverse(this.canvas3d);
        this.simpleU.getViewingPlatform().setNominalViewingTransform();
        VirtualUniverse.setJ3DThreadPriority((int)10);
        this.dataManager = new J3DDataManager();
        this.dataManager.setParent(this);
        if (BaseJ3DPanel.useJCanvas3D()) {
            this.jCanvas3D.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    BaseJ3DPanel.this.jCanvas3D.requestFocusInWindow();
                }
            });
        } else {
            this.jCanvas3D.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
        }
    }

    @Override
    public BranchGroup getRootBranch() {
        return this.rootBranch;
    }

    @Override
    public PluginParser getPluginParser() {
        if (this.pluginParser == null) {
            this.pluginParser = new PluginParser(this, this.getPluginPath());
        }
        return this.pluginParser;
    }

    @Override
    public boolean isHeavyWeight() {
        return true;
    }

    @Override
    public SimpleUniverse getUniverse() {
        return this.simpleU;
    }

    @Override
    public void destroy() {
        if (this.associatedGUIs != null) {
            int i = 0;
            while (i < this.associatedGUIs.size()) {
                Container window;
                Object editor = this.associatedGUIs.get(i);
                if (editor instanceof JInternalFrame) {
                    window = (JInternalFrame)this.associatedGUIs.get(i);
                    if (window != null) {
                        ((JInternalFrame)window).dispose();
                    }
                } else if (editor instanceof JFrame && (window = (JFrame)this.associatedGUIs.get(i)) != null) {
                    ((Window)window).dispose();
                }
                ++i;
            }
        }
        try {
            this.removeFromDesktop();
            this.removeAll();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected void removeFromDesktop() {
        if (this.rootBranch != null) {
            this.rootBranch.detach();
        }
        ((ChaseTransformGroup)this.getRootTransform()).cleanUp();
        this.rootBranch = null;
        if (this.canvas3d != null) {
            try {
                this.canvas3d.stopRenderer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.simpleU != null) {
            this.simpleU.removeAllLocales();
            this.simpleU.getViewer().setViewingPlatform(null);
            this.simpleU.getViewer().getView().removeCanvas3D(this.canvas3d);
            this.simpleU.cleanup();
        }
        this.canvas3d = null;
        this.simpleU = null;
        this.postCleanUp();
    }

    @Override
    public void postCleanUp() {
    }

    @Override
    public Vector getDisposeOnExit() {
        return this.associatedGUIs;
    }

    @Override
    public void addDisposeOnExit(Window window) {
        int version = Utils.parseJREVersion();
        if (!BaseJ3DPanel.useJCanvas3D() && version < 170) {
            Point pos = this.getLocation();
            pos.x += this.getSize().width;
            window.setLocation(pos);
        }
        this.associatedGUIs.addElement(window);
    }

    @Override
    public void addDisposeOnExit(InternalFrameChase window) {
        int version = Utils.parseJREVersion();
        if (!BaseJ3DPanel.useJCanvas3D() && version < 170) {
            Point pos = this.getLocation();
            pos.x += this.getSize().width;
            window.setLocation(pos);
        }
        this.associatedGUIs.addElement(window);
    }

    @Override
    public void export(String fileName) throws IOException {
        this.doExport(fileName);
    }

    @Override
    public void export() throws IOException {
        this.doExport("");
    }

    protected String getExportFileNamePrefix() {
        return "atomic_config";
    }

    @Override
    public String getParentDirectory() {
        return this.parentDir;
    }

    @Override
    public void doExportVRML(String fileName) throws IOException {
        VRMLExporter exp = new VRMLExporter(this);
        exp.doExport(fileName);
    }

    public void print() {
        BufferedImage image = this.createImage();
        ImagePrinter printer = new ImagePrinter(image);
        printer.printImage();
    }

    private void doExport(String fileName) throws IOException {
        BufferedImage image = this.createImage();
        if (fileName.trim().length() == 0) {
            int width = this.canvas3d.getSize().width;
            int height = this.canvas3d.getSize().height;
            ImageIcon icon = new ImageIcon(image);
            this.exportLabel = new JLabel(icon);
            this.exportLabel.setSize(width, height);
            ImageExportFileType png = ImageExportFileType.getInstance((String)"png");
            ImageExportFileType jpg = ImageExportFileType.getInstance((String)"jpg");
            EPSExportFileType eps = new EPSExportFileType(this);
            PDFExportFileType pdfexport = new PDFExportFileType(this);
            SVGExportFileType svgexport = new SVGExportFileType(this);
            VRMLExportFileType vrmlexport = new VRMLExportFileType(this);
            ExportDialog exportD = new ExportDialog("export", false);
            Properties prop = new Properties();
            prop.setProperty("org.freehep.util.export.ExportDialog.SaveAsFile", String.valueOf(this.parentDir) + File.separator + this.getExportFileNamePrefix());
            exportD.setUserProperties(prop);
            exportD.addExportFileType((ExportFileType)png);
            exportD.addExportFileType((ExportFileType)jpg);
            exportD.addExportFileType((ExportFileType)pdfexport);
            exportD.addExportFileType((ExportFileType)svgexport);
            exportD.addExportFileType((ExportFileType)vrmlexport);
            exportD.showExportDialog((Component)this, "export view as ...", (Component)this.exportLabel, "atomic_config");
        } else {
            ImageIO.write((RenderedImage)image, "jpg", new File(fileName));
            this.logger.info((Object)("exported image to file: " + fileName));
        }
        image = null;
    }

    @Override
    public void draw(Graphics2D g2d, Rectangle2D rec) {
        this.exportLabel.print(g2d);
    }

    @Override
    public Canvas3D getCanvas() {
        return this.canvas3d;
    }

    public JPanel getJCanvas3D() {
        return this.jCanvas3D;
    }

    private BufferedImage createImage() {
        int width = this.canvas3d.getSize().width;
        int height = this.canvas3d.getSize().height;
        BufferedImage bi = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bi);
        DepthComponentFloat dcf = new DepthComponentFloat(width, height);
        Raster readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, (DepthComponent)dcf);
        GraphicsContext3D gc3d = this.canvas3d.getGraphicsContext3D();
        gc3d.flush(true);
        gc3d.readRaster(readRaster);
        ImageComponent2D ic = readRaster.getImage();
        return ic.getImage();
    }

    @Override
    public J3DDataManager getJ3DDataManager() {
        return this.dataManager;
    }

    @Override
    public boolean doRedraw() {
        return this.doRedraw;
    }

    @Override
    public void doRedraw(boolean doRedraw) {
        this.doRedraw = doRedraw;
    }

    @Override
    public void prepareRedraw() {
        try {
            this.canvas3d.getView().stopView();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setProjectionPolicy(int projectionPolicy) {
        this.canvas3d.getView().setProjectionPolicy(projectionPolicy);
    }

    @Override
    public int getProjectionPolicy() {
        return this.canvas3d.getView().getProjectionPolicy();
    }

    @Override
    public void postRedraw() {
        try {
            this.canvas3d.getView().startView();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public GlobalProperties getJ3DProperties() {
        return this.prop;
    }

    @Override
    public abstract VolumetricData[] getAssociatedVolumetricData();

    @Override
    public abstract TransformGroup getRootTransform();

    @Override
    public TransformGroup[] getRotatingTransform() {
        return new TransformGroup[]{this.getRootTransform()};
    }

    @Override
    public abstract boolean supportsFrame();
}

