/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.AtomData;
import AbinitMp.Common.ResidueData;
import java.util.Vector;

public class InDistanceData {
    public ResidueData residueData;
    public AtomData atomData;
    public Vector atomTable;
    public float distance;
    public boolean list;
    public boolean fromAtom;
    public boolean displayAtom;
    public float xMin;
    public float xMax;
    public float yMin;
    public float yMax;
    public float zMin;
    public float zMax;

    public InDistanceData(AtomData atomData, ResidueData residueData, Vector vector, boolean bl, boolean bl2, boolean bl3, float f) {
        this.atomData = atomData;
        this.residueData = residueData;
        this.atomTable = vector;
        this.displayAtom = bl;
        this.list = bl2;
        this.fromAtom = bl3;
        this.distance = f;
        if (!bl3) {
            this.setBoundingBox();
        }
        this.distance = f * f;
    }

    public void setBoundingBox() {
        AtomData atomData = (AtomData)this.atomTable.get(this.residueData.startNo);
        this.xMin = atomData.x;
        this.xMax = atomData.x;
        this.yMin = atomData.y;
        this.yMax = atomData.y;
        this.zMin = atomData.z;
        this.zMax = atomData.z;
        for (int i = this.residueData.startNo + 1; i <= this.residueData.endNo; ++i) {
            atomData = (AtomData)this.atomTable.get(i);
            this.xMin = Math.min(atomData.x, this.xMin);
            this.xMax = Math.max(atomData.x, this.xMax);
            this.yMin = Math.min(atomData.y, this.yMin);
            this.yMax = Math.max(atomData.y, this.yMax);
            this.zMin = Math.min(atomData.z, this.zMin);
            this.zMax = Math.max(atomData.z, this.zMax);
        }
        this.xMin -= this.distance;
        this.xMax += this.distance;
        this.yMin -= this.distance;
        this.yMax += this.distance;
        this.zMin -= this.distance;
        this.zMax += this.distance;
    }

    public boolean isInDistance(AtomData atomData) {
        if (this.fromAtom) {
            float f = this.atomData.x - atomData.x;
            float f2 = this.atomData.y - atomData.y;
            float f3 = this.atomData.z - atomData.z;
            if (this.distance > f * f + f2 * f2 + f3 * f3) {
                return true;
            }
        } else if (this.xMin < atomData.x && atomData.x < this.xMax && this.yMin < atomData.y && atomData.y < this.yMax && this.zMin < atomData.z && atomData.z < this.zMax) {
            for (int i = this.residueData.startNo; i <= this.residueData.endNo; ++i) {
                AtomData atomData2 = (AtomData)this.atomTable.get(i);
                float f = atomData2.x - atomData.x;
                float f4 = atomData2.y - atomData.y;
                float f5 = atomData2.z - atomData.z;
                if (!(this.distance > f * f + f4 * f4 + f5 * f5)) continue;
                return true;
            }
        }
        return false;
    }
}

