/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.graphicsio.swf.Gradient;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class FillStyle {
    public static final int SOLID = 0;
    public static final int LINEAR_GRADIENT = 16;
    public static final int RADIAL_GRADIENT = 18;
    public static final int TILED_BITMAP = 64;
    public static final int CLIPPED_BITMAP = 65;
    private int type;
    private Color color;
    private Color endColor;
    private AffineTransform matrix;
    private AffineTransform endMatrix;
    private Gradient[] gradient;
    private int bitmap;

    public FillStyle(Color color) {
        this.type = 0;
        this.color = color;
    }

    public FillStyle(Color color, Color endColor) {
        this(color);
        this.endColor = endColor;
    }

    public FillStyle(Gradient[] gradient, boolean linear, AffineTransform matrix) {
        this.type = linear ? 16 : 18;
        this.gradient = gradient;
        this.matrix = matrix;
    }

    public FillStyle(Gradient[] gradient, boolean linear, AffineTransform matrix, AffineTransform endMatrix) {
        this(gradient, linear, matrix);
        this.endMatrix = endMatrix;
    }

    public FillStyle(int bitmap, boolean tiled, AffineTransform matrix) {
        this.type = tiled ? 64 : 65;
        this.bitmap = bitmap;
        this.matrix = matrix;
    }

    public FillStyle(int bitmap, boolean tiled, AffineTransform matrix, AffineTransform endMatrix) {
        this(bitmap, tiled, matrix);
        this.endMatrix = endMatrix;
    }

    public FillStyle(SWFInputStream input, boolean isMorphStyle, boolean hasAlpha) throws IOException {
        this.type = input.readUnsignedByte();
        switch (this.type) {
            case 0: {
                this.color = input.readColor(hasAlpha);
                if (!isMorphStyle) break;
                this.endColor = input.readColor(hasAlpha);
                break;
            }
            case 16: 
            case 18: {
                this.matrix = input.readMatrix();
                if (isMorphStyle) {
                    this.endMatrix = input.readMatrix();
                }
                int gradientCount = input.readUnsignedByte();
                this.gradient = new Gradient[gradientCount];
                for (int i = 0; i < gradientCount; ++i) {
                    this.gradient[i] = new Gradient(input, hasAlpha, isMorphStyle);
                }
                break;
            }
            case 64: 
            case 65: {
                this.bitmap = input.readUnsignedShort();
                this.matrix = input.readMatrix();
                if (!isMorphStyle) break;
                this.endMatrix = input.readMatrix();
                break;
            }
            default: {
                System.err.println("FillStyle type " + this.type + " not implemented.");
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        swf.writeUnsignedByte(this.type);
        switch (this.type) {
            case 0: {
                swf.writeColor(this.color, hasAlpha || this.endColor != null);
                if (this.endColor == null) break;
                swf.writeColor(this.endColor, true);
                break;
            }
            case 16: 
            case 18: {
                swf.writeMatrix(this.matrix);
                if (this.endMatrix != null) {
                    swf.writeMatrix(this.endMatrix);
                }
                swf.writeUnsignedByte(this.gradient.length);
                for (int i = 0; i < this.gradient.length; ++i) {
                    this.gradient[i].write(swf, hasAlpha);
                }
                break;
            }
            case 64: 
            case 65: {
                swf.writeUnsignedShort(this.bitmap);
                swf.writeMatrix(this.matrix);
                if (this.endMatrix == null) break;
                swf.writeMatrix(this.endMatrix);
                break;
            }
            default: {
                System.err.println("FillStyle type " + this.type + " not implemented.");
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        switch (this.type) {
            case 0: {
                s.append("Solid: ");
                s.append(this.color);
                if (this.endColor == null) break;
                s.append("; " + this.endColor);
                break;
            }
            case 16: 
            case 18: {
                s.append("Gradient: ");
                for (int i = 0; i < this.gradient.length; ++i) {
                    s.append(this.gradient[i]);
                    s.append("; ");
                }
                s.append(this.matrix);
                if (this.endMatrix == null) break;
                s.append("; " + this.endMatrix);
                break;
            }
            case 64: 
            case 65: {
                s.append("BitMap: ");
                s.append(this.bitmap);
                s.append(", ");
                s.append(this.matrix);
                if (this.endMatrix == null) break;
                s.append("; " + this.endMatrix);
                break;
            }
            default: {
                s.append("Unknown Type:");
                s.append(this.type);
            }
        }
        return s.toString();
    }
}

