/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.projectdirbrowser;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jp.advancesoft.chase.main.PluginLoader;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.ProjectManipulator;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ProjectDirBrowserObject {
    private Logger logger = Logger.getLogger((String)ProjectDirBrowserObject.class.getName());
    private String text;
    private Icon icon;
    private Icon icon_open;

    public ProjectDirBrowserObject(ProjectInfo proj) {
        this.init(proj);
    }

    private void init(ProjectInfo proj) {
        String type = proj.getProjectType();
        URL projurl = ProjectDirBrowserObject.class.getResource(ProjectManipulator.PROJECT_MANIPULATOR_XML_PATH);
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(projurl);
        }
        catch (JDOMException jde) {
            this.logger.error((Object)("failed to parse " + projurl));
            this.logger.error((Object)"unrecoverable error... contact AdvanceSoft.");
        }
        catch (IOException ioe) {
            this.logger.error((Object)("failed to parse " + projurl));
            this.logger.error((Object)"unrecoverable error... contact AdvanceSoft.");
        }
        try {
            Element elem = doc.getRootElement();
            if (!elem.getName().equals("root")) {
                this.logger.error((Object)"invalid ProjectSpecification file... contact AdvanceSoft.");
            }
            List list = elem.getChildren("project");
            String iconpath = null;
            String iconpath_open = null;
            for (int i = 0; i < list.size(); ++i) {
                Element element = (Element)list.get(i);
                String name = element.getChildTextTrim("name");
                if (!name.equals(type)) continue;
                iconpath = element.getChildTextTrim("iconpath");
                iconpath_open = element.getChildTextTrim("iconpath_open");
                break;
            }
            this.logger.debug((Object)("iconpath: " + iconpath + " iconpath_open: " + iconpath_open));
            this.text = proj.getProjectName();
            PluginLoader loader = new PluginLoader();
            URL res = null;
            URL res_open = null;
            try {
                res = loader.getResource(iconpath);
                res_open = loader.getResource(iconpath_open);
            }
            catch (Exception ex) {
                this.logger.error((Object)"failed to resolve icon path.");
            }
            this.icon = new ImageIcon(res);
            this.icon_open = new ImageIcon(res_open);
        }
        catch (Exception ex) {
            this.logger.error((Object)"error in loading plugin.");
        }
    }

    public String getText() {
        return this.text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getOpenIcon() {
        return this.icon_open;
    }

    public String toString() {
        return this.text;
    }
}

