/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis;

import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.atomcoord.Importers;
import jp.advancesoft.chase.common.AtomConfigFilter;
import jp.advancesoft.chase.common.ChaseFileChooser;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableForInputInterface;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableModelForTabularData;
import org.apache.log4j.Logger;

public class ImportButton
extends JButton
implements Command {
    private static Logger logger = Logger.getLogger((String)ImportButton.class.getName());
    private Importers importers;
    private TableModel model;
    private TableModel[] modelCell;
    private JTable table;
    private JTable[] cellTable;
    private JComboBox unit;

    public ImportButton(String title, JTable table, TableModel model, JTable[] cellTable, TableModel[] modelCell, Importers importers, EventListener listener) {
        super(title);
        this.table = table;
        this.cellTable = cellTable;
        this.model = model;
        this.modelCell = modelCell;
        this.importers = importers;
        super.addActionListener((ActionListener)listener);
    }

    public ImportButton(String title, JTable table, TableModel model, JTable[] cellTable, TableModel[] modelCell, Importers importers, JComboBox unit, EventListener listener) {
        super(title);
        this.table = table;
        this.cellTable = cellTable;
        this.model = model;
        this.modelCell = modelCell;
        this.importers = importers;
        this.unit = unit;
        super.addActionListener((ActionListener)listener);
    }

    public void execute(EventObject e) {
        ChaseFileChooser fdlg = new ChaseFileChooser("atom");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("select atomic configuration file");
        fdlg.setFileSelectionMode(0);
        fdlg.addChoosableFileFilter(new AtomConfigFilter());
        if (fdlg.showOpenDialog(this) != 0) {
            return;
        }
        File file = fdlg.getSelectedFile();
        if (!this.importers.importAtomicCoordinatesFrom(file)) {
            logger.warn((Object)("failed import from: " + file));
        } else {
            if (this.model instanceof TableModelForTabularData) {
                TableModelForTabularData imodel = (TableModelForTabularData)this.model;
                imodel.clearInputInterfaceTableData();
            }
            this.importers.updateTable(this.model, this.modelCell);
            logger.info((Object)("import from " + file + " complete"));
            if (this.unit != null && file.getName().toLowerCase().endsWith("cif")) {
                this.unit.setSelectedIndex(2);
            }
        }
        if (this.table != null && this.table instanceof TableForInputInterface) {
            TableForInputInterface itable = (TableForInputInterface)this.table;
            itable.updateAll();
        }
    }
}

