/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.inputinterface;

import java.util.Stack;
import java.util.Vector;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntry;
import org.apache.log4j.Logger;

public class InputInterfacePrimitiveEntry
extends InputInterfaceEntry {
    private Logger logger = Logger.getLogger((String)InputInterfacePrimitiveEntry.class.getName());
    private String value = "";
    private String unit = "";
    private Vector listeners = new Vector();

    public InputInterfacePrimitiveEntry() {
    }

    public InputInterfacePrimitiveEntry(String name, String value, String unit) {
        super(name);
        this.value = value;
        this.unit = unit;
    }

    public String getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public int getEntryType() {
        return 0;
    }

    public String toString() {
        return "name: " + this.name + " value: " + this.value + " unit: " + this.unit;
    }

    public InputInterfaceEntry getCopy() {
        return new InputInterfacePrimitiveEntry(new String(this.name), new String(this.value), new String(this.unit));
    }

    public boolean equals(InputInterfaceEntry entry) {
        if (!(entry instanceof InputInterfacePrimitiveEntry)) {
            return false;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
        return pentry.getName().equals(this.name) && pentry.getValue().equals(this.value) && pentry.getUnit().equals(this.unit);
    }

    public void saveState() {
        this.logger.debug((Object)("saving state: name, value, and unit" + this.name + " " + this.value + " " + this.unit));
        InputInterfacePrimitiveEntry buff = new InputInterfacePrimitiveEntry(new String(this.name), new String(this.value), new String(this.unit));
        this.undoStack.push(buff);
    }

    public void undo() {
        InputInterfacePrimitiveEntry old = this.doIt(this.undoStack);
        if (old != null) {
            this.redoStack.push(old);
        }
    }

    public void redo() {
        InputInterfacePrimitiveEntry old = this.doIt(this.redoStack);
        if (old != null) {
            this.undoStack.push(old);
        }
    }

    private InputInterfacePrimitiveEntry doIt(Stack stack) {
        if (stack.empty()) {
            this.logger.info((Object)"stack empty.");
            return null;
        }
        InputInterfacePrimitiveEntry old = (InputInterfacePrimitiveEntry)stack.pop();
        if (old == null) {
            return null;
        }
        this.name = old.getName();
        this.value = old.getValue();
        this.unit = old.getUnit();
        return old;
    }
}

