/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.Axis;
import jas.plot.EditableLabel;
import jas.plot.LayoutFailed;
import jas.plot.SpaceRequirements;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class DataAreaLayout
implements LayoutManager2 {
    public static final String X_AXIS = "x";
    public static final String Y_AXIS_LEFT = "yl";
    public static final String Y_AXIS_RIGHT = "yr";
    public static final String X_AXIS_LABEL = "xl";
    public static final String Y_AXIS_LEFT_LABEL = "yll";
    public static final String Y_AXIS_RIGHT_LABEL = "yrl";
    private Axis xAxis;
    private Axis yAxis_left;
    private Axis yAxis_right;
    private EditableLabel xAxis_label;
    private EditableLabel yAxis_left_label;
    private EditableLabel yAxis_right_label;
    private static final int pad = 5;
    private static final SpaceRequirements nullSpaceRequirements;
    private int xAxisLength = -1;
    private int yLeftAxisLength = -1;
    private int yRightAxisLength = -1;
    private Dimension lastParentSize;
    private static final boolean debug;

    public void addLayoutComponent(Component component, Object object) {
        if (component instanceof Axis) {
            if (X_AXIS.equals(object)) {
                this.xAxis = (Axis)component;
                this.xAxisLength = -1;
            } else if (Y_AXIS_LEFT.equals(object)) {
                this.yAxis_left = (Axis)component;
                this.yLeftAxisLength = -1;
            } else if (Y_AXIS_RIGHT.equals(object)) {
                this.yAxis_right = (Axis)component;
                this.yRightAxisLength = -1;
            }
        } else if (component instanceof EditableLabel) {
            if (X_AXIS_LABEL.equals(object)) {
                this.xAxis_label = (EditableLabel)component;
            } else if (Y_AXIS_LEFT_LABEL.equals(object)) {
                this.yAxis_left_label = (EditableLabel)component;
            } else if (Y_AXIS_RIGHT_LABEL.equals(object)) {
                this.yAxis_right_label = (EditableLabel)component;
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.xAxis) {
            this.xAxis = null;
        } else if (component == this.yAxis_left) {
            this.yAxis_left = null;
        } else if (component == this.yAxis_right) {
            this.yAxis_right = null;
        } else if (component == this.xAxis_label) {
            this.xAxis_label = null;
        } else if (component == this.yAxis_left_label) {
            this.yAxis_left_label = null;
        } else if (component == this.yAxis_right_label) {
            this.yAxis_right_label = null;
        }
    }

    private int getLabelSpaceOnTop() {
        int n = 0;
        if (this.yAxis_left_label != null) {
            n = this.yAxis_left_label.getPreferredSize().height + 5;
        }
        if (this.yAxis_right_label != null && this.yAxis_right != null) {
            n = Math.max(this.yAxis_right_label.getPreferredSize().height, n);
        }
        return n;
    }

    public void layoutContainer(Container container) {
        if (this.yAxis_left != null && this.xAxis != null) {
            int n;
            int n2;
            int n3;
            SpaceRequirements spaceRequirements;
            SpaceRequirements spaceRequirements2;
            SpaceRequirements spaceRequirements3;
            int n4;
            int n5;
            Insets insets;
            int n6;
            Dimension dimension;
            block26: {
                dimension = container.getSize();
                if (dimension.width <= 0 || dimension.height <= 0) {
                    return;
                }
                n6 = this.getLabelSpaceOnTop();
                int n7 = this.xAxis_label != null ? this.xAxis_label.getPreferredSize().height + 5 : 0;
                insets = container.getInsets();
                n5 = dimension.width - insets.right - insets.left;
                n4 = dimension.height - insets.top - insets.bottom - n6 - n7;
                spaceRequirements3 = this.xAxis.type.spaceRequirements;
                spaceRequirements2 = this.yAxis_left.type.spaceRequirements;
                SpaceRequirements spaceRequirements4 = spaceRequirements = this.yAxis_right != null ? this.yAxis_right.type.spaceRequirements : nullSpaceRequirements;
                this.xAxisLength = this.lastParentSize != null && this.xAxisLength > 0 ? (this.xAxisLength += dimension.width - this.lastParentSize.width) : dimension.width * 9 / 10;
                this.yLeftAxisLength = this.lastParentSize != null && this.yLeftAxisLength > 0 ? (this.yLeftAxisLength += dimension.height - this.lastParentSize.height) : dimension.height * 9 / 10;
                this.yRightAxisLength = this.lastParentSize != null && this.yRightAxisLength > 0 && this.yAxis_right != null ? (this.yRightAxisLength += dimension.height - this.lastParentSize.height) : dimension.height * 9 / 10;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                do {
                    int n12;
                    boolean bl = true;
                    if (n8 < 5) {
                        this.xAxis.assumeAxisLength(this.xAxisLength);
                        this.yAxis_left.assumeAxisLength(this.yLeftAxisLength);
                        if (this.yAxis_right != null) {
                            this.yAxis_right.assumeAxisLength(this.yRightAxisLength);
                        }
                    } else {
                        if (debug) {
                            System.out.println("******* USED BACKUP PLAN FOR LAYOUT");
                        }
                        this.xAxis.assumeAxisLength(n9);
                        this.yAxis_left.assumeAxisLength(n10);
                        if (this.yAxis_right != null) {
                            this.yAxis_right.assumeAxisLength(n11);
                        }
                    }
                    n3 = Math.max(spaceRequirements3.width, spaceRequirements2.width) + 3;
                    n2 = Math.max(Math.max(spaceRequirements3.height, spaceRequirements2.height), spaceRequirements.height) + 3;
                    n = Math.max(spaceRequirements3.flowPastEnd, spaceRequirements.width) + 3;
                    int n13 = n3 + n + this.xAxisLength + insets.left + insets.right;
                    if (n13 != dimension.width) {
                        this.xAxisLength = Math.max(0, this.xAxisLength + dimension.width - n13);
                        bl = false;
                    }
                    if ((n12 = n2 + spaceRequirements2.flowPastEnd + 3 + this.yLeftAxisLength + insets.top + insets.bottom) != dimension.height) {
                        this.yLeftAxisLength = Math.max(0, this.yLeftAxisLength + dimension.height - n12);
                        bl = false;
                    }
                    if (this.yAxis_right != null && (n12 = n2 + spaceRequirements.flowPastEnd + 3 + this.yRightAxisLength + insets.top + insets.bottom) != dimension.height) {
                        this.yRightAxisLength = Math.max(0, this.yRightAxisLength + dimension.height - n12);
                        bl = false;
                    }
                    ++n8;
                    if (bl) {
                        if (debug) {
                            System.out.println("layout required " + n8 + " iteration(s)");
                        }
                        break block26;
                    }
                    if (n8 <= 2) continue;
                    if (this.xAxisLength > 0) {
                        if (n9 == 0) {
                            n9 = this.xAxisLength;
                        } else if (this.xAxisLength < n9) {
                            n9 = this.xAxisLength;
                        }
                    }
                    if (this.yLeftAxisLength > 0) {
                        if (n10 == 0) {
                            n10 = this.yLeftAxisLength;
                        } else if (this.yLeftAxisLength < n10) {
                            n10 = this.yLeftAxisLength;
                        }
                    }
                    if (this.yAxis_right == null || this.yRightAxisLength <= 0) continue;
                    if (n11 == 0) {
                        n11 = this.yRightAxisLength;
                        continue;
                    }
                    if (this.yRightAxisLength >= n11) continue;
                    n11 = this.yRightAxisLength;
                } while (n8 < 8);
                throw new LayoutFailed();
            }
            this.yAxis_left.setLocation(n3 - spaceRequirements2.width + insets.left, insets.top + n6);
            this.yAxis_left.setSize(spaceRequirements2.width, n4 - n2 + spaceRequirements2.height);
            if (this.yAxis_left_label != null) {
                this.yAxis_left_label.setLocation(insets.left + 5, insets.top + 5);
                this.yAxis_left_label.setSize(this.yAxis_left_label.getPreferredSize());
            }
            this.xAxis.setLocation(n3 - spaceRequirements3.width + insets.left, n4 + insets.top - n2 + n6);
            this.xAxis.setSize(n5 - n3 + spaceRequirements3.width - n + 3 + spaceRequirements3.flowPastEnd, spaceRequirements3.height);
            if (this.xAxis_label != null) {
                Dimension dimension2 = this.xAxis_label.getPreferredSize();
                this.xAxis_label.setLocation((n5 - n3 - n) / 2 + n3 - dimension2.width / 2 + insets.left, dimension.height - insets.bottom - 5 - dimension2.height);
                this.xAxis_label.setSize(dimension2);
            }
            if (this.yAxis_right != null) {
                this.yAxis_right.setLocation(dimension.width - n - insets.left, insets.top + n6);
                this.yAxis_right.setSize(spaceRequirements.width, n4 - n2 + spaceRequirements.height);
                if (this.yAxis_right_label != null) {
                    Dimension dimension3 = this.yAxis_right_label.getPreferredSize();
                    this.yAxis_right_label.setLocation(dimension.width - insets.right - 5 - dimension3.width, insets.top + 5);
                    this.yAxis_right_label.setSize(dimension3);
                }
            }
            this.lastParentSize = dimension;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(10, 10);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    static {
        boolean bl;
        nullSpaceRequirements = new SpaceRequirements();
        try {
            bl = System.getProperty("debugDataAreaLayout") != null;
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        debug = bl;
    }
}

