/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.SaveAsPlugin;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.RepaintManager;

public class VectorGraphicsTransferable
implements ClipboardOwner,
Transferable {
    private Component component;
    private static DataFlavor imageFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
    private static Map types = new HashMap();

    public VectorGraphicsTransferable(Component component) {
        this.component = component;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.match(imageFlavor)) {
            Image image = this.component.createImage(this.component.getWidth(), this.component.getHeight());
            Graphics graphics = image.getGraphics();
            RepaintManager repaintManager = RepaintManager.currentManager(this.component);
            boolean bl = repaintManager.isDoubleBufferingEnabled();
            repaintManager.setDoubleBufferingEnabled(false);
            this.component.print(graphics);
            graphics.dispose();
            repaintManager.setDoubleBufferingEnabled(bl);
            return image;
        }
        SaveAsPlugin saveAsPlugin = (SaveAsPlugin)types.get(dataFlavor);
        if (saveAsPlugin != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            saveAsPlugin.saveAs(this.component, byteArrayOutputStream, null, this.component);
            byteArrayOutputStream.close();
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[types.size() + 1];
        types.keySet().toArray(dataFlavorArray);
        dataFlavorArray[VectorGraphicsTransferable.types.size()] = imageFlavor;
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor.match(imageFlavor)) {
            return true;
        }
        return types.containsKey(dataFlavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static void register(DataFlavor dataFlavor, SaveAsPlugin saveAsPlugin) {
        types.put(dataFlavor, saveAsPlugin);
    }
}

