/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DefaultFunctionFactory;
import jas.hist.FunctionFactory;
import jas.hist.FunctionFactoryError;
import jas.hist.FunctionListCellRenderer;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.NestedRuntimeException;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JList;

public class FunctionRegistry {
    private Vector m_functions = new Vector();
    private static FunctionRegistry theFunctionRegistry = new FunctionRegistry();
    private FunctionFactory m_selection;
    private JList m_list;

    private FunctionRegistry() {
    }

    public static FunctionRegistry instance() {
        return theFunctionRegistry;
    }

    public void registerFunction(Class clazz, String string) {
        this.registerFunction(this.createFunctionFactory(clazz, string));
    }

    public FunctionFactory createFunctionFactory(Class clazz, String string) {
        try {
            return new DefaultFunctionFactory(clazz, string);
        }
        catch (FunctionFactoryError functionFactoryError) {
            throw new NestedRuntimeException(functionFactoryError);
        }
    }

    public void registerFunction(FunctionFactory functionFactory) {
        this.m_functions.addElement(functionFactory);
    }

    public void removeFunctionFactory(FunctionFactory functionFactory) {
        this.m_functions.removeElement(functionFactory);
    }

    public void removeAllFunctions() {
        this.m_functions.removeAllElements();
    }

    public Enumeration elements() {
        return this.m_functions.elements();
    }

    public int size() {
        return this.m_functions.size();
    }

    public FunctionFactory find(String string) {
        Enumeration enumeration = this.m_functions.elements();
        while (enumeration.hasMoreElements()) {
            FunctionFactory functionFactory = (FunctionFactory)enumeration.nextElement();
            if (!functionFactory.getFunctionName().equals(string)) continue;
            return functionFactory;
        }
        return null;
    }

    public void setContents(Vector vector) {
        this.m_functions = vector;
    }

    FunctionFactory chooseFunction(Frame frame) {
        ChooseFunctionDialog chooseFunctionDialog = new ChooseFunctionDialog(frame);
        if (chooseFunctionDialog.doModal()) {
            return chooseFunctionDialog.getSelectedFunction();
        }
        return null;
    }

    private class ChooseFunctionDialog
    extends JASDialog
    implements ItemListener,
    ActionListener {
        ChooseFunctionDialog(Frame frame) {
            super(frame, "Choose Function...");
            FunctionRegistry.this.m_list = new JList(FunctionRegistry.this.m_functions);
            FunctionRegistry.this.m_list.setCellRenderer(new FunctionListCellRenderer());
            this.getContentPane().add("Center", FunctionRegistry.this.m_list);
            this.pack();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.callEnable();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.onOK();
        }

        public void enableOK(JASState jASState) {
        }

        public void onOK() {
            FunctionRegistry.this.m_selection = (FunctionFactory)FunctionRegistry.this.m_list.getSelectedValue();
            super.onOK();
        }

        public FunctionFactory getSelectedFunction() {
            return FunctionRegistry.this.m_selection;
        }
    }
}

