/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.BaseWindow;
import AbinitMp.Common.ColorData;
import AbinitMp.Common.Constants;
import AbinitMp.Common.ResidueInfoTable;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;

public class ResiduePreferenceWindow
extends BaseWindow {
    private MyButton[] buttons;
    private Vector modifyButtons = new Vector();
    private AbinitMpViewer viewer;
    private int size;

    public ResiduePreferenceWindow(AbinitMpViewer abinitMpViewer) {
        super(MyResourceBundle.getResourceString("ResiduePreferenceWindow.Title"));
        Object object;
        MyButton myButton;
        this.viewer = abinitMpViewer;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.size = Constants.RESIDUE_FULL_NAME.length;
        this.buttons = new MyButton[this.size];
        this.getJMenuBar().add(this.addMenuItem("ResiduePreferenceWindow.fileMenuTitle", "ResiduePreferenceWindow.fileMenu", (Action)new fileListener()));
        MyPanel myPanel = new MyPanel(new GridLayout(0, 2));
        buttonListener buttonListener2 = new buttonListener();
        for (int i = 0; i < this.size; ++i) {
            this.buttons[i] = myButton = new MyButton(Constants.RESIDUE_FULL_NAME[i]);
            myButton.addActionListener(buttonListener2);
            myButton.setActionCommand(Integer.toString(i));
            object = (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[i]);
            if (object == null) {
                object = (ColorData)ResidueInfoTable.get("OTHER");
            }
            myButton.setBackground(((ColorData)object).color.get());
            myButton.setForeground(this.getLabelColor(((ColorData)object).color.get()));
            myPanel.add(myButton);
        }
        MyPanel myPanel2 = new MyPanel(new FlowLayout(1));
        myButton = new MyButton(MyResourceBundle.getResourceString("apply"));
        myPanel2.add(myButton);
        myButton.addActionListener(new applyListener());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)myPanel, "Center");
        this.mainPanel.add((Component)myPanel2, "South");
        this.pack();
        object = Toolkit.getDefaultToolkit().getScreenSize();
        if (((Dimension)object).width > 2000) {
            ((Dimension)object).width /= 2;
        }
        this.setBounds(((Dimension)object).width - 410, 350, 400, 400);
    }

    public void closeProcess() {
        for (int i = 0; i < this.modifyButtons.size(); ++i) {
            MyButton myButton = (MyButton)this.modifyButtons.get(i);
            int n = Integer.parseInt(myButton.getActionCommand());
            ColorData colorData = n < Constants.RESIDUE_NAME.length - 1 ? (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[n]) : (ColorData)ResidueInfoTable.get("OTHER");
            Color color = colorData.color.get();
            myButton.setBackground(color);
            myButton.setForeground(this.getLabelColor(color));
        }
        this.modifyButtons.removeAllElements();
    }

    public void setPreference() {
        for (int i = 0; i < Constants.RESIDUE_FULL_NAME.length; ++i) {
            ColorData colorData = (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[i]);
            if (colorData == null) {
                colorData = (ColorData)ResidueInfoTable.get("OTHER");
            }
            this.buttons[i].setBackground(colorData.color.get());
            this.buttons[i].setForeground(this.getLabelColor(colorData.color.get()));
        }
    }

    class applyListener
    extends AbstractAction {
        applyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ResiduePreferenceWindow.this.modifyButtons.size(); ++i) {
                MyButton myButton = (MyButton)ResiduePreferenceWindow.this.modifyButtons.get(i);
                int n = Integer.parseInt(myButton.getActionCommand());
                ColorData colorData = n < Constants.RESIDUE_NAME.length - 1 ? (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[n]) : (ColorData)ResidueInfoTable.get("OTHER");
                Color color = myButton.getBackground();
                colorData.setColor(color);
                ResiduePreferenceWindow.this.setWaitCursor();
                ResiduePreferenceWindow.this.viewer.displayMoNode();
                ResiduePreferenceWindow.this.setDefaultCursor();
            }
            ResiduePreferenceWindow.this.modifyButtons.removeAllElements();
        }
    }

    class buttonListener
    extends AbstractAction {
        buttonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            int n = Integer.parseInt(myButton.getActionCommand());
            ColorData colorData = n < Constants.RESIDUE_NAME.length - 1 ? (ColorData)ResidueInfoTable.get(Constants.RESIDUE_NAME[n]) : (ColorData)ResidueInfoTable.get("OTHER");
            Color color = colorData.color.get();
            if ((color = JColorChooser.showDialog(myButton, "Color", color)) != null) {
                myButton.setBackground(color);
                myButton.setForeground(ResiduePreferenceWindow.this.getLabelColor(color));
                ResiduePreferenceWindow.this.modifyButtons.add(myButton);
            }
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("ResiduePreferenceWindow.fileMenu");
            char c = string.charAt(0);
            if (ResiduePreferenceWindow.this.getNemonic(stringArray[0]) == c) {
                ResiduePreferenceWindow.this.closeProcess();
                ResiduePreferenceWindow.this.setVisible(false);
            }
        }
    }
}

